/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.erp.ERPConnection;
import com.cognos.xqe.data.providers.relational.erp.ERPDataProvider;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPClientFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPTabularResultSet;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPAdvancedProperties;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConnectionInfo;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPDestinationManager;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.runtree.XDataContext;
import java.util.Locale;

public class SAPConnection
extends ERPConnection {
    private static final String EMPTY_STRING = "";
    private static final String EQUALS_OPERATOR = "=";
    private static final int MESSAGE_SERVER_INDEX = 2;
    private static final int SYSTEM_ID_INDEX = 3;
    private static final int LOGON_GROUP_INDEX = 4;
    private static final int SERVER_INDEX = 1;
    private static final int SYSTEM_NO_INDEX = 2;
    private static final int CLIENT_INDEX = 4;
    private static final int LANGUAGE_INDEX = 5;
    private static final int CLIENT_LB_INDEX = 6;
    private static final int LANGUAGE_LB_INDEX = 7;
    private static final int ROUTER_STRING_INDEX = 3;
    private static final String MAX_CONNECTIONS = "MAX_CONN";
    private static final String TABLE_READ_FUNCTION = "READ_TABLE_FUNCTION_NAME";
    private static final String TABLE_READ_COUNT = "TABLE_READ_COUNT";
    private static final String ABAP_QUERY_ACCESS_LIMIT = "ABAP_QUERY_DB_ACCESSES";
    private String server;
    private String systemNo;
    private String client;
    private String user;
    private String password;
    private String language;
    private int maxConn;
    private String tableReadFunction;
    private int tableRowCount;
    private int abapqueryDBAcessLimit;
    private String messageServer;
    private String systemId;
    private String logonGroup;
    private String routerString;
    private static SAPLogger logger = SAPLoggerFactory.getLogger(SAPConnection.class);

    public SAPConnection(IDataSource dataSource) {
        super(dataSource);
        throw new ERPException(XQEMessageKeys.DS_DataSourceTypeNotSupported, "SAP ECC");
    }

    @Override
    public void connect(Locale locale) {
        IDataSourceConnection dsConnection = this.dataSource.getDataSourceConnection();
        IDataSourceConnectionSignon dataSourceConnectionSignon = dsConnection.getSignon();
        if (dataSourceConnectionSignon != null && dataSourceConnectionSignon instanceof IUsernamePasswordSignon) {
            this.user = ((IUsernamePasswordSignon)dataSourceConnectionSignon).getUserName();
            if (((IUsernamePasswordSignon)dataSourceConnectionSignon).getPassword() != null) {
                this.password = (String)((IUsernamePasswordSignon)dataSourceConnectionSignon).getPassword().decrypt();
            }
        } else if (logger.isDebug()) {
            logger.debug("SignOn details null");
        }
        String connectionString = dsConnection.getConnectionString(null);
        this.parseConnectionString(connectionString);
        SAPConnectionInfo connInfo = this.getSAPConnectionInfo();
        SAPConnectionInfo testConn = (SAPConnectionInfo)connInfo.clone();
        testConn.setPoolingEnabled(false);
        try {
            SAPDestinationManager.testDestination(connInfo);
        }
        catch (Exception e) {
            logger.error("Error in testing destination", e);
            throw new ERPException(XQEMessageKeys.ERP_ConnectionError, e);
        }
        this.setProperty("signon", dsConnection.getSignon());
    }

    private void parseConnectionString(String connectionString) {
        String[] tokens;
        String[] urlTokens;
        if (logger.isDebug()) {
            logger.debug("Parsing connection string " + connectionString);
        }
        if ((urlTokens = (tokens = connectionString.split(";DRIVER_NAME="))[0].split("URL=")).length < 1) {
            throw new ERPException(XQEMessageKeys.ERP_InvalidConnStringFormat);
        }
        String connPropString = urlTokens[1];
        String[] connPropTokens = connPropString.split(";");
        String basicProperties = connPropTokens[0];
        for (int index = 1; index < connPropTokens.length; ++index) {
            String token = connPropTokens[index];
            String[] params = token.split(EQUALS_OPERATOR);
            if (params.length != 2) continue;
            String paramName = params[0];
            if (paramName.equals(MAX_CONNECTIONS)) {
                this.maxConn = Integer.parseInt(params[1]);
                continue;
            }
            if (paramName.equals(ABAP_QUERY_ACCESS_LIMIT)) {
                this.abapqueryDBAcessLimit = Integer.parseInt(params[1]);
                continue;
            }
            if (paramName.equals(TABLE_READ_COUNT)) {
                this.tableRowCount = Integer.parseInt(params[1]);
                continue;
            }
            if (!paramName.equals(TABLE_READ_FUNCTION)) continue;
            this.tableReadFunction = params[1];
        }
        boolean loadBalancing = false;
        String[] connBasicPropTokens = basicProperties.split(":");
        if (!connBasicPropTokens[0].equalsIgnoreCase("SAP")) {
            throw new ERPException(XQEMessageKeys.ERP_InvalidConnStringFormat);
        }
        if (connBasicPropTokens[1].equalsIgnoreCase("LB")) {
            loadBalancing = true;
        }
        if (loadBalancing) {
            this.messageServer = connBasicPropTokens[2];
            this.systemId = connBasicPropTokens[3];
            this.logonGroup = connBasicPropTokens[4];
            this.client = connBasicPropTokens[6];
            this.language = connBasicPropTokens[7];
        } else {
            this.server = connBasicPropTokens[1];
            this.systemNo = connBasicPropTokens[2];
            this.client = connBasicPropTokens[4];
            this.language = connBasicPropTokens[5];
        }
        this.routerString = connBasicPropTokens[3];
        String[] routerStringTokens = this.routerString.split(EQUALS_OPERATOR);
        this.routerString = routerStringTokens.length > 1 ? routerStringTokens[1] : EMPTY_STRING;
    }

    private SAPConnectionInfo getSAPConnectionInfo() {
        SAPConnectionInfo connInfo = new SAPConnectionInfo();
        connInfo.setServer(this.getServer());
        connInfo.setRouterString(this.getRouterString());
        connInfo.setSystemNo(this.getSystemNumber());
        connInfo.setClient(this.getClient());
        connInfo.setLanguage(this.getLanguage());
        connInfo.setLogonGroup(this.getLogonGroup());
        int maxConnsInPool = this.getMaxConnections();
        connInfo.setConnPoolPeakLimit(maxConnsInPool);
        connInfo.setMessageServer(this.getMsgServer());
        connInfo.setSystemId(this.getSystemID());
        connInfo.setUser(this.getUsername());
        connInfo.setPassword(this.getDecryptedPassword());
        return connInfo;
    }

    private String getDecryptedPassword() {
        return this.password;
    }

    private String getUsername() {
        return this.user;
    }

    private String getSystemID() {
        return this.systemId;
    }

    private String getMsgServer() {
        return this.messageServer;
    }

    private int getMaxConnections() {
        return this.maxConn;
    }

    private String getLogonGroup() {
        return this.logonGroup;
    }

    private String getLanguage() {
        return this.language;
    }

    private String getClient() {
        return this.client;
    }

    private String getSystemNumber() {
        return this.systemNo;
    }

    private String getServer() {
        return this.server;
    }

    private String getRouterString() {
        return this.routerString;
    }

    private String getTableReadFunctionName() {
        return this.tableReadFunction;
    }

    private int getTableRowCount() {
        return this.tableRowCount;
    }

    private int getAbapqueryDBAcessLimit() {
        return this.abapqueryDBAcessLimit;
    }

    @Override
    protected SAPTabularResultSet getResultSetImpl(XDataContext context, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, ERPDataProvider dataProvider) {
        if (logger.isDebug()) {
            logger.debug("DATA_REQUEST_STARTED");
        }
        return new SAPTabularResultSet(context, pooledConnection, queryArgs, nodeId, dataProvider);
    }

    protected SAPClient getSAPClient() {
        SAPAdvancedProperties advProp = new SAPAdvancedProperties();
        String tableReadFunctionName = this.getTableReadFunctionName();
        if (tableReadFunctionName.equalsIgnoreCase("RFC_READ_TABLE")) {
            advProp.setParseDecimalValues(false);
            advProp.setTableReadFunDataFieldMaxLength(512);
        } else if (tableReadFunctionName.equalsIgnoreCase("YRFC_READ_TABLE")) {
            advProp.setParseDecimalValues(true);
            advProp.setTableReadFunDataFieldMaxLength(4012);
        }
        advProp.setReadTableFunctionName(this.getTableReadFunctionName());
        advProp.setAbapQueryDbAccesses(this.getAbapqueryDBAcessLimit() + EMPTY_STRING);
        advProp.setRowCount(this.getTableRowCount() + EMPTY_STRING);
        SAPClient sapClient = SAPClientFactory.getSAPClient(this.getSAPConnectionInfo(), advProp);
        return sapClient;
    }

    @Override
    public void disconnect() {
        super.disconnect();
    }
}

