/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLColumnStar;
import com.cognos.xqe.ast.sql.SQLDistinct;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLHaving;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.data.providers.relational.erp.IERPQueryParser;
import com.cognos.xqe.data.providers.relational.erp.IERPWhereClauseHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPABAPWhereClauseHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPRFCWhereClauseHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPTableWhereClauseHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SAPQueryParser
implements IERPQueryParser {
    private static final String CATALOG_ABAP_QUERIES = "ABAP Queries";
    private static final String CATALOG_INFOSET = "Infosets";
    private static final String CATALOG_TABLES = "Tables";
    private static final String CATALOG_BAPIS = "BAPIs";
    private static final String CATALOG_RFCS = "RFCs";
    private String cognosSQL;
    private MetadataConnection metadataConnection;
    private String datasourceName;
    private String tableAlias;
    private String tableName;
    private ArrayList<String> cols = new ArrayList();
    private boolean isDistinct = false;
    private boolean hasGroupBy = true;
    private ArrayList<String> groupByList = new ArrayList();
    private SQLGroupByList groupList;
    private SQLHaving havingNode;
    private String catalogName;
    private String schemaName;
    private IERPWhereClauseHandler whereClauseHandler;
    private static SAPLogger logger = SAPLoggerFactory.getLogger(SAPQueryParser.class);

    public SAPQueryParser(String sql, MetadataConnection mdConnection, String dsName) {
        if (logger.isDebug()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Parsing sql ");
            sb.append(sql);
            sb.append(" DataSource name ");
            sb.append(dsName);
            logger.debug(sb.toString());
        }
        this.cognosSQL = sql;
        this.metadataConnection = mdConnection;
        this.datasourceName = dsName;
    }

    @Override
    public void setSelectables(SQLAlias column) {
        this.cols.add(column.getName());
    }

    @Override
    public void setSelectables(SQLColumn column) {
        this.cols.add(column.getName());
    }

    @Override
    public void setSelectables(SQLColumnStar columnStar) {
        this.cols.add(columnStar.getName());
    }

    @Override
    public void setDistinct(SQLDistinct distinct) {
        this.isDistinct = true;
    }

    @Override
    public void setSelectables(SQLAbstractFunction function) {
        this.cols.add(function.getFunctionName());
    }

    @Override
    public void setGroupBy(SQLGroupBy groupBy) {
        this.hasGroupBy = true;
    }

    @Override
    public void setGroupByList(SQLGroupByList list) {
        this.groupList = list;
    }

    @Override
    public void setHavingNode(SQLHaving sqlHavingNode) {
        this.havingNode = sqlHavingNode;
    }

    @Override
    public void setSortNode(SQLSort sort) {
    }

    @Override
    public void setSortkeyList(SQLSortKeyList list) {
    }

    @Override
    public String getNativeSQL() {
        return null;
    }

    @Override
    public void setTableName(String sqlTableName) {
        this.tableName = sqlTableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumns() {
        return Collections.unmodifiableList(this.cols);
    }

    @Override
    public void setTableAlias(String alias) {
        this.tableAlias = alias;
    }

    @Override
    public void setTableCatalog(String catalog) {
        this.catalogName = catalog;
    }

    @Override
    public void setTableSchema(String schema) {
        this.schemaName = schema;
    }

    public String getTableSchema() {
        return this.schemaName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getTableCatalog() {
        return this.catalogName;
    }

    public QuerySubjectType getQuerySubjectType() {
        if (this.catalogName.equals(CATALOG_ABAP_QUERIES)) {
            return QuerySubjectType.ABAP_QUERY;
        }
        if (this.catalogName.equals(CATALOG_INFOSET)) {
            return QuerySubjectType.INFOSET;
        }
        if (this.catalogName.equals(CATALOG_TABLES)) {
            return QuerySubjectType.TABLE;
        }
        if (this.catalogName.equals(CATALOG_BAPIS)) {
            return QuerySubjectType.BAPI;
        }
        if (this.catalogName.equals(CATALOG_RFCS)) {
            return QuerySubjectType.RFC;
        }
        return null;
    }

    @Override
    public IERPWhereClauseHandler getWhereClauseHandler() {
        if (this.whereClauseHandler == null) {
            List<IMetadata> columnList = this.queryColumnMetadata();
            this.intializeWhereClauseHandler(columnList);
        }
        return this.whereClauseHandler;
    }

    private List<IMetadata> queryColumnMetadata() {
        if (this.metadataConnection == null) {
            return null;
        }
        return this.metadataConnection.getPhysicalMetadata(this.datasourceName, this.getTableCatalog(), this.getTableSchema(), this.getTableName(), true, true);
    }

    private void intializeWhereClauseHandler(List<IMetadata> colList) {
        if (this.getQuerySubjectType() == QuerySubjectType.ABAP_QUERY || this.getQuerySubjectType() == QuerySubjectType.INFOSET) {
            this.whereClauseHandler = new SAPABAPWhereClauseHandler(this.tableName, colList);
        } else if (this.getQuerySubjectType() == QuerySubjectType.BAPI) {
            this.whereClauseHandler = new SAPRFCWhereClauseHandler(this.tableName, colList);
        } else if (this.getQuerySubjectType() == QuerySubjectType.RFC) {
            this.whereClauseHandler = new SAPRFCWhereClauseHandler(this.tableName, colList);
        } else if (this.getQuerySubjectType() == QuerySubjectType.TABLE) {
            this.whereClauseHandler = new SAPTableWhereClauseHandler(this.tableName, colList);
        }
    }

    static enum QuerySubjectType {
        ABAP_QUERY,
        INFOSET,
        BAPI,
        RFC,
        TABLE;

    }
}

