/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEUberNodeFactory;
import com.cognos.xqe.ast.sql.SQLNodeFactory;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.cache.ICaching;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.erp.ERPCancelHandler;
import com.cognos.xqe.data.providers.relational.erp.ERPDataProvider;
import com.cognos.xqe.data.providers.relational.erp.ERPLog;
import com.cognos.xqe.data.providers.relational.erp.ERPQueryNodeVisitor;
import com.cognos.xqe.data.providers.relational.erp.ERPTabularResult;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPABAPWhereClauseHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPConnection;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPQueryParser;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPRFCWhereClauseHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPTableWhereClauseHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPABAPQueryIntrospectorBean;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPIntrospectorBeanFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCInvocation;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPSelectionField;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPUtil;
import com.cognos.xqe.data.providers.relational.erp.sap.resultset.ISAPResultSet;
import com.cognos.xqe.data.providers.relational.erp.sap.resultset.SAPABAPQueryResultSet;
import com.cognos.xqe.data.providers.relational.erp.sap.resultset.SAPMetadataHelper;
import com.cognos.xqe.data.providers.relational.erp.sap.resultset.SAPRFCQueryResultSet;
import com.cognos.xqe.data.providers.relational.erp.sap.resultset.SAPTableQueryResultSet;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IPhysicalTable;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.icu.text.Collator;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class SAPTabularResultSet
extends ERPTabularResult {
    private static final String LEFT_PAREN = "(";
    private static final int DEFAULT_DATETIME_FIELD_LEN = 8;
    private static final String ABAP_QUERY_NAME_VARIENT_SEPARATOR = "::";
    private static final String SAP_USER_GROUP = "sap-query-usergroup";
    private static XQEUberNodeFactory nodeFactory = new XQEUberNodeFactory();
    private IRelationalDataProvider dataProvider;
    protected int nIterators;
    protected IPooledConnection pooledConnection;
    protected SAPConnection connection;
    protected SQLQueryArguments queryArgs;
    protected List<ITabularResultSet> siblings = new ArrayList<ITabularResultSet>();
    protected boolean bCanceled = false;
    protected ERPCancelHandler cancelHandler = null;
    protected IExecutionEnvironment execEnv = null;
    private SAPClient sapClient = null;
    private ISAPResultSet queryTable = null;
    private SAPQueryParser queryParser = null;
    private Hashtable<String, IMetadata> columnsMetadata = new Hashtable();
    private static SAPLogger logger;

    public SAPTabularResultSet(XDataContext context, IPooledConnection pConnection, SQLQueryArguments sqlQueryArgs, Integer nodeId, ERPDataProvider erpDataProvider) {
        super(context, pConnection, sqlQueryArgs, nodeId, erpDataProvider);
        this.dataProvider = erpDataProvider;
        this.pooledConnection = pConnection;
        this.queryArgs = sqlQueryArgs;
        this.cancelHandler = new ERPCancelHandler(this);
        this.execEnv = context.getEnvironment();
        this.execEnv.getCancelManager().addCancelHandler((ICancelable)this.cancelHandler);
        this.connection = (SAPConnection)((Object)this.pooledConnection.getConnection());
        this.rowsetInfo = new RowsetInfo();
        this.sapClient = this.connection.getSAPClient();
        MetadataConnection mdConnection = (MetadataConnection)sqlQueryArgs.getParent().getPlanningEnvironment().getMetadataConnection();
        this.queryParser = this.parseSQL(this.queryArgs.getSQLQuery(), mdConnection, this.queryArgs.getDataSource().getCMDataSourceName());
        List colList = null;
        colList = mdConnection.getPhysicalMetadata(this.queryArgs.getDataSource().getCMDataSourceName(), this.queryParser.getTableCatalog(), this.queryParser.getTableSchema(), this.queryParser.getTableName(), true, true);
        IPhysicalTable table = (IPhysicalTable)colList.get(0);
        for (IMetadata obj : table.getColumns()) {
            this.columnsMetadata.put(obj.getName(), obj);
        }
        List<SAPFieldMetadata> fields = this.getSAPMetadataFields(this.queryParser);
        if (logger.isDebug()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Selected Fields ");
            for (SAPFieldMetadata f : fields) {
                sb.append(f.getName() + ", ");
            }
            logger.debug(sb.toString());
        }
        this.queryTable = this.getResultSet(this.queryParser, fields);
        this.rowsetInfo = sqlQueryArgs.getCalculatedRowsetInfo();
    }

    private ISAPResultSet getResultSet(SAPQueryParser sapQueryParser, List<SAPFieldMetadata> fields) {
        String objectName = sapQueryParser.getTableName();
        SAPQueryParser.QuerySubjectType type = sapQueryParser.getQuerySubjectType();
        if (type == SAPQueryParser.QuerySubjectType.ABAP_QUERY || type == SAPQueryParser.QuerySubjectType.INFOSET) {
            if (logger.isDebug()) {
                logger.debug("Processing ABAP query");
            }
            String attrInfo = this.getAttributeInfo(objectName);
            String[] tokens = attrInfo.split(ABAP_QUERY_NAME_VARIENT_SEPARATOR);
            String usergrp = tokens[0];
            String queryName = tokens[1];
            String varient = null;
            if (tokens.length > 2) {
                varient = tokens[2];
            }
            String queryArea = this.getQueryArea(sapQueryParser.getTableSchema());
            boolean isInfosetQuery = false;
            SAPABAPWhereClauseHandler whereClause = (SAPABAPWhereClauseHandler)sapQueryParser.getWhereClauseHandler();
            List<SAPSelectionField> filters = null;
            if (usergrp.indexOf("SYSTGENERATE") > -1) {
                isInfosetQuery = true;
                filters = whereClause.getFilters(isInfosetQuery);
                queryName = this.processInfosetQuery(queryArea, queryName, fields, filters);
            } else {
                filters = whereClause.getFilters(isInfosetQuery);
            }
            SAPABAPQueryResultSet resultset = new SAPABAPQueryResultSet(this.sapClient, queryArea, usergrp, queryName, filters, varient);
            if (isInfosetQuery) {
                this.deleteGeneratedQuery(queryArea, queryName);
            }
            return resultset;
        }
        if (type == SAPQueryParser.QuerySubjectType.TABLE) {
            if (logger.isDebug()) {
                logger.debug("Processing table query");
            }
            SAPTableWhereClauseHandler whereClause = (SAPTableWhereClauseHandler)sapQueryParser.getWhereClauseHandler();
            String tableName = SAPUtil.removeDescription(objectName);
            return new SAPTableQueryResultSet(this.sapClient, tableName, fields, whereClause.getFilters());
        }
        if (type == SAPQueryParser.QuerySubjectType.BAPI || type == SAPQueryParser.QuerySubjectType.RFC) {
            SAPRFCWhereClauseHandler whereClause;
            List<SAPRFCInvocation> invList;
            if (logger.isDebug()) {
                logger.debug("Processing RFC query");
            }
            if ((invList = (whereClause = (SAPRFCWhereClauseHandler)sapQueryParser.getWhereClauseHandler()).getFilters()).size() == 0) {
                SAPRFCInvocation rfcInv = new SAPRFCInvocation(SAPUtil.removeDescription(objectName));
                invList.add(rfcInv);
            }
            return new SAPRFCQueryResultSet(this.sapClient, invList, sapQueryParser.getColumns());
        }
        return null;
    }

    private String processInfosetQuery(String queryArea, String queryName, List<SAPFieldMetadata> fields, List<SAPSelectionField> selfields) {
        try {
            SAPIntrospectorBeanFactory factory = new SAPIntrospectorBeanFactory(this.sapClient);
            SAPABAPQueryIntrospectorBean abapQueryBean = factory.getSAPABAPQueryIntrospectorBean();
            String internalName = abapQueryBean.getInfosetQuery(queryArea, queryName, fields, selfields);
            boolean customFilter = false;
            for (SAPSelectionField field : selfields) {
                String desc = field.getSelectDesc();
                if (desc.charAt(0) == '_') continue;
                customFilter = true;
                break;
            }
            if (customFilter) {
                Map<String, String> fmap = abapQueryBean.getSelectionFields(queryArea, internalName);
                for (SAPSelectionField selfield : selfields) {
                    String name = selfield.getSelectName();
                    if (!fmap.containsKey(name)) continue;
                    selfield.setSelectName(fmap.get(name));
                }
            }
            return internalName;
        }
        catch (Exception e) {
            logger.debug("Error in processing infoset query");
            throw new XQERuntimeException((Throwable)e);
        }
    }

    private void deleteGeneratedQuery(String queryArea, String query) {
        try {
            SAPIntrospectorBeanFactory factory = new SAPIntrospectorBeanFactory(this.sapClient);
            SAPABAPQueryIntrospectorBean abapQueryBean = factory.getSAPABAPQueryIntrospectorBean();
            abapQueryBean.deleteGeneratedQuery(queryArea, "SYSTGENERATE", query);
        }
        catch (Exception e) {
            logger.debug("Error in deleting Query " + query, e);
        }
    }

    private String getQueryArea(String tableSchema) {
        if (tableSchema.startsWith("Global")) {
            return "Global Area";
        }
        return "Standard Area";
    }

    private String getAttributeInfo(String objectName) {
        int startIndex = objectName.indexOf(LEFT_PAREN);
        if (startIndex != -1) {
            return objectName.substring(startIndex + 1, objectName.length() - 1);
        }
        return objectName;
    }

    private SAPQueryParser parseSQL(String sql, MetadataConnection mdConnection, String dsName) {
        SQLProcessor parser = new SQLProcessor((IXQENodeFactory)nodeFactory);
        try {
            IXQEQueryNode node = parser.parseQuery(sql);
            node.addToIndex();
            SAPQueryParser sapParser = new SAPQueryParser(sql, mdConnection, dsName);
            ((SQLQueryNode)node).accept((SQLQueryNodeVisitor)new ERPQueryNodeVisitor(sapParser), null);
            return sapParser;
        }
        catch (ParseException pe) {
            throw new XQERuntimeException((Throwable)pe);
        }
    }

    private List<SAPFieldMetadata> getSAPMetadataFields(SAPQueryParser sapQueryParser) {
        List<String> cols = sapQueryParser.getColumns();
        ArrayList<SAPFieldMetadata> fields = new ArrayList<SAPFieldMetadata>();
        for (String col : cols) {
            SAPFieldMetadata field = new SAPFieldMetadata();
            field.setName(col);
            IDataType dataType = this.columnsMetadata.get(col).getDataType();
            switch (dataType.getCCLTypeCode()) {
                case 57: 
                case 58: {
                    field.setLength(8);
                    break;
                }
                default: {
                    field.setLength(dataType.getPrecision());
                }
            }
            fields.add(field);
        }
        return fields;
    }

    public ITabularIterator getTabularIterator() {
        if (this.nIterators++ == 0) {
            return new ERPTabularResultIterator(this.getDataContext(), this.nodeId);
        }
        try {
            ITabularResultSet sibling = this.dataProvider.query(this.getDataContext(), this.queryArgs);
            this.siblings.add(sibling);
            return sibling.getTabularIterator();
        }
        catch (XQEException e) {
            ERPLog.getLogger().log("Error in getting tabular iterator");
            ERPLog.getLogger(LogLevel.ERROR).log((Throwable)e);
            throw new XQERuntimeException((Throwable)e);
        }
    }

    protected void releaseImpl() {
        try {
            if (this.pooledConnection != null) {
                this.pooledConnection.returnConnection();
            }
            for (ITabularResultSet sibling : this.siblings) {
                sibling.release();
            }
            if (this.cancelHandler != null) {
                this.execEnv.getCancelManager().removeCancelHandler((ICancelable)this.cancelHandler);
                this.cancelHandler = null;
            }
        }
        finally {
            super.releaseImpl();
        }
    }

    public boolean isCanceled() {
        return this.bCanceled;
    }

    public void setCanceled(boolean cancelled) {
        this.bCanceled = cancelled;
    }

    public IPooledConnection delegatePooledConnection() {
        IPooledConnection result = this.pooledConnection;
        this.pooledConnection = null;
        return result;
    }

    static {
        nodeFactory.addNodeFactory((XQENodeFactory)new SQLNodeFactory());
        PlanningEnvironment env = new PlanningEnvironment();
        env.setPlanningActive(null);
        env.setTrace(new XQETrace());
        nodeFactory.setPlanningEnvironment((IPlanningEnvironment)env);
        logger = SAPLoggerFactory.getLogger(SAPTableQueryResultSet.class);
    }

    protected class ERPTabularResultIterator
    extends XTabularIterator
    implements ICaching {
        private RowValue row;
        private SAPMetadataHelper helper;

        protected ERPTabularResultIterator(XDataContext dataContext, Integer nodeId) {
            super(dataContext, nodeId);
            this.row = DataValueFactory.createRowValue((Collator)this.context.getLocalCollator(), (IRowsetInfo)SAPTabularResultSet.this.rowsetInfo);
            this.helper = new SAPMetadataHelper(SAPTabularResultSet.this.sapClient);
        }

        public Object nextImpl() {
            if (SAPTabularResultSet.this.queryTable.hasNext()) {
                int nofColumns = SAPTabularResultSet.this.rowsetInfo.getNumColumns();
                List<String> colNames = SAPTabularResultSet.this.queryParser.getColumns();
                for (int colIndex = 0; colIndex < nofColumns; ++colIndex) {
                    Value outColumnValue = (Value)this.row.getColumn(colIndex);
                    String colName = colNames.get(colIndex);
                    this.setValue(outColumnValue, colName);
                    this.row.setColumn(colIndex, (IValue)outColumnValue);
                }
                return this.row;
            }
            if (logger.isDebug()) {
                logger.debug("DATA_REQUEST_COMPLETED");
            }
            return null;
        }

        private void setValue(Value outColumnValue, String colName) {
            Object decVal = null;
            IDataType dataType = outColumnValue.getDataType();
            int scale = -1;
            switch (dataType.getCCLTypeCode()) {
                case 1: 
                case 45: 
                case 55: 
                case 56: {
                    outColumnValue.set(SAPTabularResultSet.this.queryTable.getFieldValue(colName, String.class, scale));
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    outColumnValue.set(SAPTabularResultSet.this.queryTable.getFieldValue(colName, Long.class, scale));
                    break;
                }
                case 10: {
                    outColumnValue.set(SAPTabularResultSet.this.queryTable.getFieldValue(colName, Float.class, scale));
                    break;
                }
                case 11: {
                    outColumnValue.set(SAPTabularResultSet.this.queryTable.getFieldValue(colName, Double.class, scale));
                    break;
                }
                case 12: {
                    scale = dataType.getScale();
                    outColumnValue.set(SAPTabularResultSet.this.queryTable.getFieldValue(colName, BigDecimal.class, scale));
                    break;
                }
                case 57: {
                    outColumnValue.set(SAPTabularResultSet.this.queryTable.getFieldValue(colName, Date.class, scale));
                    break;
                }
                case 58: {
                    outColumnValue.set(SAPTabularResultSet.this.queryTable.getFieldValue(colName, Time.class, scale));
                    break;
                }
                default: {
                    outColumnValue.setNull();
                }
            }
        }

        public boolean isCaching() {
            return false;
        }
    }
}

