/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap;

import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLLike;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.IERPWhereClauseHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPUtil;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMetadata;
import java.util.Iterator;
import java.util.List;

public abstract class SAPWhereClauseHandler
implements IERPWhereClauseHandler,
SAPConstants {
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ")";
    private static final int SINGLE_QUOTE_ASCII = 39;
    protected String tableName;
    protected List<IMetadata> tableMetadata;

    public SAPWhereClauseHandler(String tabName, List<IMetadata> metadata) {
        this.tableName = SAPUtil.removeDescription(tabName);
        this.tableMetadata = metadata;
    }

    @Override
    public abstract void handle(SQLLogical var1);

    @Override
    public abstract void handle(SQLLike var1);

    @Override
    public abstract void handle(SQLIsNull var1);

    @Override
    public abstract void handle(SQLIn var1);

    @Override
    public abstract void handle(SQLComparison var1);

    @Override
    public abstract void handle(SQLBetween var1);

    @Override
    public void handle(SQLQueryNode queryNode) {
        if (queryNode instanceof SQLLogical) {
            this.handle((SQLLogical)queryNode);
        } else if (queryNode instanceof SQLLike) {
            this.handle((SQLLike)queryNode);
        } else if (queryNode instanceof SQLIn) {
            this.handle((SQLIn)queryNode);
        } else if (queryNode instanceof SQLIsNull) {
            this.handle((SQLIsNull)queryNode);
        } else if (queryNode instanceof SQLComparison) {
            this.handle((SQLComparison)queryNode);
        } else if (queryNode instanceof SQLBetween) {
            this.handle((SQLBetween)queryNode);
        }
    }

    protected boolean isDecimalField(String tabName, String fieldname) {
        IDataType datatype = this.getDataType(tabName, fieldname);
        if (datatype == null) {
            return false;
        }
        switch (datatype.getCCLTypeCode()) {
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    protected String getTechnicalName(String tabName, String columnName) {
        String desc = null;
        if (columnName != null) {
            int leftParenIndex = columnName.indexOf(LEFT_PAREN);
            int rightParenIndex = columnName.indexOf(RIGHT_PAREN);
            if (leftParenIndex > -1 && rightParenIndex > -1) {
                return columnName.substring(leftParenIndex + 1, rightParenIndex);
            }
        }
        return desc;
    }

    protected IMetadata getField(String tabName, String columnName) {
        IMetadata col;
        block1: {
            IMetadata mObj;
            col = null;
            if (this.tableMetadata == null) {
                return null;
            }
            Iterator<IMetadata> iterator = this.tableMetadata.iterator();
            if (!iterator.hasNext() || !(mObj = iterator.next()).getName().equals(columnName)) break block1;
            col = mObj;
        }
        return col;
    }

    protected IDataType getDataType(String tabName, String columnName) {
        IMetadata col = null;
        if (this.tableMetadata == null) {
            return null;
        }
        col = this.getField(tabName, columnName);
        if (col != null) {
            IDataType datatype = col.getDataType();
            return datatype;
        }
        return null;
    }

    protected String removeApostrophe(String str) {
        int idx2;
        int idx1;
        String temp = str;
        if (str != null && (idx1 = str.indexOf(39)) > -1 && (idx2 = str.indexOf(39, idx1 + 1)) > -1) {
            temp = str.substring(idx1 + 1, idx2);
        }
        return temp;
    }

    protected String getQuotedString(String str) {
        int len;
        if (str != null && (len = str.length()) > 0 && str.charAt(0) != '\'' && str.charAt(len - 1) != '\'') {
            StringBuilder sb = new StringBuilder();
            sb.append('\'');
            sb.append(str);
            sb.append('\'');
            str = sb.toString();
        }
        return str;
    }

    protected String getOperator(SQLComparison.SubType subType) {
        if (subType == SQLComparison.SubType.LESS) {
            return "<";
        }
        if (subType == SQLComparison.SubType.LESSEQUAL) {
            return "<=";
        }
        if (subType == SQLComparison.SubType.GREATER) {
            return ">";
        }
        if (subType == SQLComparison.SubType.GREATEREQUAL) {
            return ">=";
        }
        if (subType == SQLComparison.SubType.EQUAL) {
            return "=";
        }
        if (subType == SQLComparison.SubType.NOTEQUAL) {
            return "<>";
        }
        return null;
    }

    protected String getOperator(SQLLogical.SubType subType) {
        if (subType == SQLLogical.SubType.AND) {
            return "AND";
        }
        if (subType == SQLLogical.SubType.OR) {
            return "OR";
        }
        throw new ERPException(XQEMessageKeys.ERP_OperatorNotSupported, subType.name(), "");
    }
}

