/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap;

import com.cognos.xqe.data.providers.relational.erp.ERPLog;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.trace.LogLevel;

public class XQESAPLogger
implements SAPLogger {
    private static final String SAPECC = "SAPECC";
    private String classname = "";

    public XQESAPLogger(String cname) {
        if (cname != null) {
            this.classname = cname;
            int i = this.classname.lastIndexOf(46) + 1;
            if (i > 0 && i < this.classname.length()) {
                this.classname = this.classname.substring(i);
            }
        }
    }

    @Override
    public void debug(Object logMsg) {
        if (ERPLog.getLogger(LogLevel.TRACE).isOn()) {
            ERPLog.getLogger(LogLevel.TRACE).log(this.getMesage(logMsg));
        }
    }

    private String getMesage(Object msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(SAPECC);
        sb.append(": ");
        sb.append(this.classname);
        sb.append(" - ");
        sb.append(msg);
        return sb.toString();
    }

    @Override
    public void debug(Object msg, Throwable ex) {
        if (ERPLog.getLogger(LogLevel.TRACE).isOn()) {
            ERPLog.getLogger(LogLevel.TRACE).log(this.getMesage(msg), ex);
        }
    }

    @Override
    public void error(String msg) {
        ERPLog.getLogger(LogLevel.ERROR).log(this.getMesage(msg));
    }

    @Override
    public void error(String msg, Throwable ex) {
        ERPLog.getLogger(LogLevel.ERROR).log(this.getMesage(msg), ex);
    }

    @Override
    public void info(Object msg) {
        if (ERPLog.getLogger().isOn()) {
            ERPLog.getLogger().log(this.getMesage(msg));
        }
    }

    @Override
    public void info(Object msg, Throwable ex) {
        if (ERPLog.getLogger().isOn()) {
            ERPLog.getLogger().log(this.getMesage(msg), ex);
        }
    }

    @Override
    public boolean isDebug() {
        return ERPLog.getLogger(LogLevel.TRACE).isOn();
    }
}

