/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPABAPQueryInfo;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFunctionalArea;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPOptionBuilder;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPSelectionField;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTable;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPUtil;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SAPABAPQueryIntrospectorBean
implements SAPConstants {
    private static final String UNEXPECTED_STRING = "D       ";
    private static final String TEXT_FIELD_PREFIX = "Text:";
    private static final SAPLogger logger = SAPLoggerFactory.getLogger(SAPABAPQueryIntrospectorBean.class);
    private final SAPClient sapclient;

    public SAPABAPQueryIntrospectorBean(SAPClient sapclient) {
        this.sapclient = sapclient;
    }

    public List<String> getQueryAreas() {
        ArrayList<String> queryAreas = new ArrayList<String>();
        queryAreas.add("Global Area");
        queryAreas.add("Standard Area");
        return queryAreas;
    }

    public List<SAPFieldMetadata> getABAPQueryFields(String queryArea, String usrGrp, String queryName, String varient) {
        if (logger.isDebug()) {
            StringBuilder sb = new StringBuilder();
            sb.append("getABAPQueryFields()");
            sb.append("queryArea ");
            sb.append(queryArea);
            sb.append("queryName ");
            sb.append(queryName);
            sb.append("usrGrp ");
            sb.append(usrGrp);
            sb.append("varient ");
            sb.append(varient);
            logger.debug(sb.toString());
        }
        ArrayList<SAPFieldMetadata> abapQueryFields = new ArrayList<SAPFieldMetadata>();
        char workplace = SAPUtil.getWorkPlace(queryArea);
        ABAPQueryInfo queryInfo = new ABAPQueryInfo(workplace, usrGrp, queryName);
        JCoFunctionTemplate remoteQueryFieldsTempl = this.sapclient.getFunctionTemplate(SAPConstants.FunctTempl.SAP_ABAP_QUERY_SEL_FIELDS_TEMPL);
        JCoFunction remQurFun = remoteQueryFieldsTempl.getFunction();
        JCoParameterList paramsList = remQurFun.getImportParameterList();
        paramsList.setValue("WORKSPACE", workplace);
        paramsList.setValue("QUERY", queryName);
        paramsList.setValue("USERGROUP", usrGrp);
        this.sapclient.executeRemoteFunction(remQurFun);
        JCoParameterList selTableParams = remQurFun.getTableParameterList();
        JCoTable basicFieldsTable = selTableParams.getTable("FIELDS");
        JCoTable selFieldsTable = selTableParams.getTable("SEL_FIELDS");
        BasicFieldDetailsWrapper fieldWrapper = this.retrieveABAPQueryBasicFieldsDetails(basicFieldsTable, queryInfo);
        List<SAPFieldMetadata> basicFields = fieldWrapper.getFieldList();
        Map<String, String> fieldDescMap = fieldWrapper.getFieldDescMap();
        Map<String, String> runtimeFieldDescMap = fieldWrapper.getRuntimeFieldDescMap();
        List<SAPFieldMetadata> selFields = this.getABAPQuerySelFields(selFieldsTable, fieldDescMap, runtimeFieldDescMap);
        abapQueryFields.addAll(basicFields);
        abapQueryFields.addAll(selFields);
        return abapQueryFields;
    }

    protected BasicFieldDetailsWrapper retrieveABAPQueryBasicFieldsDetails(JCoTable table, ABAPQueryInfo queryInfo) {
        BasicFieldDetailsWrapper basicFieldsWraper = new BasicFieldDetailsWrapper();
        ArrayList<SAPFieldMetadata> basicFieldList = new ArrayList<SAPFieldMetadata>();
        ArrayList<String> fetchFieldDescList = new ArrayList<String>();
        if (table != null && !table.isEmpty()) {
            table.firstRow();
            do {
                String fieldname = table.getString(4);
                char fieldtype = table.getChar(5);
                int outputLength = table.getInt(6);
                int decimal = table.getInt(7);
                if (outputLength == 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("retrieveABAPQueryBasicFieldsDetails");
                    sb.append("Ignoring field having zero output length ");
                    sb.append(fieldname);
                    logger.info(sb.toString());
                    continue;
                }
                SAPFieldMetadata field = SAPFieldMetadata.getSAPFieldMetadata(fieldname, fieldname, fieldtype, 0, outputLength, decimal);
                basicFieldList.add(field);
                fetchFieldDescList.add(fieldname);
            } while (table.nextRow());
        }
        FetchFieldDescMapsWrapper ffwrapper = this.processFetchFieldDescList(fetchFieldDescList);
        Map<String, String> unresolvedFieldsMap = ffwrapper.getUnresolvedFieldsMap();
        Map<String, List<String>> fetchFieldDescMap = ffwrapper.getFetchFieldDescMap();
        Map<String, String> runtimeDesc = null;
        QueryInvoker queryInvoker = new QueryInvoker(queryInfo);
        ExecutorService exeServ = this.sapclient.getExecutorService();
        Future<Map<String, String>> future = exeServ.submit(queryInvoker);
        Map<String, String> fieldDescMap = this.fetchFieldDescriptions(fetchFieldDescMap);
        try {
            runtimeDesc = future.get(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            runtimeDesc = new HashMap<String, String>(0);
        }
        catch (ExecutionException e) {
            runtimeDesc = new HashMap<String, String>(0);
        }
        catch (TimeoutException e) {
            logger.debug("Query is taking too long, skipping runtime descriptions");
            runtimeDesc = new HashMap<String, String>(0);
        }
        HashSet<String> uniqueFieldDescs = new HashSet<String>();
        for (SAPFieldMetadata field : basicFieldList) {
            String fdesc;
            String fieldname = field.getName();
            String fieldDesc = null;
            if (fieldname.startsWith("TEXT")) {
                String desc;
                String[] array = fieldname.split("_");
                String key = null;
                key = array.length == 3 ? SAPUtil.concateNateUsingDelimiter(array[1], array[2]) : unresolvedFieldsMap.get(fieldname);
                if (key != null && (desc = fieldDescMap.get(key)) != null) {
                    StringBuffer sb1 = new StringBuffer(TEXT_FIELD_PREFIX);
                    sb1.append(desc);
                    fieldDesc = sb1.toString();
                }
            } else {
                String key = field.getName();
                String desc = fieldDescMap.get(key);
                if (desc != null) {
                    fieldDesc = desc;
                }
            }
            if (!SAPUtil.isValid(fieldDesc) && runtimeDesc.containsKey(fieldname) && SAPUtil.isValid(fdesc = runtimeDesc.get(fieldname))) {
                fieldDesc = fdesc;
            }
            if (fieldDesc == null) continue;
            if (!uniqueFieldDescs.contains(fieldDesc)) {
                field.setName(fieldDesc);
                uniqueFieldDescs.add(fieldDesc);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(fieldDesc);
            sb.append(" ");
            sb.append(field.getName());
            field.setName(sb.toString());
        }
        basicFieldsWraper.setFieldList(basicFieldList);
        basicFieldsWraper.setFieldDescMap(fieldDescMap);
        basicFieldsWraper.setRunTimeDescMap(runtimeDesc);
        return basicFieldsWraper;
    }

    private FetchFieldDescMapsWrapper processFetchFieldDescList(List<String> fetchFieldDescList) {
        ArrayList<String> unresolvedFields = new ArrayList<String>();
        HashMap<String, List<String>> fetchFieldDescMap = new HashMap<String, List<String>>();
        for (String fieldname : fetchFieldDescList) {
            String[] array;
            String tablename = null;
            String fname = null;
            if (fieldname.startsWith("TEXT") && fieldname.indexOf(95) != -1) {
                array = fieldname.split("_");
                if (array.length == 3) {
                    tablename = array[1];
                    fname = array[2];
                } else {
                    unresolvedFields.add(fieldname);
                }
            } else if (fieldname.indexOf("-") != -1) {
                array = fieldname.split("-");
                if (array.length == 2) {
                    tablename = array[0];
                    fname = array[1];
                } else {
                    unresolvedFields.add(fieldname);
                }
            }
            if (tablename == null || fname == null) continue;
            this.addField(fetchFieldDescMap, tablename, fname);
        }
        Set tabNames = fetchFieldDescMap.keySet();
        HashMap<String, String> unresolvedFieldsMap = new HashMap<String, String>(unresolvedFields.size());
        block1: for (String usfname : unresolvedFields) {
            for (String tabname : tabNames) {
                int i = usfname.indexOf(tabname);
                if (i > -1) {
                    int len = tabname.length();
                    if (usfname.length() <= i + len + 1) continue;
                    String tablename = usfname.substring(i, i + len);
                    String fieldname = usfname.substring(i + len + 1);
                    String key = SAPUtil.concateNateUsingDelimiter(tablename, fieldname);
                    unresolvedFieldsMap.put(usfname, key);
                    this.addField(fetchFieldDescMap, tablename, fieldname);
                    continue block1;
                }
                unresolvedFieldsMap.put(usfname, null);
            }
        }
        return new FetchFieldDescMapsWrapper(unresolvedFieldsMap, fetchFieldDescMap);
    }

    private void addField(Map<String, List<String>> fieldsmap, String tablename, String fname) {
        if (fieldsmap.containsKey(tablename)) {
            List<String> list = fieldsmap.get(tablename);
            if (!list.contains(fname)) {
                list.add(fname);
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(fname);
            fieldsmap.put(tablename, list);
        }
    }

    private Map<String, String> fetchFieldDescriptions(Map<String, List<String>> fieldsmap) {
        String rollname;
        Set<Map.Entry<String, List<String>>> entset = fieldsmap.entrySet();
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("FIELDNAME");
        cols.add("ROLLNAME");
        HashMap<String, String> fieldDetailsMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : entset) {
            String tabname = entry.getKey();
            List<String> fields = entry.getValue();
            if (fields.size() <= 0) continue;
            fields = SAPUtil.getQuotedList(fields);
            SAPOptionBuilder ob = new SAPOptionBuilder();
            ob.buildWhereClause("TABNAME", "=", SAPUtil.getQuotedValue(tabname));
            ob.addANDOperator();
            ob.buildOption("FIELDNAME");
            ob.buildOption(" ");
            ob.buildOption("IN");
            ob.buildOption(" ");
            ob.buildInClauseValues(fields);
            List<String> optionslist = ob.getOptions();
            JCoParameterList plist = this.sapclient.getTableData("DD03L", cols, optionslist, 0, 0);
            SAPTable stable = new SAPTable(plist, this.sapclient);
            StringBuilder sb = new StringBuilder();
            while (stable.next()) {
                String fieldname = stable.getFieldValue("FIELDNAME");
                sb.append(tabname);
                sb.append("-");
                sb.append(fieldname);
                rollname = stable.getFieldValue("ROLLNAME");
                fieldDetailsMap.put(sb.toString(), rollname);
                sb.setLength(0);
            }
        }
        Collection<String> values = fieldDetailsMap.values();
        List<String> rollnames = SAPUtil.getQuotedList(values);
        if (rollnames.size() > 0) {
            SAPOptionBuilder ob = new SAPOptionBuilder();
            ob.buildWhereClause("DDLANGUAGE", "=", SAPUtil.getQuotedValue(this.sapclient.getIsoLanguage()));
            ob.addANDOperator();
            ob.buildOption("ROLLNAME");
            ob.buildOption(" ");
            ob.buildOption("IN");
            ob.buildOption(" ");
            ob.buildInClauseValues(rollnames);
            List<String> options = ob.getOptions();
            cols = new ArrayList();
            cols.add("ROLLNAME");
            cols.add("DDTEXT");
            JCoParameterList plist = this.sapclient.getTableData("DD04T", cols, options, 0, 0);
            SAPTable stable = new SAPTable(plist, this.sapclient);
            HashMap<String, String> descMap = new HashMap<String, String>();
            while (stable.next()) {
                String rollname2 = stable.getFieldValue("ROLLNAME");
                String desc = stable.getFieldValue("DDTEXT");
                descMap.put(rollname2, desc);
            }
            for (Map.Entry entry : fieldDetailsMap.entrySet()) {
                String name = (String)entry.getKey();
                rollname = (String)entry.getValue();
                String desc = (String)descMap.get(rollname);
                fieldDetailsMap.put(name, desc);
            }
        }
        return fieldDetailsMap;
    }

    protected List<SAPFieldMetadata> getABAPQueryBasicFields(JCoTable table) {
        ArrayList<SAPFieldMetadata> queryFields = new ArrayList<SAPFieldMetadata>();
        if (!table.isEmpty()) {
            table.firstRow();
            do {
                String fieldName = table.getString("FNAME");
                String fieldDesc = table.getString("FDESC");
                char fieldType = table.getChar(5);
                int decimal = table.getInt("FDEC");
                int outputLength = table.getInt("FOLEN");
                SAPFieldMetadata field = SAPFieldMetadata.getSAPFieldMetadata(fieldName, fieldDesc, fieldType, 0, outputLength, decimal);
                queryFields.add(field);
            } while (table.nextRow());
        }
        return queryFields;
    }

    private List<SAPFieldMetadata> getABAPQuerySelFields(JCoTable selFieldsTable, Map<String, String> fieldDescMap, Map<String, String> runtimeFieldDescMap) {
        ArrayList<SAPFieldMetadata> selFields = new ArrayList<SAPFieldMetadata>();
        ArrayList<String> fetchFieldDescList = new ArrayList<String>();
        if (selFieldsTable != null && !selFieldsTable.isEmpty()) {
            selFieldsTable.firstRow();
            do {
                char type = selFieldsTable.getChar("TYPE");
                int len = selFieldsTable.getInt("LENGTH");
                char radioButton = selFieldsTable.getChar("CHE_RAD");
                char nodispay = selFieldsTable.getChar("NODISPLAY");
                String fieldName = selFieldsTable.getString("FNAME").trim();
                String spname = selFieldsTable.getString("SPNAME").trim();
                String fieldText = selFieldsTable.getString("FTEXT").trim();
                if (SAPUtil.isValid(fieldText) && fieldText.indexOf(UNEXPECTED_STRING) == -1 && !runtimeFieldDescMap.containsKey(fieldName)) {
                    runtimeFieldDescMap.put(fieldName, fieldText);
                }
                if (radioButton == 'R' || nodispay == 'X' || spname.startsWith("%") || !SAPUtil.isValid(fieldName)) continue;
                SAPFieldMetadata field = SAPFieldMetadata.getSAPFieldMetadata(spname, fieldName, type, 0, len, 0);
                selFields.add(field);
                if (fieldDescMap.containsKey(fieldName)) continue;
                fetchFieldDescList.add(fieldName);
            } while (selFieldsTable.nextRow());
        }
        FetchFieldDescMapsWrapper ffwrapper = this.processFetchFieldDescList(fetchFieldDescList);
        Map<String, String> unresolvedFieldsMap = ffwrapper.getUnresolvedFieldsMap();
        Map<String, List<String>> fetchFieldDescMap = ffwrapper.getFetchFieldDescMap();
        Map<String, String> fdescmap = this.fetchFieldDescriptions(fetchFieldDescMap);
        fieldDescMap.putAll(fdescmap);
        fdescmap = null;
        StringBuilder sb = new StringBuilder();
        HashSet<String> uniqueDescs = new HashSet<String>();
        for (SAPFieldMetadata field : selFields) {
            String temp;
            String desc = null;
            String spname = field.getName();
            String fieldname = field.getText();
            field.setText(spname);
            boolean isTextField = fieldname.startsWith("TEXT");
            if (unresolvedFieldsMap.containsKey(fieldname) && (temp = unresolvedFieldsMap.get(fieldname)) != null) {
                fieldname = temp;
            }
            if (fieldDescMap.containsKey(fieldname)) {
                desc = fieldDescMap.get(fieldname);
            } else if (runtimeFieldDescMap.containsKey(fieldname)) {
                desc = runtimeFieldDescMap.get(fieldname);
            } else {
                desc = spname;
                isTextField = false;
            }
            if (!SAPUtil.isValid(desc)) continue;
            sb.append('_');
            if (isTextField) {
                sb.append(TEXT_FIELD_PREFIX);
            }
            sb.append(desc);
            String tmpdesc = sb.toString();
            if (uniqueDescs.contains(tmpdesc)) {
                sb.append(" ");
                sb.append(field.getText());
            } else {
                uniqueDescs.add(tmpdesc);
            }
            field.setName(sb.toString());
            sb.setLength(0);
        }
        return selFields;
    }

    public String getInfosetQuery(String queryArea, String infoset, List<SAPFieldMetadata> queriedFields, List<SAPSelectionField> filters) {
        String desc;
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> selfields = new ArrayList<String>();
        for (SAPFieldMetadata sAPFieldMetadata : queriedFields) {
            desc = sAPFieldMetadata.getName();
            int i = desc.lastIndexOf("(");
            int j = desc.lastIndexOf(")");
            String techname = desc.substring(i + 1, j);
            if (desc.charAt(0) == '_') continue;
            fields.add(techname);
        }
        for (SAPSelectionField sAPSelectionField : filters) {
            desc = sAPSelectionField.getSelectDesc();
            if (desc.charAt(0) == '_') continue;
            selfields.add(sAPSelectionField.getSelectName());
        }
        return this.generateQuery(queryArea, infoset, fields, selfields);
    }

    public String getInfosetQuery(String queryArea, String infoset) {
        char workplace = SAPUtil.getWorkPlace(queryArea);
        ArrayList<String> fields = new ArrayList<String>();
        JCoFunctionTemplate funAreaTempl = this.sapclient.getFunctionTemplate(SAPConstants.FunctTempl.ABAP_QUERY_FIELDS_FUN_TEMPL);
        JCoFunction function = funAreaTempl.getFunction();
        JCoParameterList importParams = function.getImportParameterList();
        importParams.setValue("WORKSPACE", workplace);
        importParams.setValue("FUNCAREA", infoset);
        if (logger.isDebug()) {
            logger.debug("getInfosetQuery Query area " + queryArea + " infoset " + infoset);
        }
        this.sapclient.executeRemoteFunction(function);
        JCoParameterList tableParams = function.getTableParameterList();
        JCoTable fieldlist = tableParams.getTable("FIELDLIST");
        if (fieldlist != null && !fieldlist.isEmpty()) {
            fieldlist.firstRow();
            do {
                String techName = fieldlist.getString("NAME");
                fields.add(techName);
            } while (fieldlist.nextRow());
        }
        return this.generateQuery(queryArea, infoset, fields, null);
    }

    private String generateQuery(String queryArea, String infoset, List<String> fields, List<String> selFields) {
        char workplace = SAPUtil.getWorkPlace(queryArea);
        StringBuilder sb = new StringBuilder();
        sb.append("Cognos");
        sb.append('_');
        sb.append(infoset);
        sb.append('_');
        sb.append("QUERY");
        String queryTitle = sb.toString();
        JCoFunctionTemplate remoteQueryGenTempl = this.sapclient.getFunctionTemplate(SAPConstants.FunctTempl.ABAP_QUERY_GEN_FUN_TEMPL);
        JCoFunction queryGenFunc = remoteQueryGenTempl.getFunction();
        JCoParameterList qimportParams = queryGenFunc.getImportParameterList();
        qimportParams.setValue("WORKSPACE", workplace);
        qimportParams.setValue("FUNCAREA", infoset);
        qimportParams.setValue("QU_TITLE", queryTitle);
        qimportParams.setValue("WITH_SYSTEM_OBJECTS", "X");
        JCoParameterList tableParameters = queryGenFunc.getTableParameterList();
        JCoTable fieldsTable = tableParameters.getTable("FIELDS");
        for (String field : fields) {
            fieldsTable.appendRow();
            fieldsTable.setValue(0, field);
        }
        if (selFields != null) {
            JCoTable selFieldsTable = tableParameters.getTable("SELECT_FIELDS");
            for (String selfield : selFields) {
                selFieldsTable.appendRow();
                selFieldsTable.setValue(0, selfield);
            }
        }
        this.sapclient.executeRemoteFunction(queryGenFunc);
        String query = queryGenFunc.getExportParameterList().getString("QUERY");
        return query;
    }

    public Map<String, String> getSelectionFields(String queryArea, String query) {
        JCoFunctionTemplate remoteQueryFieldsTempl = this.sapclient.getFunctionTemplate(SAPConstants.FunctTempl.SAP_ABAP_QUERY_SEL_FIELDS_TEMPL);
        JCoFunction remQurFun = remoteQueryFieldsTempl.getFunction();
        JCoParameterList paramsList = remQurFun.getImportParameterList();
        char workplace = SAPUtil.getWorkPlace(queryArea);
        paramsList.setValue("WORKSPACE", workplace);
        paramsList.setValue("QUERY", query);
        paramsList.setValue("USERGROUP", "SYSTGENERATE");
        this.sapclient.executeRemoteFunction(remQurFun);
        JCoParameterList selTableParams = remQurFun.getTableParameterList();
        JCoTable selFieldsTable = selTableParams.getTable("SEL_FIELDS");
        HashMap<String, String> selfields = new HashMap<String, String>();
        if (selFieldsTable != null && !selFieldsTable.isEmpty()) {
            selFieldsTable.firstRow();
            do {
                String fieldName = selFieldsTable.getString("FNAME");
                String spname = selFieldsTable.getString("SPNAME");
                if (fieldName == null || fieldName.trim().length() <= 0) continue;
                selfields.put(fieldName, spname);
            } while (selFieldsTable.nextRow());
        }
        return selfields;
    }

    public List<SAPFunctionalArea> getFunctionalAreas(String queryAreaName) {
        ArrayList<SAPFunctionalArea> funAreas = new ArrayList<SAPFunctionalArea>();
        JCoFunctionTemplate funAreaTempl = this.sapclient.getFunctionTemplate(SAPConstants.FunctTempl.SAP_ABAP_FUN_AREA_INFO_TMPL);
        JCoFunction function = funAreaTempl.getFunction();
        char workplace = SAPUtil.getWorkPlace(queryAreaName);
        JCoParameterList importParams = function.getImportParameterList();
        importParams.setValue("WORKSPACE", workplace);
        if (logger.isDebug()) {
            logger.debug("getFunctionalAreas Query area " + queryAreaName);
        }
        this.sapclient.executeRemoteFunction(function);
        JCoParameterList tableParams = function.getTableParameterList();
        JCoTable funcatalogtable = tableParams.getTable("FUNCAREACATALOG");
        HashSet<String> funAreaDescs = new HashSet<String>();
        if (funcatalogtable != null && !funcatalogtable.isEmpty()) {
            do {
                String area = funcatalogtable.getString(0);
                String text = funcatalogtable.getString(1);
                if (funAreaDescs.contains(text)) continue;
                funAreaDescs.add(text);
                SAPFunctionalArea funarea = new SAPFunctionalArea(area, text);
                funAreas.add(funarea);
            } while (funcatalogtable.nextRow());
        }
        return funAreas;
    }

    public List<SAPABAPQueryInfo> getABAPQueries(String funArea, String queryArea, String queryNameFilter) {
        ArrayList<SAPABAPQueryInfo> abapQueries = new ArrayList<SAPABAPQueryInfo>();
        JCoFunctionTemplate funAreaTempl = this.sapclient.getFunctionTemplate(SAPConstants.FunctTempl.SAP_ABAP_QUERYLIST_FUN_TMPL);
        JCoFunction function = funAreaTempl.getFunction();
        char workplace = SAPUtil.getWorkPlace(queryArea);
        JCoParameterList importParams = function.getImportParameterList();
        importParams.setValue("GENERIC_FUNCAREA", funArea);
        importParams.setValue("WORKSPACE", workplace);
        importParams.setValue("GENERIC_QUERYNAME", queryNameFilter);
        if (logger.isDebug()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Fetching abap query list");
            sb.append(" Infoset ");
            sb.append(funArea);
            sb.append(" Query area ");
            sb.append(queryArea);
            sb.append(" Filter ");
            sb.append(queryNameFilter);
            logger.debug(sb.toString());
        }
        this.sapclient.executeRemoteFunction(function);
        JCoParameterList tableParams = function.getTableParameterList();
        JCoTable queryCatalogtable = tableParams.getTable("QUERYCATALOG");
        HashSet<String> uniqueDescriptions = new HashSet<String>();
        if (!queryCatalogtable.isEmpty()) {
            do {
                String user_group = queryCatalogtable.getString(0);
                String queryname = queryCatalogtable.getString(1);
                String varient = queryCatalogtable.getString(2);
                String querytext = queryCatalogtable.getString(4);
                String varientText = queryCatalogtable.getString(5);
                if (!uniqueDescriptions.contains(querytext)) {
                    uniqueDescriptions.add(querytext);
                } else {
                    querytext = querytext + "-" + queryname;
                }
                SAPABAPQueryInfo query = new SAPABAPQueryInfo(queryname, user_group, querytext, varient, varientText, queryArea);
                abapQueries.add(query);
            } while (queryCatalogtable.nextRow());
        }
        return abapQueries;
    }

    public boolean deleteGeneratedQuery(String queryArea, String usrGroup, String oldQuery) {
        boolean isDeleted = true;
        JCoFunctionTemplate funAreaTempl = this.sapclient.getFunctionTemplate(SAPConstants.FunctTempl.SAP_ABAP_QUERY_DELETE_FUN);
        JCoFunction function = funAreaTempl.getFunction();
        JCoParameterList importParams = function.getImportParameterList();
        char workplace = SAPUtil.getWorkPlace(queryArea);
        importParams.setValue("WORKSPACE", workplace);
        importParams.setValue("QUERY", oldQuery);
        importParams.setValue("USERGROUP", usrGroup);
        importParams.setValue("QUESTION", " ");
        try {
            if (logger.isDebug()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Deleting generated query ");
                sb.append("Query Area ");
                sb.append(queryArea);
                sb.append("User group ");
                sb.append(usrGroup);
                logger.debug(sb.toString());
            }
            this.sapclient.executeRemoteFunction(function);
        }
        catch (Exception e) {
            logger.error("Error in deleting generated ABAP Query", e);
            isDeleted = false;
        }
        return isDeleted;
    }

    private class QueryInvoker
    implements Callable<Map<String, String>> {
        private static final String ABAP_INTROSPECTION_DBACCESS = "100";
        private final ABAPQueryInfo _queryInfo;

        QueryInvoker(ABAPQueryInfo queryInfo) {
            this._queryInfo = queryInfo;
        }

        private Map<String, String> fetchABAPFieldsFromRunTime(ABAPQueryInfo queryInfo) {
            HashMap<String, String> fieldDescMap;
            block5: {
                fieldDescMap = new HashMap<String, String>();
                try {
                    JCoFunctionTemplate queryTempl = SAPABAPQueryIntrospectorBean.this.sapclient.getFunctionTemplate(SAPConstants.FunctTempl.SAP_ABAP_QUERY_FUN_TEMPL);
                    JCoFunction function = queryTempl.getFunction();
                    JCoParameterList iparams = function.getImportParameterList();
                    iparams.setValue("WORKSPACE", queryInfo.getWorkPlace());
                    iparams.setValue("USERGROUP", queryInfo.getUserGroup());
                    iparams.setValue("QUERY", queryInfo.getQueryName());
                    iparams.setValue("DBACC", ABAP_INTROSPECTION_DBACCESS);
                    iparams.setValue("DATA_TO_MEMORY", "X");
                    if (logger.isDebug()) {
                        logger.debug("fetchABAPFieldsFromRunTime");
                    }
                    SAPABAPQueryIntrospectorBean.this.sapclient.executeRemoteFunction(function);
                    JCoParameterList tableParams = function.getTableParameterList();
                    JCoTable table = tableParams.getTable("LISTDESC");
                    if (table != null && !table.isEmpty()) {
                        table.firstRow();
                        do {
                            String fieldName = table.getString("FNAME");
                            String fieldDesc = table.getString("FDESC");
                            if (fieldName == null || fieldDesc == null || fieldDesc.indexOf(SAPABAPQueryIntrospectorBean.UNEXPECTED_STRING) != -1) continue;
                            fieldDescMap.put(fieldName, fieldDesc);
                        } while (table.nextRow());
                    }
                }
                catch (ERPException e) {
                    if (!logger.isDebug()) break block5;
                    logger.debug("Fetching field descriptions - runtime failed!! ", (Throwable)((Object)e));
                }
            }
            return fieldDescMap;
        }

        @Override
        public Map<String, String> call() throws Exception {
            return this.fetchABAPFieldsFromRunTime(this._queryInfo);
        }
    }

    private static class FetchFieldDescMapsWrapper {
        private final Map<String, String> unresolvedFieldsMap;
        private final Map<String, List<String>> fetchFieldDescMap;

        FetchFieldDescMapsWrapper(Map<String, String> unresolvedFieldsMap, Map<String, List<String>> fetchFieldDescMap) {
            this.unresolvedFieldsMap = unresolvedFieldsMap;
            this.fetchFieldDescMap = fetchFieldDescMap;
        }

        protected Map<String, String> getUnresolvedFieldsMap() {
            return this.unresolvedFieldsMap;
        }

        protected Map<String, List<String>> getFetchFieldDescMap() {
            return this.fetchFieldDescMap;
        }
    }

    private static class BasicFieldDetailsWrapper {
        private Map<String, String> fieldDescMap;
        private Map<String, String> runTimeDescMap;
        private List<SAPFieldMetadata> fieldList;

        private BasicFieldDetailsWrapper() {
        }

        protected Map<String, String> getFieldDescMap() {
            return this.fieldDescMap;
        }

        protected void setFieldDescMap(Map<String, String> fieldDescMap) {
            this.fieldDescMap = fieldDescMap;
        }

        protected List<SAPFieldMetadata> getFieldList() {
            return this.fieldList;
        }

        protected void setFieldList(List<SAPFieldMetadata> fieldList) {
            this.fieldList = fieldList;
        }

        protected Map<String, String> getRuntimeFieldDescMap() {
            return this.runTimeDescMap;
        }

        protected void setRunTimeDescMap(Map<String, String> runTimeDescMap) {
            this.runTimeDescMap = runTimeDescMap;
        }
    }

    private static class ABAPQueryInfo {
        private char workPlace;
        private String userGroup;
        private String queryName;

        protected ABAPQueryInfo(char workplace, String userGroup, String queryName) {
            this.workPlace = workplace;
            this.userGroup = userGroup;
            this.queryName = queryName;
        }

        protected char getWorkPlace() {
            return this.workPlace;
        }

        protected String getUserGroup() {
            return this.userGroup;
        }

        protected String getQueryName() {
            return this.queryName;
        }
    }
}

