/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPABAPQueryIntrospectorBean;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPQueryTable;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SAPABAPQueryTable
implements SAPQueryTable,
SAPConstants {
    private static final SAPLogger logger = SAPLoggerFactory.getLogger(SAPABAPQueryTable.class);
    private final JCoTable fieldstable;
    private final JCoTable datatable;
    private final SAPClient sapclient;
    private final Map<String, Integer> fieldDescMap = new HashMap<String, Integer>();
    private final Map<String, Integer> fieldNamesMap = new HashMap<String, Integer>();
    private String data;
    private int datalen;
    private int totalNoOfRows;
    private int begin = 0;
    private int end = 3;
    private boolean readFields;
    private List<String> currentRowFields;
    private SAPABAPQueryIntrospectorBean bean;
    private boolean moveToFirstRow = true;

    public SAPABAPQueryTable(JCoParameterList tableParams, SAPClient sapclient) {
        this.sapclient = sapclient;
        this.fieldstable = tableParams.getTable("LISTDESC");
        this.datatable = tableParams.getTable("LDATA");
        if (!this.datatable.isEmpty()) {
            this.parseFields();
            this.totalNoOfRows = this.datatable.getNumRows();
            this.datatable.firstRow();
            this.data = this.datatable.getString(0);
            this.datalen = this.data.length();
            this.processNextRow();
        }
    }

    private void parseFields() {
        this.bean = new SAPABAPQueryIntrospectorBean(this.sapclient);
        List<SAPFieldMetadata> fields = this.bean.getABAPQueryBasicFields(this.fieldstable);
        for (int i = 0; i < fields.size(); ++i) {
            SAPFieldMetadata field = fields.get(i);
            this.fieldDescMap.put(field.getText().toLowerCase(), i);
            this.fieldNamesMap.put(field.getName(), i);
        }
    }

    private boolean hasData() {
        return this.totalNoOfRows > 0;
    }

    @Override
    public String getFieldValue(String name) {
        String fieldval = null;
        int index = -1;
        if (this.fieldNamesMap.containsKey(name)) {
            index = this.fieldNamesMap.get(name);
        } else {
            String key = name.toLowerCase();
            if (this.fieldDescMap.containsKey(key)) {
                index = this.fieldDescMap.get(key);
            }
        }
        if (index > -1 && index < this.currentRowFields.size()) {
            fieldval = this.currentRowFields.get(index);
        } else {
            logger.debug("getFieldValue() - Field can not be found in the index " + name);
        }
        return fieldval;
    }

    private boolean nextRow() {
        --this.totalNoOfRows;
        return this.datatable.nextRow();
    }

    @Override
    public boolean next() {
        if (this.moveToFirstRow) {
            this.moveToFirstRow = false;
        } else {
            this.processNextRow();
        }
        return this.hasData();
    }

    private void processNextRow() {
        String length;
        this.currentRowFields = new ArrayList<String>();
        int len = -1;
        this.readFields = true;
        while (this.hasData() && this.readFields && (length = this.extractData(this.begin, this.end)) != null) {
            len = Integer.parseInt(length);
            this.begin = this.end + 1;
            this.end = this.end + len + 1;
            String value = this.extractData(this.begin, this.end);
            this.currentRowFields.add(value);
            if (this.isNewRow(this.end)) {
                this.readFields = false;
            }
            this.begin = this.end + 1;
            this.end = this.begin + 3;
        }
    }

    private String extractData(int data_begin, int data_end) {
        String extractedData = null;
        if ((data_begin > this.datalen || data_end > this.datalen) && this.hasData()) {
            String remainingdata = "";
            if (data_begin < this.datalen) {
                remainingdata = this.data.substring(data_begin, this.datalen);
            }
            if (this.nextRow()) {
                this.data = this.getRow(remainingdata);
                this.datalen = this.data.length();
                int adj = 0;
                if (this.data.charAt(0) == ',' || this.data.charAt(0) == ':' || this.data.charAt(0) == ';') {
                    adj = 1;
                }
                int data_length = data_end - data_begin;
                this.begin = data_begin = adj;
                this.end = data_end = data_begin + data_length;
                if (this.isNewRow(this.begin - 1)) {
                    this.readFields = false;
                }
            } else {
                this.data = null;
            }
        }
        if (this.data != null) {
            extractedData = this.data.substring(data_begin, data_end);
        }
        return extractedData;
    }

    private String getRow(String remainingdata) {
        String newdata = this.datatable.getString(0);
        if (newdata != null) {
            newdata = remainingdata + newdata;
        }
        return newdata;
    }

    private boolean isNewRow(int index) {
        boolean flag = false;
        if (index >= 0 && index < this.datalen && this.data.charAt(index) == ';') {
            flag = true;
        }
        return flag;
    }
}

