/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPBORIntrospector;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPBORNode;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPBORWrapper;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCIntrpspectorBean;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoTable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class SAPBAPIIntrospectorBean
implements SAPConstants {
    private static final SAPLogger logger = SAPLoggerFactory.getLogger(SAPBAPIIntrospectorBean.class);
    private final SAPClient sapclient;
    private static ReentrantLock borIntrospectorLock = new ReentrantLock();
    private final SAPRFCIntrpspectorBean rfcintrbean;

    public SAPBAPIIntrospectorBean(SAPClient sapclient) {
        this.sapclient = sapclient;
        this.rfcintrbean = new SAPRFCIntrpspectorBean(sapclient);
    }

    public List<String> getBusinessComponents() {
        SAPBORIntrospector borIntrObj = this.getBORIntrospector();
        return borIntrObj.getBusinessComponents();
    }

    private SAPBORIntrospector getBORIntrospector() {
        SAPBORWrapper borWrapper = this.sapclient.getBorWrapper();
        if (borWrapper == null) {
            try {
                borIntrospectorLock.lockInterruptibly();
                SAPBORWrapper borWrapperObj = this.sapclient.getBorWrapper();
                if (borWrapperObj == null) {
                    SAPBORIntrospector borIntrospector = new SAPBORIntrospector();
                    this.initBORTree(borIntrospector);
                    SAPBORWrapper temp = new SAPBORWrapper(borIntrospector);
                    this.sapclient.setBorWrapper(temp);
                    borWrapperObj = temp;
                }
                borWrapper = borWrapperObj;
            }
            catch (InterruptedException e) {
                throw new ERPException(e);
            }
            finally {
                borIntrospectorLock.unlock();
            }
        }
        return borWrapper.borIntrospector;
    }

    private void initBORTree(SAPBORIntrospector borIntrospector) {
        block10: {
            JCoFunctionTemplate funTmpl = this.getBORFunctionTemplate();
            JCoFunction bapiFun = funTmpl.getFunction();
            try {
                if (logger.isDebug()) {
                    logger.debug("initBORTree");
                }
                this.sapclient.executeRemoteFunction(bapiFun);
                JCoParameterList tableparams = bapiFun.getTableParameterList();
                JCoTable borTable = tableparams.getTable("BOR_TREE");
                if (borTable.isEmpty()) break block10;
                borTable.firstRow();
                do {
                    SAPBORNode parentNode;
                    List<SAPBORNode> children;
                    SAPBORNode node;
                    String id = borTable.getString("ID");
                    String parentId = borTable.getString("PARENT");
                    String extName = borTable.getString("EXT_NAME");
                    String shortText = borTable.getString("SHORT_TEXT");
                    String typeStr = borTable.getString(1);
                    int type = -1;
                    try {
                        type = Integer.parseInt(typeStr);
                    }
                    catch (NumberFormatException e) {
                        logger.debug(e);
                    }
                    SAPBORNode currentNode = new SAPBORNode(id);
                    if (!borIntrospector.containsNode(id)) {
                        currentNode.updateProperties(shortText, extName, parentId, type);
                        borIntrospector.addNode(currentNode);
                    } else {
                        node = borIntrospector.getNode(id);
                        node.updateProperties(shortText, extName, parentId, type);
                    }
                    if (!borIntrospector.containsNode(parentId)) {
                        node = new SAPBORNode(parentId);
                        borIntrospector.addNode(node);
                    }
                    if ((children = (parentNode = borIntrospector.getNode(parentId)).getChildren()) == null) {
                        children = new ArrayList<SAPBORNode>();
                        parentNode.setChildren(children);
                    }
                    children.add(currentNode);
                } while (borTable.nextRow());
            }
            catch (Exception e) {
                logger.error("Error in introspecting BAPIs");
                throw new ERPException(XQEMessageKeys.ERP_IntrospectionError, e);
            }
        }
    }

    private JCoFunctionTemplate getBORFunctionTemplate() {
        return this.sapclient.getFunctionTemplate(SAPConstants.FunctTempl.SAP_BOR_FUN_TEMP);
    }

    public List<String> getObjects(String busCompName) {
        SAPBORIntrospector borIntrObj = this.getBORIntrospector();
        return borIntrObj.getBusinessObjects(busCompName);
    }

    public List<String> getBAPIs(String objType, String methodNameFilter) {
        ArrayList<String> bapis = new ArrayList<String>();
        SAPBORIntrospector borintroObj = this.getBORIntrospector();
        SAPBORNode node = borintroObj.getBORNode(objType);
        LinkedHashSet<String> bapiset = new LinkedHashSet<String>();
        if (borintroObj.isObjectNode(node)) {
            this.getBAPIsForObject(node, bapiset, methodNameFilter);
        } else if (borintroObj.isExpandableNode(node)) {
            this.getBAPIsForChildren(node, bapiset, methodNameFilter);
        }
        bapis.addAll(bapiset);
        return bapis;
    }

    private void getBAPIsForObject(SAPBORNode node, Set<String> bapis, String methodNameFilter) {
        JCoFunctionTemplate funTmpl = this.getBAPIFunctionTemplate();
        JCoFunction bapiFun = funTmpl.getFunction();
        JCoParameterList impparams = bapiFun.getImportParameterList();
        impparams.setValue("WITH_TEXTS", "X");
        impparams.setValue("WITH_OBJECT_NAMES", "X");
        impparams.setValue("LANGUAGE", this.sapclient.getIsoLanguage());
        if (methodNameFilter != null && !methodNameFilter.equals("")) {
            impparams.setValue("METHOD", methodNameFilter);
        }
        if (node != null) {
            String objname = node.getExtName();
            impparams.setValue("OBJECT_NAME", objname);
            try {
                if (logger.isDebug()) {
                    logger.debug("getBAPIsForObject");
                }
                this.sapclient.executeRemoteFunction(bapiFun);
                JCoTable table = bapiFun.getTableParameterList().getTable("API_METHODS");
                if (!table.isEmpty()) {
                    table.firstRow();
                    StringBuilder sb = new StringBuilder();
                    HashSet<String> bapinames = new HashSet<String>();
                    do {
                        String bapi;
                        String name;
                        if (bapinames.contains(name = table.getString("FUNCTION"))) continue;
                        bapinames.add(name);
                        String desc = table.getString("SHORTTEXT");
                        sb.append(name);
                        if (desc != null && desc.length() > 0) {
                            sb.append(" ");
                            sb.append("-");
                            sb.append(" ");
                            sb.append(desc);
                        }
                        if (!bapis.contains(bapi = sb.toString())) {
                            bapis.add(bapi);
                        }
                        sb.setLength(0);
                    } while (table.nextRow());
                }
            }
            catch (Exception e) {
                logger.error("Error in introspecting BAPIs");
                throw new ERPException(XQEMessageKeys.ERP_IntrospectionError, e);
            }
        }
    }

    private void getBAPIsForChildren(SAPBORNode node, Set<String> bapis, String methodNameFilter) {
        List<SAPBORNode> children = node.getChildren();
        if (children != null) {
            for (SAPBORNode childNode : children) {
                String extName = childNode.getExtName();
                if (extName != null && extName.length() == 0) {
                    this.getBAPIsForChildren(childNode, bapis, methodNameFilter);
                    continue;
                }
                this.getBAPIsForObject(childNode, bapis, methodNameFilter);
            }
        }
    }

    private JCoFunctionTemplate getBAPIFunctionTemplate() {
        return this.sapclient.getFunctionTemplate(SAPConstants.FunctTempl.SAP_BAPI_FUN_TMPL);
    }

    public List<SAPFieldMetadata> getBAPIFields(String bapiNameWithDesc) {
        return this.rfcintrbean.getRFCTableFields(bapiNameWithDesc);
    }
}

