/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPBORNode;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SAPBORIntrospector
implements SAPConstants {
    private Map<String, SAPBORNode> borNodes = new HashMap<String, SAPBORNode>();

    protected SAPBORIntrospector() {
    }

    protected boolean containsNode(String id) {
        return this.borNodes.containsKey(id);
    }

    protected void addNode(SAPBORNode node) {
        String id = node.getId();
        this.borNodes.put(id, node);
    }

    protected SAPBORNode getNode(String id) {
        return this.borNodes.get(id);
    }

    protected List<String> getBusinessComponents() {
        List<SAPBORNode> children;
        ArrayList<String> busComps = new ArrayList<String>();
        SAPBORNode rootNode = null;
        for (String key : this.borNodes.keySet()) {
            if (!key.equals("000001")) continue;
            rootNode = this.borNodes.get(key);
            break;
        }
        if (rootNode != null && (children = rootNode.getChildren()) != null) {
            for (SAPBORNode node : children) {
                busComps.add(node.getName());
            }
        }
        return busComps;
    }

    protected List<String> getBusinessObjects(String busCompName) {
        ArrayList<String> busobjects = new ArrayList<String>();
        for (String key : this.borNodes.keySet()) {
            SAPBORNode node = this.borNodes.get(key);
            String nodeName = node.getName();
            if (!busCompName.equals(nodeName)) continue;
            List<SAPBORNode> children = node.getChildren();
            if (children == null) break;
            for (SAPBORNode childNode : children) {
                busobjects.add(childNode.getName());
            }
        }
        return busobjects;
    }

    protected SAPBORNode getBORNode(String namePattern) {
        SAPBORNode node = null;
        for (String key : this.borNodes.keySet()) {
            SAPBORNode cnode = this.borNodes.get(key);
            String nodeName = cnode.getName();
            if (!namePattern.equals(nodeName)) continue;
            node = cnode;
            break;
        }
        return node;
    }

    protected boolean isObjectNode(SAPBORNode node) {
        return node.getType() == 0;
    }

    protected boolean isInterfaceNode(SAPBORNode node) {
        return node.getType() == 1;
    }

    protected boolean isExpandableNode(SAPBORNode node) {
        return !this.isObjectNode(node) && !this.isInterfaceNode(node);
    }
}

