/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class SAPConsoleLogger
implements SAPLogger {
    private SAPConstants.LOG_LEVEL logLevel;
    private String className;

    public SAPConsoleLogger(String name) {
        this.className = name;
        this.setLogLevel(SAPConstants.LOG_LEVEL.INFO);
    }

    public SAPConstants.LOG_LEVEL getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(SAPConstants.LOG_LEVEL logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public boolean isDebug() {
        return this.logLevel.equals((Object)SAPConstants.LOG_LEVEL.DEBUG);
    }

    public boolean isError() {
        return this.logLevel.equals((Object)SAPConstants.LOG_LEVEL.ERROR);
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.isDebug()) {
            System.out.println(this.className + ":" + message);
            System.out.println(this.className + ":" + this.getStackTrace(t));
        }
    }

    @Override
    public void debug(Object message) {
        if (this.isDebug()) {
            System.out.println(this.className + ":" + message);
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        System.out.println(this.className + ":" + this.getStackTrace(t));
    }

    @Override
    public void info(Object message) {
        System.out.println(this.className + ":" + message);
    }

    @Override
    public void error(String message) {
        if (this.isError()) {
            System.out.println(this.className + ":" + message);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.isError()) {
            System.out.println(this.className + ":" + message);
            System.out.println(this.className + ":" + this.getStackTrace(t));
        }
    }

    private String getStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pr = new PrintWriter(sw);
        t.printStackTrace(pr);
        pr.flush();
        return sw.toString();
    }
}

