/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConsoleLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SAPLoggerFactory {
    private static Class<? extends SAPLogger> loggerClass = SAPConsoleLogger.class;
    private static ConcurrentMap<String, SAPLogger> map = new ConcurrentHashMap<String, SAPLogger>();

    public static void setLoggerClass(Class<? extends SAPLogger> loggerClass) {
        SAPLoggerFactory.loggerClass = loggerClass;
    }

    public static SAPLogger getLogger(String classname) {
        SAPLogger saplogger = (SAPLogger)map.get(classname);
        if (saplogger == null) {
            try {
                saplogger = loggerClass.getConstructor(String.class).newInstance(classname);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Error in intializing logger", e);
            }
            catch (SecurityException e) {
                throw new RuntimeException("Error in intializing logger", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Error in intializing logger", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in intializing logger", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error in intializing logger", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Error in intializing logger", e);
            }
            map.put(classname, saplogger);
        }
        return saplogger;
    }

    public static SAPLogger getLogger(Class cls) {
        return SAPLoggerFactory.getLogger(cls.getName());
    }
}

