/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCInvocation;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPUtil;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.util.List;

public class SAPRFCInvocationReader
implements SAPConstants {
    private JCoParameterList importParameters;
    private JCoParameterList exportParameters;
    private JCoParameterList tableParameters;
    private int totalRows = 0;
    private int currentRowNo = 0;

    protected SAPRFCInvocationReader(SAPRFCInvocation rfcinv, List<SAPRFCMetadata> selectedFields) {
        JCoFunction data = rfcinv.getData();
        if (data != null) {
            this.importParameters = data.getImportParameterList();
            this.tableParameters = data.getTableParameterList();
            this.exportParameters = data.getExportParameterList();
            this.parseFields();
        } else {
            this.currentRowNo = -1;
        }
    }

    private void parseFields() {
        JCoTable table;
        if (this.tableParameters != null && (table = this.tableParameters.getTable(0)) != null) {
            this.totalRows = table.getNumRows();
        }
    }

    protected boolean hasData() {
        return this.currentRowNo == 0 || this.currentRowNo < this.totalRows;
    }

    protected boolean nextRow() {
        ++this.currentRowNo;
        return this.hasData();
    }

    protected JCoField fetchField(SAPRFCMetadata queriedField) {
        JCoField field = null;
        if (queriedField.isImportParameter()) {
            field = this.getRFCField(this.importParameters, queriedField);
        } else if (queriedField.isExportParameter()) {
            field = this.getRFCField(this.exportParameters, queriedField);
        } else if (queriedField.isTableParameter()) {
            field = this.getTableParameterValue(queriedField);
        }
        return field;
    }

    private JCoField getRFCField(JCoParameterList parameterList, SAPRFCMetadata saprfcfield) {
        JCoField field = null;
        if (parameterList != null) {
            String fieldname = saprfcfield.getFieldName();
            if (saprfcfield.isStructureParameter()) {
                JCoStructure str = parameterList.getStructure(saprfcfield.getStructureName());
                field = SAPUtil.getField(str.getFieldIterator(), fieldname);
            } else {
                field = SAPUtil.getField(parameterList.getFieldIterator(), fieldname);
            }
        }
        return field;
    }

    private JCoField getTableParameterValue(SAPRFCMetadata rfcfield) {
        JCoField field = null;
        String tablename = rfcfield.getTableName();
        String fieldname = rfcfield.getFieldName();
        JCoTable table = this.tableParameters.getTable(tablename);
        if (table != null && this.currentRowNo < table.getNumRows()) {
            table.setRow(this.currentRowNo);
            field = SAPUtil.getField(table.getFieldIterator(), fieldname);
        }
        return field;
    }
}

