/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCInvocation;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCInvocationReader;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCMetadata;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.sap.conn.jco.JCoField;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SAPRFCQueryTable {
    private static final SAPLogger logger = SAPLoggerFactory.getLogger(SAPRFCQueryTable.class);
    private final List<SAPRFCInvocation> rfcInvocations;
    private final SAPClient sapClient;
    private int processedInvcations;
    private final int totalFunInvCount;
    private final List<SAPRFCMetadata> selectedFields;
    private SAPRFCInvocationReader _rfcInvReader;
    private ReentrantReadWriteLock invReaderLock = new ReentrantReadWriteLock();
    private CompletionService<SAPRFCInvocation> complServ;
    private boolean moveToFirstRow = true;

    public SAPRFCQueryTable(List<SAPRFCInvocation> rfcInvocations, List<SAPRFCMetadata> selectedFields, SAPClient sapclient) {
        this.rfcInvocations = rfcInvocations;
        this.selectedFields = selectedFields;
        this.sapClient = sapclient;
        this.validateSelectedFields();
        this.totalFunInvCount = rfcInvocations.size();
        this.processInvocations();
    }

    private void validateSelectedFields() {
        int i = 0;
        HashSet<String> names = new HashSet<String>();
        for (SAPRFCMetadata sfield : this.selectedFields) {
            String tableName;
            if (!sfield.isTableParameter() || names.contains(tableName = sfield.getTableName())) continue;
            names.add(tableName);
            if (++i <= 1) continue;
            throw new ERPException(XQEMessageKeys.ERP_RFCQueryError);
        }
    }

    private void processInvocations() {
        ExecutorService executor = this.sapClient.getExecutorService();
        this.complServ = new ExecutorCompletionService<SAPRFCInvocation>(executor);
        for (SAPRFCInvocation rfcInv : this.rfcInvocations) {
            SAPFunctionInvocationTask task = new SAPFunctionInvocationTask(rfcInv, this.sapClient);
            this.complServ.submit(task, rfcInv);
        }
        if (this.isSAPRFCInvocationAvailable()) {
            SAPRFCInvocation rfcInvocation = this.getNextSAPRFCInvocation();
            SAPRFCInvocationReader invreader = new SAPRFCInvocationReader(rfcInvocation, this.selectedFields);
            if (!invreader.hasData()) {
                while (!this.moveToNextReader()) {
                }
            } else {
                this.setSAPRFCInvocationReader(invreader);
            }
        }
    }

    private SAPRFCInvocationReader getSAPRFCInvocationReader() {
        try {
            this.invReaderLock.readLock().lock();
            SAPRFCInvocationReader sAPRFCInvocationReader = this._rfcInvReader;
            return sAPRFCInvocationReader;
        }
        finally {
            this.invReaderLock.readLock().unlock();
        }
    }

    private void setSAPRFCInvocationReader(SAPRFCInvocationReader reader) {
        try {
            this.invReaderLock.writeLock().lock();
            this._rfcInvReader = reader;
        }
        finally {
            this.invReaderLock.writeLock().unlock();
        }
    }

    private SAPRFCInvocation getNextSAPRFCInvocation() {
        SAPRFCInvocation rfcInv = null;
        try {
            rfcInv = this.complServ.take().get();
        }
        catch (InterruptedException e) {
            throw new ERPException(e);
        }
        catch (ExecutionException e) {
            throw new ERPException(e);
        }
        ++this.processedInvcations;
        return rfcInv;
    }

    private boolean isSAPRFCInvocationAvailable() {
        return this.processedInvcations != this.totalFunInvCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveToNextReader() {
        boolean isDataAvailable = false;
        this.invReaderLock.writeLock().lock();
        try {
            if (this._rfcInvReader == null || !this._rfcInvReader.hasData()) {
                while (this.isSAPRFCInvocationAvailable()) {
                    SAPRFCInvocation rfcInvocation = this.getNextSAPRFCInvocation();
                    SAPRFCInvocationReader invreaderObj = new SAPRFCInvocationReader(rfcInvocation, this.selectedFields);
                    if (!invreaderObj.hasData()) continue;
                    this._rfcInvReader = invreaderObj;
                    isDataAvailable = true;
                    break;
                }
            } else {
                isDataAvailable = true;
                this._rfcInvReader.nextRow();
            }
            if (!isDataAvailable) {
                this._rfcInvReader = null;
            }
        }
        finally {
            this.invReaderLock.writeLock().unlock();
        }
        return isDataAvailable;
    }

    public boolean next() {
        boolean isDataAvailable = false;
        try {
            this.invReaderLock.readLock().lock();
            if (this._rfcInvReader != null && this._rfcInvReader.hasData()) {
                if (this.moveToFirstRow) {
                    this.moveToFirstRow = false;
                    isDataAvailable = true;
                } else {
                    isDataAvailable = this._rfcInvReader.nextRow();
                }
            }
        }
        finally {
            this.invReaderLock.readLock().unlock();
        }
        if (!isDataAvailable) {
            isDataAvailable = this.moveToNextReader();
        }
        return isDataAvailable;
    }

    public Long getLong(SAPRFCMetadata rfcMetaData) {
        JCoField field = this.getSAPRFCInvocationReader().fetchField(rfcMetaData);
        if (field != null) {
            return field.getBigDecimal().longValue();
        }
        return null;
    }

    public BigDecimal getBigDecimal(SAPRFCMetadata rfcMetaData) {
        JCoField field = this.getSAPRFCInvocationReader().fetchField(rfcMetaData);
        if (field != null) {
            return field.getBigDecimal();
        }
        return null;
    }

    public Float getFloat(SAPRFCMetadata rfcMetaData) {
        JCoField field = this.getSAPRFCInvocationReader().fetchField(rfcMetaData);
        if (field != null) {
            return Float.valueOf(field.getBigDecimal().floatValue());
        }
        return null;
    }

    public Date getTime(SAPRFCMetadata rfcMetaData) {
        JCoField field = this.getSAPRFCInvocationReader().fetchField(rfcMetaData);
        if (field != null) {
            return field.getTime();
        }
        return null;
    }

    public String getString(SAPRFCMetadata rfcMetaData) {
        JCoField field = this.getSAPRFCInvocationReader().fetchField(rfcMetaData);
        if (field != null) {
            return field.getString();
        }
        return null;
    }

    public Date getDate(SAPRFCMetadata rfcMetaData) {
        JCoField field = this.getSAPRFCInvocationReader().fetchField(rfcMetaData);
        if (field != null) {
            return field.getDate();
        }
        return null;
    }

    private static class SAPFunctionInvocationTask
    implements Runnable {
        private final SAPRFCInvocation rfcInvocation;
        private final SAPClient sapClient;

        public SAPFunctionInvocationTask(SAPRFCInvocation rfcInvocation, SAPClient sapClient) {
            this.rfcInvocation = rfcInvocation;
            this.sapClient = sapClient;
        }

        @Override
        public void run() {
            try {
                this.sapClient.executeRFCQuery(this.rfcInvocation);
            }
            catch (ERPException e) {
                logger.error("Error in executiong RFC - " + this.rfcInvocation.getRfc(), (Throwable)((Object)e));
            }
        }
    }
}

