/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPQueryTable;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoTable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SAPTable
implements SAPQueryTable,
SAPConstants {
    private static final SAPLogger logger = SAPLoggerFactory.getLogger(SAPTable.class);
    private final JCoTable data;
    private final JCoTable fields;
    private final String serverCharSet;
    private final int fieldLen;
    private Map<String, Integer> fieldIndex;
    private SAPFieldMetadata[] tableFields;
    private boolean useServerEncoding = false;
    private boolean moveToFirstRow = true;

    public SAPTable(JCoParameterList tabledata, SAPClient client) {
        JCoTable datatable = null;
        JCoTable fieldstable = null;
        if (tabledata != null) {
            datatable = tabledata.getTable("DATA");
            fieldstable = tabledata.getTable("FIELDS");
        }
        this.data = datatable;
        this.fields = fieldstable;
        this.fieldLen = client.getTableReadFunDataFieldMaxLength();
        if (this.data != null && !this.data.isEmpty()) {
            this.data.firstRow();
        }
        this.parseFields();
        this.serverCharSet = client.getServerCharSet();
        if (this.serverCharSet != null) {
            this.useServerEncoding = true;
        }
    }

    @Override
    public boolean next() {
        if (this.moveToFirstRow) {
            this.moveToFirstRow = false;
            return !this.data.isEmpty();
        }
        return this.data.nextRow();
    }

    /*
     * Unable to fully structure code
     */
    protected String getFieldValue(SAPFieldMetadata obj) {
        offset = obj.getOffset();
        len = obj.getLength();
        rowdatalen = -1;
        fieldValue = null;
        if (this.useServerEncoding) {
            try {
                byteArray = this.data.getString(0).getBytes(this.serverCharSet);
                rowdatalen = byteArray.length;
                if (offset + len <= rowdatalen) {
                    fieldValue = new String(byteArray, offset, len, this.serverCharSet);
                }
                if (offset >= rowdatalen) ** GOTO lbl26
                fieldValue = new String(byteArray, offset, rowdatalen - offset, this.serverCharSet);
            }
            catch (UnsupportedEncodingException e) {
                throw new ERPException(e);
            }
        } else {
            row = this.data.getString(0);
            rowdatalen = row.length();
            if (offset + len <= rowdatalen) {
                fieldValue = row.substring(offset, offset + len);
            } else if (offset < rowdatalen) {
                fieldValue = row.substring(offset);
            }
            if (fieldValue != null) {
                fieldValue = new String(fieldValue.toCharArray());
            }
        }
lbl26:
        // 6 sources

        if (fieldValue != null) {
            fieldValue = fieldValue.trim();
        }
        return fieldValue;
    }

    private void parseFields() {
        if (this.fields != null) {
            this.fieldIndex = new HashMap<String, Integer>();
            ArrayList<SAPFieldMetadata> fieldList = new ArrayList<SAPFieldMetadata>();
            this.fields.firstRow();
            int index = 0;
            String fieldName = null;
            do {
                int fieldLength = this.fields.getInt(2);
                fieldName = this.fields.getString(0);
                if (fieldLength <= this.fieldLen) {
                    char fieldType = this.fields.getChar(3);
                    int fieldOffset = this.fields.getInt(1);
                    String fieldDesc = this.fields.getString(4);
                    SAPFieldMetadata fieldmeta = SAPFieldMetadata.getSAPFieldMetadata(fieldName, fieldDesc, fieldType, fieldOffset, fieldLength, 0);
                    fieldList.add(fieldmeta);
                    this.fieldIndex.put(fieldName, index++);
                    continue;
                }
                logger.info("FIELD_IGNORED " + fieldName + " is ignored as its length exceeds maximum table row length.");
            } while (this.fields.nextRow());
            this.tableFields = fieldList.toArray(new SAPFieldMetadata[index]);
        }
    }

    protected SAPFieldMetadata getField(int index) {
        return this.tableFields[index];
    }

    @Override
    public String getFieldValue(String name) {
        int index = this.fieldIndex.get(name);
        SAPFieldMetadata field = this.tableFields[index];
        return this.getFieldValue(field);
    }

    protected SAPFieldMetadata[] getFields() {
        return this.tableFields;
    }

    protected int getRowCount() {
        int count = 0;
        if (this.data != null) {
            count = this.data.getNumRows();
        }
        return count;
    }
}

