/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPOptionBuilder;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTable;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPUtil;
import com.sap.conn.jco.JCoParameterList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

public class SAPTableDescBatchTask
implements Runnable {
    private final List<String> _tableBatch;
    private final SAPClient _client;
    private static final SAPLogger logger = SAPLoggerFactory.getLogger(SAPTableDescBatchTask.class);
    private BlockingQueue<Map> queue;

    protected SAPTableDescBatchTask(List<String> _tableBatch, SAPClient client, BlockingQueue<Map> queue) {
        this._tableBatch = _tableBatch;
        this._client = client;
        this.queue = queue;
    }

    @Override
    public void run() {
        try {
            HashMap<String, String> tableDescsMap = new HashMap<String, String>();
            SAPOptionBuilder optionBuilder = new SAPOptionBuilder();
            String[] fields = new String[]{"TABNAME", "DDTEXT"};
            String language = this._client.getIsoLanguage();
            String langfilter = SAPUtil.getQuotedValue(language);
            optionBuilder.buildWhereClause("DDLANGUAGE", "=", langfilter);
            optionBuilder.addANDOperator();
            optionBuilder.buildOption(" ");
            optionBuilder.buildOption("TABNAME");
            optionBuilder.buildOption(" ");
            optionBuilder.buildOption("IN");
            optionBuilder.buildOption(" ");
            optionBuilder.buildInClauseValues(this._tableBatch);
            String[] options = optionBuilder.getOptionsArray();
            Map<String, String> importparams = SAPUtil.getImporParams("DD02T", "0", "0");
            JCoParameterList parameterList = this._client.getData(fields, options, importparams, false);
            SAPTable sapTable = new SAPTable(parameterList, this._client);
            while (sapTable.next()) {
                tableDescsMap.put(sapTable.getFieldValue("TABNAME"), sapTable.getFieldValue("DDTEXT"));
            }
            this.queue.add(tableDescsMap);
        }
        catch (Exception e) {
            logger.error("Query execution failed", e);
            this.putTerminator();
        }
    }

    private void putTerminator() {
        try {
            this.queue.put(new HashMap(1));
        }
        catch (InterruptedException e) {
            logger.debug(e);
        }
    }
}

