/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPOptionBuilder;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTable;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTableDesc;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPUtil;
import com.sap.conn.jco.JCoParameterList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SAPTableIntrospectorBean
implements SAPConstants {
    private static final SAPLogger logger = SAPLoggerFactory.getLogger(SAPTableIntrospectorBean.class);
    private final SAPClient sapclient;

    public SAPTableIntrospectorBean(SAPClient sapclient) {
        this.sapclient = sapclient;
    }

    public String[] getSAPTableGroups() {
        ArrayList<String> folderlist = new ArrayList<String>();
        for (int i = 65; i <= 90; ++i) {
            String s = "" + (char)i;
            folderlist.add(s);
        }
        folderlist.add("/");
        String[] names = folderlist.toArray(new String[1]);
        return names;
    }

    public String[] getSAPSchema(String tableGrpName) {
        int i;
        ArrayList<String> schemalist = new ArrayList<String>();
        String str = tableGrpName + "/";
        schemalist.add(str);
        for (i = 65; i <= 90; ++i) {
            str = tableGrpName + (char)i;
            schemalist.add(str);
        }
        str = tableGrpName + "_";
        schemalist.add(str);
        for (i = 48; i <= 57; ++i) {
            str = tableGrpName + (char)i;
            schemalist.add(str);
        }
        String[] schemanames = schemalist.toArray(new String[1]);
        return schemanames;
    }

    private List<String> getTableNames(String schemaName, String tableNameFilter) {
        ArrayList<String> tableNames = new ArrayList<String>();
        String[] fields = new String[]{"TABNAME"};
        ArrayList<String> tabTypes = new ArrayList<String>();
        for (String tabtype : SAP_TABLE_TYPES) {
            String val = SAPUtil.getQuotedValue(tabtype);
            tabTypes.add(val);
        }
        SAPOptionBuilder optionBuilder = new SAPOptionBuilder();
        optionBuilder.buildOption(" ");
        optionBuilder.buildOption("TABCLASS");
        optionBuilder.buildOption(" ");
        optionBuilder.buildOption("IN");
        optionBuilder.buildOption(" ");
        optionBuilder.buildInClauseValues(tabTypes);
        optionBuilder.addANDOperator();
        StringBuilder sb = new StringBuilder();
        sb.append(schemaName);
        sb.append("%");
        schemaName = schemaName.indexOf("_") != -1 ? SAPUtil.escapeSpecialCharacters(sb.toString(), "_") : sb.toString();
        String schemafilter = SAPUtil.getQuotedValue(schemaName);
        optionBuilder.buildOption(" ");
        optionBuilder.buildOption("TABNAME");
        optionBuilder.buildOption(" ");
        optionBuilder.buildOption("LIKE");
        optionBuilder.buildOption(" ");
        optionBuilder.buildOption(schemafilter);
        if (SAPUtil.isValid(tableNameFilter)) {
            tableNameFilter = SAPUtil.removeDescription(tableNameFilter);
            optionBuilder.addANDOperator();
            String tblnamefilter = SAPUtil.getQuotedValue(tableNameFilter);
            optionBuilder.buildWhereClause("TABNAME", "LIKE", tblnamefilter);
        }
        String[] options = optionBuilder.getOptionsArray();
        Map<String, String> importparams = SAPUtil.getImporParams("DD02L", "0", "0");
        JCoParameterList parameterList = this.sapclient.getData(fields, options, importparams, false);
        SAPTable saptable = new SAPTable(parameterList, this.sapclient);
        while (saptable.next()) {
            String tname = saptable.getFieldValue("TABNAME");
            tableNames.add(tname);
        }
        return tableNames;
    }

    public List<String> getTablesNamesWithDesc(String schemaName, String tableNameFilter) {
        List<String> shortTableNames = this.getTableNames(schemaName, tableNameFilter);
        int tabListSize = shortTableNames.size();
        List<String> tableNames = null;
        if (tabListSize > 0) {
            HashMap<String, String> tableDescsMap = new HashMap<String, String>();
            List<String> snames1 = SAPUtil.getQuotedList(shortTableNames);
            int head = 0;
            int tail = 1000;
            ArrayList<List<String>> batchTableList = new ArrayList<List<String>>();
            while (head < tabListSize) {
                List<String> batchList = null;
                batchList = tail < tabListSize ? snames1.subList(head, tail) : snames1.subList(head, tabListSize);
                batchTableList.add(batchList);
                head = tail;
                tail += 1000;
            }
            SAPTableDesc tab = new SAPTableDesc(batchTableList, this.sapclient);
            try {
                while (tab.hasNext()) {
                    Map<String, String> tableDescriptions = tab.next();
                    tableDescsMap.putAll(tableDescriptions);
                }
            }
            catch (Exception e) {
                logger.error("Error in retrieving table descriptions", e);
            }
            if (tableDescsMap.size() > 0) {
                tableNames = new ArrayList();
                StringBuilder sbuildr = new StringBuilder();
                for (String tabname : shortTableNames) {
                    if (tableDescsMap.containsKey(tabname)) {
                        sbuildr.append(tabname);
                        sbuildr.append(" ");
                        sbuildr.append("-");
                        sbuildr.append(" ");
                        sbuildr.append((String)tableDescsMap.get(tabname));
                        tableNames.add(sbuildr.toString());
                        sbuildr.setLength(0);
                        continue;
                    }
                    tableNames.add(tabname);
                }
            } else {
                tableNames = shortTableNames;
            }
        } else {
            tableNames = new ArrayList<String>();
        }
        return tableNames;
    }

    public List<SAPFieldMetadata> getSAPTableFields(String tablename) {
        tablename = SAPUtil.removeDescription(tablename);
        ArrayList<SAPFieldMetadata> list = new ArrayList<SAPFieldMetadata>();
        HashMap<String, String> importparams = new HashMap<String, String>();
        importparams.put("QUERY_TABLE", tablename);
        importparams.put("NO_DATA", "X");
        JCoParameterList parameterList = this.sapclient.getData(null, null, importparams, false);
        if (parameterList != null) {
            SAPTable tableFields = new SAPTable(parameterList, this.sapclient);
            SAPFieldMetadata[] fields = tableFields.getFields();
            HashMap<String, SAPFieldMetadata> fieldsMap = new HashMap<String, SAPFieldMetadata>();
            for (SAPFieldMetadata sfield : fields) {
                fieldsMap.put(sfield.getName(), sfield);
            }
            SAPTable fieldMetadataTable = this.getFieldMetadata(tablename);
            while (fieldMetadataTable.next()) {
                String mandatory;
                String fieldName = fieldMetadataTable.getFieldValue("FIELDNAME");
                SAPFieldMetadata tField = (SAPFieldMetadata)fieldsMap.get(fieldName);
                if (tField == null) continue;
                String keyflag = fieldMetadataTable.getFieldValue("KEYFLAG");
                if (keyflag != null && keyflag.equals("X")) {
                    tField.setKey(true);
                }
                if ((mandatory = fieldMetadataTable.getFieldValue("MANDATORY")) != null && mandatory.equals("X")) {
                    tField.setMandatory(true);
                }
                String decimalStr = fieldMetadataTable.getFieldValue("DECIMALS");
                try {
                    if (decimalStr != null) {
                        int decimal = Integer.parseInt(decimalStr);
                        tField.setDecimal(decimal);
                    }
                }
                catch (NumberFormatException e) {
                    logger.error("Error in parsing decimal value", e);
                }
                list.add(tField);
            }
        }
        return list;
    }

    private SAPTable getFieldMetadata(String tablename) {
        Map<String, String> importparams = SAPUtil.getImporParams("DD03L", "0", "0");
        String[] fields = new String[]{"FIELDNAME", "KEYFLAG", "MANDATORY", "DOMNAME", "DECIMALS"};
        SAPOptionBuilder optionBuilder = new SAPOptionBuilder();
        optionBuilder.buildWhereClause("TABNAME", "=", SAPUtil.getQuotedValue(tablename));
        String[] options = optionBuilder.getOptionsArray();
        JCoParameterList parameterList = this.sapclient.getData(fields, options, importparams, false);
        SAPTable saptable = new SAPTable(parameterList, this.sapclient);
        return saptable;
    }
}

