/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPQueryTable;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTable;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTablesWrapper;
import com.sap.conn.jco.JCoParameterList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

class SAPTableQueryBatchProcessor
implements Runnable {
    private static final SAPLogger logger = SAPLoggerFactory.getLogger(SAPTableQueryBatchProcessor.class);
    private final String _tableName;
    private final List<SAPFieldMetadata> _fields;
    private final List<String> _options;
    private final SAPClient _client;
    private final BlockingQueue<SAPQueryTable> _queryResultQueue;
    private int _totalRetrievedRows;
    private int _returnedRowCount;
    private int _rowCount;
    private int _batchSize;
    private int _rowSkips;
    private volatile ERPException _queryExecException;
    private final SAPQueryTable _executionComplete;
    private final int _tableReadFunDataFieldMaxLength;

    protected SAPTableQueryBatchProcessor(String tableName, List<SAPFieldMetadata> fields, List<String> options, SAPClient client) {
        this._tableName = tableName;
        this._fields = fields;
        this._options = options;
        this._client = client;
        int queueSize = 20;
        this._queryResultQueue = new ArrayBlockingQueue<SAPQueryTable>(queueSize);
        this._rowCount = client.getTableRowCount();
        this._batchSize = client.getTableQueryBatchSize();
        this._executionComplete = new SAPTable(null, client);
        this._tableReadFunDataFieldMaxLength = client.getTableReadFunDataFieldMaxLength();
    }

    protected SAPQueryTable getNext() {
        SAPQueryTable qtable = null;
        try {
            qtable = this._queryResultQueue.take();
        }
        catch (InterruptedException e) {
            throw new ERPException(e);
        }
        if (this._queryExecException != null) {
            throw this._queryExecException;
        }
        if (this._executionComplete.equals(qtable)) {
            return null;
        }
        return qtable;
    }

    @Override
    public void run() {
        if (this._rowCount != 0 && this._rowCount < this._batchSize) {
            this._batchSize = this._rowCount;
        }
        while (true) {
            SAPQueryTable sqtable = null;
            try {
                if (logger.isDebug()) {
                    logger.debug("Executing batch with row count " + this._batchSize + ", row skips " + this._rowSkips);
                }
                sqtable = this.executeBatch(this._batchSize, this._rowSkips);
                if (logger.isDebug()) {
                    logger.debug("Batch execution completed.");
                }
                this._queryResultQueue.put(sqtable);
                this._totalRetrievedRows += this._returnedRowCount;
                this._rowSkips += this._batchSize;
                int remainingrows = this._rowCount - this._totalRetrievedRows;
                if (this._returnedRowCount < this._batchSize || this._rowCount > 0 && remainingrows <= 0) {
                    this.putTerminator();
                    break;
                }
                if (this._rowCount <= 0 || remainingrows >= this._batchSize) continue;
                this._batchSize = remainingrows;
            }
            catch (Exception e) {
                logger.error("Query execution failed", e);
                this._queryExecException = new ERPException(e);
                this.putTerminator();
                break;
            }
        }
    }

    private void putTerminator() {
        try {
            this._queryResultQueue.put(this._executionComplete);
        }
        catch (InterruptedException e) {
            logger.debug(e);
        }
    }

    private SAPQueryTable executeBatch(int q_tablerowCnt, int q_tablerowSkips) {
        int rowlen = 0;
        SAPQueryTable saptable = null;
        ArrayList<String> selectedfields = new ArrayList<String>();
        HashMap<String, Integer> fieldIndexMap = new HashMap<String, Integer>(this._fields.size());
        int queryIndex = 0;
        ArrayList<JCoParameterList> parameterList = new ArrayList<JCoParameterList>();
        for (SAPFieldMetadata field : this._fields) {
            if ((rowlen += field.getLength()) <= this._tableReadFunDataFieldMaxLength) {
                selectedfields.add(field.getName());
                fieldIndexMap.put(field.getName(), queryIndex);
                continue;
            }
            if (selectedfields.size() <= 0) continue;
            if (logger.isDebug()) {
                int temp = rowlen - field.getLength();
                logger.debug("row length " + temp);
            }
            JCoParameterList result = this._client.getTableData(this._tableName, selectedfields, this._options, q_tablerowCnt, q_tablerowSkips);
            parameterList.add(result);
            selectedfields.clear();
            selectedfields.add(field.getName());
            fieldIndexMap.put(field.getName(), ++queryIndex);
            rowlen = field.getLength();
        }
        if (selectedfields.size() > 0) {
            JCoParameterList result = this._client.getTableData(this._tableName, selectedfields, this._options, q_tablerowCnt, q_tablerowSkips);
            parameterList.add(result);
        }
        if (parameterList.size() == 1) {
            SAPTable tobj = new SAPTable((JCoParameterList)parameterList.get(0), this._client);
            this._returnedRowCount = tobj.getRowCount();
            saptable = tobj;
        } else {
            SAPTablesWrapper twobj = new SAPTablesWrapper(parameterList, this._client, fieldIndexMap);
            this._returnedRowCount = twobj.getRowCount();
            saptable = twobj;
        }
        return saptable;
    }
}

