/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPQueryTable;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTableQueryBatchProcessor;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SAPTableQueryInvocation
implements SAPQueryTable,
SAPConstants {
    private ExecutorService _exeService;
    private ReentrantReadWriteLock _sapQueryTableLock = new ReentrantReadWriteLock();
    private SAPQueryTable _sapQueryTable;
    private SAPTableQueryBatchProcessor _batchProcessor;

    protected SAPTableQueryInvocation(String tableName, List<SAPFieldMetadata> fields, List<String> options, SAPClient client) {
        this._exeService = client.getExecutorService();
        this._batchProcessor = new SAPTableQueryBatchProcessor(tableName, fields, options, client);
        this._exeService.execute(this._batchProcessor);
    }

    private SAPQueryTable getSAPQueryTable() {
        SAPQueryTable querytable = null;
        this._sapQueryTableLock.readLock().lock();
        try {
            querytable = this._sapQueryTable;
        }
        finally {
            this._sapQueryTableLock.readLock().unlock();
        }
        return querytable;
    }

    @Override
    public String getFieldValue(String name) {
        return this.getSAPQueryTable().getFieldValue(name);
    }

    @Override
    public boolean next() {
        boolean isDataAvailable = false;
        this._sapQueryTableLock.writeLock().lock();
        try {
            if (this._sapQueryTable != null && this._sapQueryTable.next()) {
                isDataAvailable = true;
            } else {
                SAPQueryTable qtable = this._batchProcessor.getNext();
                if (qtable != null && qtable.next()) {
                    isDataAvailable = true;
                    this._sapQueryTable = qtable;
                } else {
                    this._sapQueryTable = null;
                }
            }
        }
        finally {
            this._sapQueryTableLock.writeLock().unlock();
        }
        return isDataAvailable;
    }
}

