/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.resultset;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCInvocation;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCQueryTable;
import com.cognos.xqe.data.providers.relational.erp.sap.resultset.ISAPResultSet;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SAPRFCQueryResultSet
implements ISAPResultSet {
    private SAPRFCQueryTable saprfcQueryTable = null;
    private HashMap<String, SAPRFCMetadata> metadataMap = new HashMap();

    public SAPRFCQueryResultSet(SAPClient client, List<SAPRFCInvocation> rfcInvocations, List<String> selectedFields) {
        ArrayList<SAPRFCMetadata> metadataFields = new ArrayList<SAPRFCMetadata>(selectedFields.size());
        for (String fieldName : selectedFields) {
            SAPRFCMetadata meta = new SAPRFCMetadata(fieldName);
            this.metadataMap.put(fieldName, meta);
            metadataFields.add(meta);
        }
        this.saprfcQueryTable = new SAPRFCQueryTable(rfcInvocations, metadataFields, client);
    }

    @Override
    public Object getFieldValue(String fieldName, Class classType, int scale) {
        SAPRFCMetadata metadata = this.metadataMap.get(fieldName);
        if (classType.getName().equals(BigDecimal.class.getName())) {
            return this.saprfcQueryTable.getBigDecimal(metadata);
        }
        if (classType.getName().equals(String.class.getName())) {
            return this.saprfcQueryTable.getString(metadata);
        }
        if (classType.getName().equals(Long.class.getName())) {
            return this.saprfcQueryTable.getLong(metadata);
        }
        if (classType.getName().equals(Time.class.getName())) {
            Date date = this.saprfcQueryTable.getTime(metadata);
            if (date != null) {
                return new Time(date.getTime());
            }
            return null;
        }
        if (classType.getName().equals(Date.class.getName())) {
            return this.saprfcQueryTable.getDate(metadata);
        }
        if (classType.getName().equals(Float.class.getName())) {
            return this.saprfcQueryTable.getFloat(metadata);
        }
        return this.saprfcQueryTable.getString(this.metadataMap.get(fieldName));
    }

    @Override
    public boolean hasNext() {
        return this.saprfcQueryTable.next();
    }
}

