/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sfdc;

import com.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.cognos.cdms.ds.sforce.request.SForceException;
import com.cognos.cdms.ds.sforce.request.SForceRequestManager;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnection;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.erp.ERPConnection;
import com.cognos.xqe.data.providers.relational.erp.ERPDataProvider;
import com.cognos.xqe.data.providers.relational.erp.sfdc.SFDCTabularResult;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.security.IEncryptedObject;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFDCConnection
extends ERPConnection {
    private static final Logger logger = LoggerFactory.getLogger(SFDCConnection.class);
    public static final int FIVE_HUNDRED = 500;
    private static final String SEMI_COLON = ";";
    private IDataSourceCapabilities capabilities;
    protected static final String CONNECTION_SIGNON = "signon";
    protected String userId;
    protected String password;
    protected String connectionTimeout;
    protected String userConcurrentCallsLimit;
    protected String concurrentCallsLimit;
    protected String url;
    protected String clientSecret;
    protected String clientID;
    protected boolean useRESTAPI = false;
    protected String encryptedProxyCredentials;
    protected String proxyPWD;
    protected String proxyUser;
    protected String proxyPort;
    protected String proxyHost;
    protected boolean proxyEnabled = false;
    protected String waitBetweenRetries;
    protected String maxRetries;
    protected String queryBatchSize;
    private SForceConnectionParams connectionProps = null;

    public SFDCConnection(IDataSource dataSource) {
        super(dataSource);
    }

    public SForceConnectionParams getConnectionParams() {
        return this.connectionProps;
    }

    @Override
    public void connect(Locale runLocale) {
        this.connectionProps = new SForceConnectionParams();
        IDataSourceConnection dsConnection = this.dataSource.getDataSourceConnection();
        IDataSourceConnectionSignon dataSourceConnectionSignon = dsConnection.getSignon();
        String connectionString = dsConnection.getConnectionString(dataSourceConnectionSignon);
        this.userId = null;
        this.password = null;
        if (dataSourceConnectionSignon != null && dataSourceConnectionSignon instanceof IUsernamePasswordSignon) {
            this.userId = ((IUsernamePasswordSignon)dataSourceConnectionSignon).getUserName();
            if (((IUsernamePasswordSignon)dataSourceConnectionSignon).getPassword() != null) {
                this.password = (String)((IUsernamePasswordSignon)dataSourceConnectionSignon).getPassword().decrypt();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RunLocale: " + runLocale.toString());
            logger.debug("ConnString: " + connectionString);
            logger.debug("User: " + this.userId);
        }
        this.parseConnectionString(connectionString);
        if (this.proxyEnabled && this.getProxyUser() != null) {
            this.proxyUser = this.getProxyUser();
            this.proxyPWD = this.getProxyPassword();
        }
        this.driverConnect(runLocale);
        this.capabilities = this.dataSource.getCapabilities();
        this.setProperty(CONNECTION_SIGNON, dsConnection.getSignon());
    }

    public void parseConnectionString(String inConnectionString) {
        String theConnectionString = null;
        theConnectionString = inConnectionString;
        if (theConnectionString == null || theConnectionString.indexOf("URL=sfdc:") < 0 || theConnectionString.indexOf("CONCURRENT_CALLS_LIMIT=") < 0 || theConnectionString.indexOf("USER_CONCURRENT_CALLS_LIMIT=") < 0 || theConnectionString.indexOf("CONNECTION_TIMEOUT=") < 0 || theConnectionString.indexOf("DRIVER_NAME=") < 0) {
            throw new XQERuntimeException(XQEMessageKeys.ERP_InvalidConnStringFormat);
        }
        String[] tokens = theConnectionString.split(";PROXYCREDENTIAL=");
        theConnectionString = tokens[0];
        if (tokens.length > 1) {
            tokens = tokens[1].split(SEMI_COLON);
            this.encryptedProxyCredentials = tokens[0];
        } else {
            this.encryptedProxyCredentials = null;
        }
        if (this.encryptedProxyCredentials != null) {
            DataSourceConnection.Credentials creds = DataSourceConnection.retrieveCredentials((String)this.encryptedProxyCredentials);
            this.proxyUser = creds.getUsername();
            IEncryptedObject encObject = creds.getPassword();
            if (encObject != null) {
                this.proxyPWD = (String)encObject.decrypt();
            }
        }
        tokens = theConnectionString.split(";DRIVER_NAME=");
        theConnectionString = tokens[0];
        tokens = theConnectionString.split(";CLIENT_SECRET=");
        theConnectionString = tokens[0];
        if (tokens.length > 1) {
            tokens = tokens[1].split(SEMI_COLON);
            this.clientSecret = tokens[0];
        } else {
            this.clientSecret = null;
        }
        tokens = theConnectionString.split(";CLIENT_ID=");
        theConnectionString = tokens[0];
        if (tokens.length > 1) {
            tokens = tokens[1].split(SEMI_COLON);
            this.clientID = tokens[0];
        } else {
            this.clientID = null;
        }
        tokens = theConnectionString.split(";USE_REST_API=");
        theConnectionString = tokens[0];
        tokens = tokens[1].split(SEMI_COLON);
        this.useRESTAPI = Boolean.valueOf(tokens[0]);
        tokens = theConnectionString.split(";PROXY_PORT=");
        theConnectionString = tokens[0];
        if (tokens.length > 1) {
            tokens = tokens[1].split(SEMI_COLON);
            this.proxyPort = tokens[0];
        } else {
            this.proxyPort = null;
        }
        tokens = theConnectionString.split(";PROXY_HOST=");
        theConnectionString = tokens[0];
        if (tokens.length > 1) {
            tokens = tokens[1].split(SEMI_COLON);
            this.proxyHost = tokens[0];
        } else {
            this.proxyHost = null;
        }
        tokens = theConnectionString.split(";PROXY_ENABLED=");
        theConnectionString = tokens[0];
        tokens = tokens[1].split(SEMI_COLON);
        this.proxyEnabled = Boolean.valueOf(tokens[0]);
        tokens = theConnectionString.split(";WAIT_BETWEEN_RETRIES=");
        theConnectionString = tokens[0];
        tokens = tokens[1].split(SEMI_COLON);
        this.waitBetweenRetries = tokens[0];
        tokens = theConnectionString.split(";MAX_RETRIES=");
        theConnectionString = tokens[0];
        tokens = tokens[1].split(SEMI_COLON);
        this.maxRetries = tokens[0];
        tokens = theConnectionString.split(";QUERY_BATCH_SIZE=");
        theConnectionString = tokens[0];
        tokens = tokens[1].split(SEMI_COLON);
        this.queryBatchSize = tokens[0];
        tokens = theConnectionString.split(";CONNECTION_TIMEOUT=");
        theConnectionString = tokens[0];
        tokens = tokens[1].split(SEMI_COLON);
        this.connectionTimeout = tokens[0];
        tokens = theConnectionString.split(";USER_CONCURRENT_CALLS_LIMIT=");
        theConnectionString = tokens[0];
        tokens = tokens[1].split(SEMI_COLON);
        this.userConcurrentCallsLimit = tokens[0];
        tokens = theConnectionString.split(";CONCURRENT_CALLS_LIMIT=");
        theConnectionString = tokens[0];
        tokens = tokens[1].split(SEMI_COLON);
        this.concurrentCallsLimit = tokens[0];
        tokens = theConnectionString.split(";URL=sfdc:");
        theConnectionString = tokens[0];
        tokens = tokens[1].split(SEMI_COLON);
        this.url = tokens[0];
        if (logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("ClientSecret: " + this.clientSecret);
            builder.append("ClientID: " + this.clientID);
            builder.append("userRESTAPI: " + this.useRESTAPI);
            builder.append("proxyUser: " + this.proxyUser);
            builder.append("proxyPort: " + this.proxyPort);
            builder.append("proxyEnabled: " + this.proxyEnabled);
            builder.append("waitBetweenRetries: " + this.waitBetweenRetries);
            builder.append("maxretries: " + this.maxRetries);
            builder.append("QueryBatchSize: " + this.queryBatchSize);
            builder.append("connectionTimeout: " + this.connectionTimeout);
            builder.append("userConcurrentCallsLimit: " + this.userConcurrentCallsLimit);
            builder.append("ConncurrentCallsLimit: " + this.concurrentCallsLimit);
            builder.append("URL: " + this.url);
            logger.debug(builder.toString());
        }
    }

    protected void driverConnect(Locale runLocale) {
        this.setConnectionProperties();
        try {
            SForceRequestManager.getInstance().validateConnection(this.connectionProps);
        }
        catch (SForceException apiEx) {
            if (apiEx.getErrorCode() == 1900016) {
                LogonFailureException logonEx = new LogonFailureException(this.dataSource, (Exception)((Object)apiEx));
                logonEx.setSubCode(LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
                throw logonEx;
            }
            throw apiEx;
        }
    }

    protected void setConnectionProperties() {
        this.connectionProps.setDataSourceId(this.getDataSource().getName());
        if (this.userId != null) {
            this.connectionProps.setUserName(this.userId);
        }
        if (this.password != null) {
            this.connectionProps.setPassword(this.password);
        }
        if (this.connectionTimeout != null) {
            this.connectionProps.setConnectionTimeOut(Integer.valueOf(this.connectionTimeout).intValue());
        }
        if (this.userConcurrentCallsLimit != null) {
            this.connectionProps.setUserConcurrentCallsLimit(Integer.valueOf(this.userConcurrentCallsLimit).intValue());
        }
        if (this.url != null) {
            this.connectionProps.setUrl(this.url);
        }
        if (this.proxyEnabled) {
            this.connectionProps.setProxyEnabled(true);
            this.connectionProps.setProxyHost(this.proxyHost);
            this.connectionProps.setProxyPort(Integer.valueOf(this.proxyPort).intValue());
            this.connectionProps.setProxyUserName(this.proxyUser);
            this.connectionProps.setProxyPassword(this.proxyPWD);
        }
        if (this.useRESTAPI) {
            this.connectionProps.setRestEnabled(true);
            this.connectionProps.setClientId(this.clientID);
            this.connectionProps.setClientSecret(this.clientSecret);
        }
        this.connectionProps.setQueryBatchSize(Integer.valueOf(this.queryBatchSize).intValue());
        this.connectionProps.setMaximumRetries(Integer.valueOf(this.maxRetries).intValue());
        this.connectionProps.setWaitBetweenRetries(Integer.valueOf(this.waitBetweenRetries).intValue());
    }

    @Override
    protected SFDCTabularResult getResultSetImpl(XDataContext context, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, ERPDataProvider dataProvider) {
        return new SFDCTabularResult(context, pooledConnection, queryArgs, nodeId, dataProvider);
    }

    @Override
    public void disconnect() {
        super.disconnect();
    }
}

