/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sfdc;

import com.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.cognos.cdms.ds.sforce.request.SForceException;
import com.cognos.cdms.ds.sforce.request.SForceRequestManager;
import com.cognos.cdms.ds.sforce.request.SForceResultSet;
import com.cognos.cdms.ds.sforce.request.resultset.ISForceQueryResultRecord;
import com.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEUberNodeFactory;
import com.cognos.xqe.ast.sql.SQLNodeFactory;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.erp.ERPCancelHandler;
import com.cognos.xqe.data.providers.relational.erp.ERPDataProvider;
import com.cognos.xqe.data.providers.relational.erp.ERPLog;
import com.cognos.xqe.data.providers.relational.erp.ERPTabularResult;
import com.cognos.xqe.data.providers.relational.erp.sfdc.SFDCConnection;
import com.cognos.xqe.data.providers.relational.erp.sfdc.soql.util.SFDCSOQLQueryBuilder;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataLinkValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.PeriodValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.TimeWithTZValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.text.Collator;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFDCTabularResult
extends ERPTabularResult {
    private static final Logger logger = LoggerFactory.getLogger(SFDCTabularResult.class);
    private boolean queryAllBatches = false;
    private IXQEQueryNode queryNode = null;
    private List<String> relationNames = new ArrayList<String>();
    private static XQEUberNodeFactory nodeFactory = new XQEUberNodeFactory();
    public static final String TABLE = "table";
    public static final String NAME = "name";
    static final long serialVersionUID = 1L;
    private Map<String, List<IMetadata>> tableToColumnMetadataMap = new HashMap<String, List<IMetadata>>();
    private static final String SFDC_RETURNING_THE_POOLED_CONNECTION = "Returning the pooled connection.";
    static final String CONNECTION_STRING = "connectionString";
    protected static final int TIMESTAMP_PARTS = 7;
    protected ERPDataProvider dataProvider;
    protected IPooledConnection pooledConnection;
    protected SQLQueryArguments queryArgs;
    protected SFDCConnection connection;
    protected SForceConnectionParams connectionParams = null;
    protected SForceResultSet resultSet = null;
    protected int nIterators;
    protected List<ITabularResultSet> siblings = new ArrayList<ITabularResultSet>();
    protected IExecutionEnvironment execEnv = null;
    protected ERPCancelHandler cancelHandler = null;
    protected boolean getTimeTzUsingCalendar = false;
    protected boolean getTimestampTzUsingCalendar = false;
    protected boolean getTimeStampTzUsingObject = false;
    protected boolean bCanceled = false;
    protected String soql = null;
    private IRowsetInfo rowsetInfo = null;
    protected XQEBaseQueryNode parent;

    public SFDCTabularResult(XDataContext context, IPooledConnection thePooledConnection, SQLQueryArguments theQueryArgs, Integer nodeId, ERPDataProvider theDataProvider) {
        super(context, thePooledConnection, theQueryArgs, nodeId, theDataProvider);
        if (logger.isDebugEnabled()) {
            logger.debug("SQL Query is: " + theQueryArgs.getSQLQuery());
        }
        this.execEnv = context.getEnvironment();
        this.dataProvider = theDataProvider;
        this.queryArgs = theQueryArgs;
        this.parent = this.queryArgs.getParent();
        this.pooledConnection = thePooledConnection;
        this.connection = (SFDCConnection)((Object)this.pooledConnection.getConnection());
        SQLProcessor parser = new SQLProcessor((IXQENodeFactory)nodeFactory);
        try {
            this.queryNode = parser.parseQuery(theQueryArgs.getSQLQuery());
            this.queryNode.addToIndex();
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
            throw new XQERuntimeException((Throwable)e);
        }
        IXQEQueryNode temp = null;
        IXQEQueryNode[] relationNodes = null;
        temp = this.queryNode.getFirstDescendantOfTypeOrdered(301007, false);
        relationNodes = temp == null ? this.queryNode.getFirstDescendantsOfTypeOrdered(301016, false).toArray(new IXQEQueryNode[0]) : temp.getFirstDescendantsOfTypeOrdered(301016, false).toArray(new IXQEQueryNode[0]);
        if (relationNodes != null) {
            for (IXQEQueryNode relationNode : relationNodes) {
                this.relationNames.add((String)relationNode.getPropertyValue(NAME));
            }
        }
        this.rowsetInfo = theQueryArgs.getCalculatedRowsetInfo();
        MetadataConnection mdConnection = (MetadataConnection)theQueryArgs.getParent().getPlanningEnvironment().getMetadataConnection();
        List mdlist = null;
        for (String relationName : this.relationNames) {
            mdlist = mdConnection.getPhysicalMetadata(theQueryArgs.getDataSource().getCMDataSourceName(), null, null, relationName, true, true);
            this.tableToColumnMetadataMap.put(relationName, mdlist);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Relationname: " + relationName);
        }
        this.cancelHandler = new ERPCancelHandler(this);
        this.execEnv.getCancelManager().addCancelHandler((ICancelable)this.cancelHandler);
    }

    public long getRowCount() {
        return -1L;
    }

    public ITabularIterator getTabularIterator() {
        return this.getTabularIterator(null);
    }

    public ITabularIterator getTabularIterator(XVectorContext vContext) {
        if (this.soql == null) {
            SQLQueryNode sqlQueryNode = (SQLQueryNode)this.queryNode;
            SFDCSOQLQueryBuilder formatter = new SFDCSOQLQueryBuilder(this);
            sqlQueryNode.accept((SQLQueryNodeVisitor)formatter, this.getCapabilities());
            this.soql = formatter.getBuffer().toString();
            boolean bl = this.queryAllBatches = !formatter.containsGroupby();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Derived SOQL: " + this.soql);
            logger.debug("queryAllBatches: " + this.queryAllBatches);
        }
        if (this.nIterators++ == 0) {
            return new SFDCTabularResultIterator(this.getDataContext(), vContext, this.nodeId);
        }
        try {
            ITabularResultSet sibling = this.dataProvider.query(this.getDataContext(), this.queryArgs);
            this.siblings.add(sibling);
            return sibling.getTabularIterator();
        }
        catch (XQEException e) {
            logger.error(e.getMessage());
            throw new XQERuntimeException((Throwable)e);
        }
    }

    public IRowsetInfo getTabularRowsetInfo() {
        return this.rowsetInfo;
    }

    public IScrollableIterator getScrollableTabularIterator() {
        throw new UnsupportedOperationException();
    }

    protected void releaseImpl() {
        try {
            for (ITabularResultSet sibling : this.siblings) {
                sibling.release();
            }
        }
        finally {
            logger.info(SFDC_RETURNING_THE_POOLED_CONNECTION);
            this.returnConnection();
            if (this.cancelHandler != null) {
                this.execEnv.getCancelManager().removeCancelHandler((ICancelable)this.cancelHandler);
                this.cancelHandler = null;
                if (this.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            super.releaseImpl();
        }
    }

    public IDataSourceCapabilities getCapabilities() {
        return this.connection.getCapabilities();
    }

    public boolean isCanceled() {
        return this.bCanceled;
    }

    public void setCanceled(boolean cancelled) {
        this.bCanceled = cancelled;
    }

    public boolean cancelImpl() {
        boolean canceled = true;
        ERPLog.getLogger().log(LogLevel.INFO, "Request Cancellded");
        return canceled;
    }

    private void onEndOfData() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        finally {
            logger.info(SFDC_RETURNING_THE_POOLED_CONNECTION);
            this.returnConnection();
            this.resultSet = null;
        }
    }

    private void returnConnection() {
        if (this.pooledConnection != null) {
            this.pooledConnection.returnConnection();
            this.pooledConnection = null;
        }
    }

    public IPooledConnection delegatePooledConnection() {
        IPooledConnection result = this.pooledConnection;
        this.pooledConnection = null;
        return result;
    }

    public List<String> getRelations() {
        return this.relationNames;
    }

    public Map<String, List<IMetadata>> getTableNamestoColumnMetadataMap() {
        return this.tableToColumnMetadataMap;
    }

    static {
        nodeFactory.addNodeFactory((XQENodeFactory)new SQLNodeFactory());
        PlanningEnvironment env = new PlanningEnvironment();
        env.setPlanningActive(null);
        env.setTrace(new XQETrace());
        nodeFactory.setPlanningEnvironment((IPlanningEnvironment)env);
    }

    protected class SFDCTabularResultIterator
    extends XTabularIterator {
        private int nColumns;
        private RowValue row;
        private XVectorRowBatch batch;
        private final AtomicBoolean mReleased;
        private boolean eod;

        protected SFDCTabularResultIterator(XDataContext context, XVectorContext vContext, Integer id) {
            super(context, id);
            this.mReleased = new AtomicBoolean(false);
            try {
                this.startTimer();
                if (SFDCTabularResult.this.resultSet == null) {
                    if (SFDCTabularResult.this.connectionParams == null) {
                        IExecutionEnvironment env = context.getEnvironment();
                        if (SFDCTabularResult.this.pooledConnection == null) {
                            SFDCTabularResult.this.pooledConnection = ConnectionUtil.getPooledConnection((IExecutionEnvironment)env, (IDataSource)SFDCTabularResult.this.queryArgs.getDataSource());
                        }
                        SFDCTabularResult.this.connectionParams = SFDCTabularResult.this.connection.getConnectionParams();
                    }
                    SFDCTabularResult.this.resultSet = SForceRequestManager.getInstance().query(SFDCTabularResult.this.connectionParams, SFDCTabularResult.this.soql, SFDCTabularResult.this.queryAllBatches);
                }
                this.nColumns = SFDCTabularResult.this.rowsetInfo.getNumColumns();
                this.row = DataValueFactory.createRowValue((Collator)context.getLocalCollator(), (IRowsetInfo)SFDCTabularResult.this.rowsetInfo);
                this.batch = XVectorRowBatchUtil.createRowBatch((XVectorContext)vContext, (IRowsetInfo)SFDCTabularResult.this.rowsetInfo, (Collator)context.getLocalCollator());
            }
            catch (SForceException e) {
                logger.error(e.getMessage());
                throw new XQERuntimeException(XQEMessageKeys.DAT_DataSourceAdapterError, e.getMessage());
            }
            finally {
                this.stopTimer();
            }
            ReleasableResourceTracker parentTracker = SFDCTabularResult.this.getResourceTracker();
            parentTracker.addInstance((IReleasable)this, Thread.currentThread().getStackTrace());
        }

        public Object nextImpl() {
            boolean hasNext = SFDCTabularResult.this.resultSet.hasNext();
            ISForceQueryResultRecord record = null;
            try {
                if (!hasNext) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("DATA_REQUEST_COMPLETED");
                    }
                    this.release();
                    SFDCTabularResult.this.onEndOfData();
                    return null;
                }
                record = SFDCTabularResult.this.resultSet.next();
                IColumnInfo cInfo = null;
                int derivedIndex = -1;
                Object bytes = null;
                for (int j = 0; j < this.nColumns; ++j) {
                    Value value = (Value)this.row.getColumn(j);
                    cInfo = SFDCTabularResult.this.rowsetInfo.getColumnInfo(j);
                    if (cInfo.getName().equals("Id") && j != 0) {
                        value.set(record.getId());
                    } else {
                        derivedIndex = j;
                        switch (value.getDataType().getCCLTypeCode()) {
                            case 51: {
                                value.set(record.getColumnValue(derivedIndex, Boolean.class));
                                break;
                            }
                            case 1: 
                            case 45: 
                            case 55: 
                            case 56: {
                                String strData = (String)record.getColumnValue(derivedIndex, String.class);
                                if (strData != null) {
                                    value.set(strData);
                                    break;
                                }
                                value.set(strData);
                                break;
                            }
                            case 4: {
                                Object obj = record.getColumnValue(derivedIndex, Boolean.class);
                                BigDecimal bigDecimal = obj == null || (Boolean)obj == false ? new BigDecimal(0) : new BigDecimal(1);
                                value.set(bigDecimal.shortValueExact());
                                break;
                            }
                            case 6: {
                                BigDecimal bigDecimal;
                                int scale = SFDCTabularResult.this.rowsetInfo.getColumnInfo(j).getDataType().getScale();
                                if (scale > 0) {
                                    bigDecimal = (BigDecimal)record.getColumnValue(derivedIndex, BigDecimal.class);
                                    if (record == null) break;
                                    value.set((Object)bigDecimal.setScale(scale));
                                    break;
                                }
                                value.set(record.getColumnValue(derivedIndex, Integer.class));
                                break;
                            }
                            case 8: {
                                BigDecimal bigDecimal;
                                int scale = SFDCTabularResult.this.rowsetInfo.getColumnInfo(derivedIndex).getDataType().getScale();
                                if (scale > 0) {
                                    bigDecimal = (BigDecimal)record.getColumnValue(derivedIndex, BigDecimal.class);
                                    if (record == null) break;
                                    value.set((Object)bigDecimal.setScale(scale));
                                    break;
                                }
                                value.set(record.getColumnValue(derivedIndex, Long.class));
                                break;
                            }
                            case 10: {
                                value.set(record.getColumnValue(derivedIndex, Float.class));
                                break;
                            }
                            case 11: {
                                value.set(record.getColumnValue(derivedIndex, Double.class));
                                break;
                            }
                            case 12: {
                                Object decimal = record.getColumnValue(derivedIndex, Object.class);
                                if (decimal instanceof BigDecimal) {
                                    value.set((Object)((BigDecimal)decimal));
                                    break;
                                }
                                if (decimal instanceof Double) {
                                    value.set((Object)((Double)decimal));
                                    break;
                                }
                                value.set(decimal);
                                break;
                            }
                            case 57: {
                                Object date2 = record.getColumnValue(derivedIndex, Object.class);
                                value.set(date2);
                                break;
                            }
                            case 58: {
                                value.set(record.getColumnValue(derivedIndex, Time.class));
                                break;
                            }
                            case 59: {
                                Calendar cal = (Calendar)record.getColumnValue(derivedIndex, Calendar.class);
                                if (cal != null) {
                                    value.set(cal.getTimeInMillis());
                                    break;
                                }
                                value.set((Object)cal);
                                break;
                            }
                            case 17: 
                            case 60: {
                                value.set(record.getColumnValue(derivedIndex, String.class));
                                break;
                            }
                            case 52: {
                                Date t;
                                if (SFDCTabularResult.this.getTimeTzUsingCalendar) {
                                    t = (Time)record.getColumnValue(derivedIndex, Time.class);
                                    ((TimeWithTZValue)value).set(t);
                                    break;
                                }
                                value.set(record.getColumnValue(derivedIndex, String.class));
                                break;
                            }
                            case 53: {
                                Date t;
                                if (SFDCTabularResult.this.getTimestampTzUsingCalendar) {
                                    t = (Timestamp)record.getColumnValue(derivedIndex, Timestamp.class);
                                    ((TimestampWithTZValue)value).set((Timestamp)t);
                                    break;
                                }
                                if (SFDCTabularResult.this.getTimeStampTzUsingObject) {
                                    value.set(record.getColumnValue(derivedIndex, Object.class));
                                    break;
                                }
                                value.set(record.getColumnValue(derivedIndex, String.class));
                                break;
                            }
                            case 46: {
                                value.set(record.getColumnValue(derivedIndex, Clob.class));
                                break;
                            }
                            case 18: {
                                value.set(record.getColumnValue(derivedIndex, Blob.class));
                                break;
                            }
                            case 100: {
                                value.set(record.getColumnValue(derivedIndex, String.class));
                                break;
                            }
                            case 102: {
                                value.set(record.getColumnValue(derivedIndex, Array.class));
                                break;
                            }
                            case 105: {
                                value.set(record.getColumnValue(derivedIndex, Object.class));
                                break;
                            }
                            case 106: {
                                value.set(record.getColumnValue(derivedIndex, Object.class));
                                break;
                            }
                            case 48: {
                                ((DataLinkValue)value).set(record.getColumnValue(derivedIndex, URL.class));
                                break;
                            }
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: {
                                Struct jStruct = (Struct)record.getColumnValue(derivedIndex, Object.class);
                                ((PeriodValue)value).set(jStruct.getAttributes());
                                break;
                            }
                        }
                    }
                    this.row.setColumn(j, (IValue)value);
                }
            }
            catch (SForceAPIException e) {
                logger.error(e.getMessage());
                throw new XQERuntimeException((Throwable)e);
            }
            catch (Throwable e) {
                logger.error(e.getMessage());
                throw new XQERuntimeException(e);
            }
            ++this.nRows;
            return this.row;
        }

        public Object nextBatch() {
            this.batch.reset();
            if (this.eod) {
                this.batch.eod = true;
                return this.batch;
            }
            while (this.batch.size != this.batch.maxBatchSize) {
                IRow tmpRow = (IRow)this.nextImpl();
                if (tmpRow == null) {
                    this.eod = true;
                    if (this.batch.size != 0) break;
                    this.batch.eod = true;
                    break;
                }
                this.batch.addRow(tmpRow);
            }
            return this.batch;
        }

        public long getIndex() {
            return SFDCTabularResult.this.resultSet.getCurrentPosition();
        }

        public IDataType getDataType() {
            return SFDCTabularResult.this.rowsetInfo.getDataType();
        }

        public boolean isCaching() {
            return SFDCTabularResult.this.isCaching();
        }

        public void release() {
            try {
                if (this.mReleased.compareAndSet(false, true)) {
                    ReleasableResourceTracker parentTracker = SFDCTabularResult.this.getResourceTracker();
                    parentTracker.removeInstance((IReleasable)this);
                    if (SFDCTabularResult.this.resultSet != null) {
                        SFDCTabularResult.this.resultSet.close();
                        SFDCTabularResult.this.resultSet = null;
                    }
                    --SFDCTabularResult.this.nIterators;
                }
            }
            catch (Throwable e) {
                logger.error(e.getMessage());
            }
        }
    }
}

