/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sfdc.soql.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.util.SQLAbstractUnformattedQueryFormatter;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.relational.erp.sfdc.SFDCTabularResult;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IPhysicalTable;
import com.cognos.xqe.util.xml.XMLEscCharacter;
import java.util.List;
import java.util.Properties;

public class SFDCSOQLQueryBuilder
extends SQLAbstractUnformattedQueryFormatter {
    private boolean queryContainsGroupby = false;
    private static final String DATE = "DATE ";
    private static final String TIMESTAMP = "TIMESTAMP ";
    private static final String TIME = "TIME ";
    private static final String EQUALS_PATTERN = "%1$s = %2$s";
    private static final String NOTEQUALS_PATTERN = "%1$s <> %2$s";
    private static final String INCLUDES_PATTERN = "%1$s INCLUDES ( %2$s )";
    private static final String EXCLUDES_PATTERN = "%1$s EXCLUDES ( %2$s )";
    private static final String T = "T";
    private static final String TIMEZONE_ENDS = ".000Z";
    private static final int SINGLE_QUOTE_ASCII = 39;
    private SFDCTabularResult resultsetContext = null;

    public SFDCSOQLQueryBuilder() {
    }

    public SFDCSOQLQueryBuilder(SFDCTabularResult rContext) {
        this.resultsetContext = rContext;
    }

    public SFDCSOQLQueryBuilder(Properties props) {
        this.builderProps = props;
    }

    public void visit(SQLRangeVar node, IDataSourceCapabilities capabilities) {
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        SQLQueryNode parent = (SQLQueryNode)node.getParent();
        int childType = child.getType();
        int parentType = parent.getType();
        if (parentType == 301022) {
            child.accept((SQLQueryNodeVisitor)this, capabilities);
            return;
        }
        if (childType != 301016) {
            if (parentType != 301014 || parent.getChild(0) == node) {
                this.increaseCurrentBlockIndentationLevel();
            }
            this.addOpenParenthesis();
        } else if (parentType != 301011) {
            this.increaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
        }
        child.accept((SQLQueryNodeVisitor)this, capabilities);
        if (childType != 301016) {
            this.addCloseParenthesis();
            int last = parent.getNumberChildren() - 1;
            if (parentType != 301014 || parent.getChild(last) == node) {
                this.decreaseCurrentBlockIndentationLevel();
            }
        }
        this.addSpace();
        List nameList = node.getDerivedColumnList();
        if (nameList != null && nameList.size() > 0) {
            this.addText("(");
            for (int i = 0; i < nameList.size(); ++i) {
                if (i > 0) {
                    this.addText(", ");
                }
                SQLIdentifier.delimitName((StringBuilder)this.getBuffer(), (String)((String)nameList.get(i)), (String)capabilities.getColumnDelimiter(), (boolean)false);
            }
            this.addText(")");
        }
        if (childType == 301016) {
            this.decreaseCurrentNodeIndentationLevel();
        }
    }

    public void visit(SQLAlias node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
    }

    public void visit(SQLBetween node, IDataSourceCapabilities capabilities) {
        String[] argValues = this.dumpChildren((SQLQueryNode)node, capabilities);
        this.addOpenParenthesis();
        this.addText(argValues[0]);
        this.addText(">=");
        this.addText(argValues[1]);
        this.addSpaceAndText("AND");
        this.addSpaceAndText(argValues[0]);
        this.addText("<=");
        this.addText(argValues[2]);
        this.addCloseParenthesis();
    }

    public void visit(SQLValueList node, IDataSourceCapabilities capabilities) {
        this.increaseCurrentNodeIndentationLevel();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(",");
                this.addText(" ");
            }
            this.addNewLineAndIndentation();
            ((SQLQueryNode)node.getChild(i)).accept((SQLQueryNodeVisitor)this, capabilities);
        }
        this.decreaseCurrentNodeIndentationLevel();
        this.setSelectKeywordIsAlreadyGenerated(false);
    }

    private String[] dumpChildren(SQLQueryNode node, IDataSourceCapabilities capabilities) {
        return this.dumpChildren(node, capabilities, node.getNumberChildren());
    }

    private String[] dumpChildren(SQLQueryNode node, IDataSourceCapabilities capabilities, int nArgs) {
        int i;
        int maxArgs = node.getMaximumChildren();
        String[] argValues = new String[Math.max(nArgs, maxArgs)];
        for (i = 0; i < nArgs; ++i) {
            SFDCSOQLQueryBuilder tmpFormatter = new SFDCSOQLQueryBuilder(this.resultsetContext);
            tmpFormatter.setContainsGroupby(this.containsGroupby());
            ((SQLQueryNode)node.getChild(i)).accept((SQLQueryNodeVisitor)tmpFormatter, capabilities);
            argValues[i] = tmpFormatter.bufferToString();
        }
        for (i = nArgs; i < maxArgs; ++i) {
            argValues[i] = null;
        }
        return argValues;
    }

    public void visit(SQLIdentifier node, IDataSourceCapabilities capabilities) {
        String name = node.getName();
        if (node.getType() == 301005 || node.getType() == 301032) {
            StringBuilder columnName = new StringBuilder();
            SQLIdentifier.delimitName((StringBuilder)columnName, (String)name, (String)capabilities.getColumnDelimiter(), (boolean)false);
            this.addText(columnName.toString());
        } else {
            this.addText(name);
        }
    }

    public void visit(SQLFunction node, IDataSourceCapabilities capabilities) {
        this.addText(node.getFunctionName());
        int noOfChildren = node.getNumberChildren();
        this.addText("(");
        for (int i = 0; i < noOfChildren; ++i) {
            if (i > 0) {
                this.addText(",");
            }
            ((SQLQueryNode)node.getChild(i)).accept((SQLQueryNodeVisitor)this, capabilities);
        }
        this.addText(")");
    }

    public void visit(SQLAbstractFunction node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        if (node.getType() == 301026 && this.builderProps != null && this.builderProps.getProperty("XMLEscapeCharacter") == "true") {
            pattern = XMLEscCharacter.escapeString((String)pattern);
        }
        Object[] argValues = this.dumpChildren((SQLQueryNode)node, capabilities);
        if (pattern != null) {
            IXQEQueryNode columnNode = node.getChild(0);
            IXQEQueryNode valueNode = node.getChild(1);
            String columnName = null;
            List<IMetadata> listTableMetadata = null;
            List listColumnMetadata = null;
            IDataType columnDataType = null;
            String literalTemp = null;
            IMetadata table = null;
            String mainRelationName = this.resultsetContext.getRelations().get(0);
            if (argValues.length == 2 && node instanceof SQLComparison) {
                if (columnNode != null && valueNode != null && columnNode instanceof SQLColumn && valueNode instanceof SQLLiteral) {
                    columnName = (String)columnNode.getPropertyValue("name");
                    listTableMetadata = this.resultsetContext.getTableNamestoColumnMetadataMap().get(mainRelationName);
                    table = listTableMetadata.get(0);
                    if (!(table instanceof IPhysicalTable)) {
                        throw new XQERuntimeException();
                    }
                    listColumnMetadata = ((IPhysicalTable)table).getColumns();
                    if (listColumnMetadata != null) {
                        for (IMetadata column : listColumnMetadata) {
                            if (!column.getName().equals(columnName)) continue;
                            columnDataType = column.getDataType();
                            if (columnDataType.isTimestamp()) {
                                argValues[1] = this.convertToTimeStampFormat(this.removeApostrophe(this.removeConstactFromDateLiteral((String)argValues[1])));
                                break;
                            }
                            if (columnDataType.isDate()) {
                                argValues[1] = this.removeApostrophe(this.removeConstactFromDateLiteral((String)argValues[1]));
                                break;
                            }
                            if (columnDataType.isTime()) {
                                argValues[1] = this.removeApostrophe(this.removeConstactFromDateLiteral((String)argValues[1]));
                                break;
                            }
                            if (!columnDataType.equals(DataTypeFactory.getNVarcharType())) continue;
                            if (pattern.equals(EQUALS_PATTERN)) {
                                pattern = INCLUDES_PATTERN;
                                break;
                            }
                            if (!pattern.equals(NOTEQUALS_PATTERN)) break;
                            pattern = EXCLUDES_PATTERN;
                            break;
                        }
                    }
                }
            } else if (argValues.length == 2 && node instanceof SQLIn && columnNode != null && valueNode != null && columnNode instanceof SQLColumn && valueNode instanceof SQLValueList) {
                columnName = (String)columnNode.getPropertyValue("name");
                listTableMetadata = this.resultsetContext.getTableNamestoColumnMetadataMap().get(mainRelationName);
                table = listTableMetadata.get(0);
                if (!(table instanceof IPhysicalTable)) {
                    throw new XQERuntimeException();
                }
                listColumnMetadata = ((IPhysicalTable)table).getColumns();
                if (listColumnMetadata != null) {
                    for (IMetadata column : listColumnMetadata) {
                        if (!column.getName().equals(columnName)) continue;
                        columnDataType = column.getDataType();
                        IXQEQueryNode[] values = null;
                        literalTemp = null;
                        if (columnDataType.isTimestamp()) {
                            values = valueNode.getChildren();
                            if (values != null) {
                                for (IXQEQueryNode value : values) {
                                    if (value == null || !(value instanceof SQLLiteral)) continue;
                                    literalTemp = literalTemp == null ? this.convertToTimeStampFormat(this.removeApostrophe(this.removeConstactFromDateLiteral(((SQLLiteral)value).getValue().getString()))) : literalTemp + "," + " " + this.convertToTimeStampFormat(this.removeApostrophe(this.removeConstactFromDateLiteral(((SQLLiteral)value).getValue().getString())));
                                }
                            }
                            argValues[1] = literalTemp;
                            break;
                        }
                        if (columnDataType.isDate()) {
                            values = valueNode.getChildren();
                            if (values != null) {
                                for (IXQEQueryNode value : values) {
                                    if (value == null || !(value instanceof SQLLiteral)) continue;
                                    literalTemp = literalTemp == null ? this.removeApostrophe(this.removeConstactFromDateLiteral(((SQLLiteral)value).getValue().getString())) : literalTemp + "," + " " + this.removeApostrophe(this.removeConstactFromDateLiteral(((SQLLiteral)value).getValue().getString()));
                                }
                            }
                            argValues[1] = literalTemp;
                            break;
                        }
                        if (columnDataType.isTime()) {
                            values = valueNode.getChildren();
                            if (values != null) {
                                for (IXQEQueryNode value : values) {
                                    if (value == null || !(value instanceof SQLLiteral)) continue;
                                    literalTemp = literalTemp == null ? this.removeApostrophe(this.removeConstactFromDateLiteral(((SQLLiteral)value).getValue().getString())) : literalTemp + "," + " " + this.removeApostrophe(this.removeConstactFromDateLiteral(((SQLLiteral)value).getValue().getString()));
                                }
                            }
                            argValues[1] = literalTemp;
                            break;
                        }
                        columnDataType = column.getDataType();
                        if (columnDataType == null || !columnDataType.equals(DataTypeFactory.getNVarcharType())) break;
                        pattern = INCLUDES_PATTERN;
                        break;
                    }
                }
            }
            this.addText(SQLAbstractFunction.format((String)pattern, (Object[])argValues));
        } else {
            this.addText(node.getFunctionName());
            this.addText("(");
            for (int i = 0; i < argValues.length; ++i) {
                if (i > 0) {
                    this.addText(",");
                }
                this.addText(argValues[i]);
            }
            this.addText(")");
            this.addSpace();
        }
    }

    protected String removeApostrophe(String str) {
        int idx2;
        int idx1;
        String temp = str;
        if (str != null && (idx1 = str.indexOf(39)) == 0 && (idx2 = str.indexOf(39, idx1 + 1)) > -1) {
            temp = str.substring(idx1 + 1, idx2);
        }
        return temp;
    }

    protected String removeConstactFromDateLiteral(String str) {
        int index = -1;
        if (str != null) {
            index = str.indexOf(DATE);
            if (index == 0) {
                return str.substring(DATE.length());
            }
            index = str.indexOf(TIMESTAMP);
            if (index == 0) {
                return str.substring(TIMESTAMP.length());
            }
            index = str.indexOf(TIME);
            if (index == 0) {
                return str.substring(TIME.length());
            }
        }
        return str;
    }

    protected String convertToTimeStampFormat(String str) {
        String[] tokens = null;
        StringBuilder sb = null;
        if (str.contains(T) && str.endsWith(TIMEZONE_ENDS)) {
            return str;
        }
        tokens = str.split(" ");
        sb = new StringBuilder();
        if (tokens.length == 2) {
            sb.append(tokens[0]);
            sb.append(T);
            sb.append(tokens[1]);
            if (!tokens[1].endsWith(TIMEZONE_ENDS)) {
                sb.append(TIMEZONE_ENDS);
            }
            return sb.toString();
        }
        return str;
    }

    public void visit(SQLProject node, IDataSourceCapabilities capabilities) {
        if (!this.selectKeywordIsAlreadyGenerated()) {
            this.addSelectKeyword(null);
        }
        ((SQLQueryNode)node.getChild(1)).accept((SQLQueryNodeVisitor)this, capabilities);
        this.addFromKeyword();
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        int childType = child.getType();
        if (childType == 301016) {
            this.increaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
        }
        child.accept((SQLQueryNodeVisitor)this, capabilities);
        if (node.getNumberChildren() > 2) {
            ((SQLQueryNode)node.getChild(2)).accept((SQLQueryNodeVisitor)this, capabilities);
        }
        if (childType == 301007) {
            this.decreaseCurrentNodeIndentationLevel();
        }
    }

    public void visit(SQLFilter node, IDataSourceCapabilities capabilities) {
        if (node.getChild(0).getType() == 301016) {
            this.increaseCurrentNodeIndentationLevel();
            this.addNewLineAndIndentation();
        }
        ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
        this.addSpace();
        node.getCognosSQL(capabilities, (QueryFormatter)this);
    }

    public void visit(SQLLogical node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        Object[] argValues = this.dumpChildren((SQLQueryNode)node, capabilities);
        String fName = node.getFunctionName();
        if (node.getSubType() == SQLLogical.SubType.OR) {
            IXQEQueryNode parent = node.getParent();
            if (parent.getType() == 301027 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.AND) {
                StringBuffer sBuffer = new StringBuffer();
                sBuffer.append("(");
                sBuffer.append(this.buildFormattedPatternForLogicalOperator(pattern, fName));
                sBuffer.append(")");
                pattern = sBuffer.toString();
            } else {
                pattern = this.buildFormattedPatternForLogicalOperator(pattern, fName);
            }
        } else if (node.getSubType() == SQLLogical.SubType.AND) {
            pattern = this.buildFormattedPatternForLogicalOperator(pattern, fName);
        }
        this.addText(String.format(pattern, argValues));
    }

    public void visit(SQLComparison node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    public void visit(SQLAggregate node, IDataSourceCapabilities capabilities) {
        SQLAggregate.SubType aggrSubType;
        boolean isPercentile;
        int nChildren = node.getNumberChildren();
        String pattern = node.getPattern(capabilities);
        SQLQueryNode window = (SQLQueryNode)node.getFirstChildByType(301041);
        if (window != null) {
            --nChildren;
        }
        boolean bl = isPercentile = (aggrSubType = node.getSubType()).equals((Object)SQLAggregate.SubType.PERCENTILE_CONT) || aggrSubType.equals((Object)SQLAggregate.SubType.PERCENTILE_DISC);
        if (isPercentile) {
            pattern = this.buildFormattedPatternPercentile(pattern, aggrSubType.toString());
            this.increaseCurrentNodeIndentationLevel();
            this.increaseCurrentNodeIndentationLevel();
        }
        Object[] argValues = this.dumpChildren((SQLQueryNode)node, capabilities, nChildren);
        String sqlStr = SQLAbstractFunction.format((String)pattern, (Object[])argValues);
        this.addText(sqlStr);
        if (isPercentile) {
            this.decreaseCurrentNodeIndentationLevel();
            this.decreaseCurrentNodeIndentationLevel();
        }
        if (window != null) {
            window.accept((SQLQueryNodeVisitor)this, capabilities);
        }
    }

    public void visit(SQLGroupBy node, IDataSourceCapabilities capabilities) {
        super.visit(node, capabilities);
        this.queryContainsGroupby = true;
    }

    public boolean containsGroupby() {
        return this.queryContainsGroupby;
    }

    public void setContainsGroupby(boolean containGroupBy) {
        this.queryContainsGroupby = containGroupBy;
    }

    public QueryFormatter copyFormatter() {
        return new SFDCSOQLQueryBuilder(this.resultsetContext);
    }
}

