/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.siebel;

import com.cognos.cdms.ds.logger.Logger;
import com.cognos.cdms.ds.siebel.beans.SiebelQueryBean;
import com.cognos.cdms.ds.siebel.sdb.SDBConnection;
import com.cognos.cdms.ds.siebel.sdb.SDBConnectionFactory;
import com.cognos.cdms.ds.siebel.sdb.SDBException;
import com.cognos.cdms.ds.siebel.sdb.SDBLoggerModule;
import com.cognos.cdms.ds.siebel.sdb.SDBResultSet;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.erp.ERPConnection;
import com.cognos.xqe.data.providers.relational.erp.ERPDataProvider;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.siebel.SiebelTabularResult;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.runtree.XDataContext;
import java.util.Locale;

public class SiebelConnection
extends ERPConnection {
    private static Logger logger = SDBLoggerModule.getLoggerFactory().getLogger(SiebelConnection.class);
    private SDBConnection sdbConnection = null;
    private String siebelURL;
    protected String userId;
    protected String password;
    private String collationName;
    private String charsetName;
    private Boolean primaryRecordOnly = false;
    private int loginRetryCount = COUNT.THREE.ordinal();
    private int loginRetryDelay = COUNT.FIVE.ordinal();
    private static final String CHARSET = "CHARSET";
    private static final String DEFAULTCHAR = "UTF-8";
    private static final String LOCALSORT = "LOCALSORT";
    private static final String LEVEL = "LEVEL";
    private static final String DEFAULTLEVEL = "P";
    private static final String COLON = ":";
    private static final String SEMICOLON = ";";
    private static final String EQUAL = "=";
    private static final String SIEBEL = "Siebel";

    public SiebelConnection(IDataSource dataSource) {
        super(dataSource);
        throw new ERPException(XQEMessageKeys.DS_DataSourceTypeNotSupported, SIEBEL);
    }

    public Boolean getPrimaryRecordOnly() {
        return this.primaryRecordOnly;
    }

    public static String[] parseConnectionString(String connectionString) {
        throw new ERPException(XQEMessageKeys.DS_DataSourceTypeNotSupported, SIEBEL);
    }

    protected void driverConnect(Locale runLocale) throws LogonFailureException {
        if (logger.isDebug()) {
            StringBuilder builder = new StringBuilder();
            builder.append(((Object)((Object)this)).getClass().getName());
            builder.append("_driverConnect");
            builder.append("_runLocale:" + runLocale);
            logger.debug(builder.toString());
        }
        try {
            this.sdbConnection = SDBConnectionFactory.getInstance().getSDBConnection(this.siebelURL, this.userId, this.password);
            if (this.charsetName == null || this.charsetName.equals("") || this.charsetName.length() == 0) {
                this.sdbConnection.connect(this.loginRetryCount, this.loginRetryDelay, DEFAULTCHAR);
            } else {
                this.sdbConnection.connect(this.loginRetryCount, this.loginRetryDelay, this.charsetName);
            }
        }
        catch (SDBException e) {
            logger.log(XQEMessages.getMessage((IMessageKey.Param5)XQEMessageKeys.ERP_SiebelDriverConnectError, (Locale)runLocale, (String)this.siebelURL, (String)this.userId, (String)Integer.toString(this.loginRetryCount), (String)Integer.toString(this.loginRetryDelay), (String)this.charsetName), (Throwable)e);
            throw new LogonFailureException(this.dataSource, (Exception)((Object)e));
        }
    }

    private void setCollationName(IDataSourceConnection dsConnection, Locale runLocale, String inCollationName, String inCollationLevel) {
        StringBuilder collationFullName = new StringBuilder();
        if (logger.isDebug()) {
            StringBuilder builder = new StringBuilder();
            builder.append(((Object)((Object)this)).getClass().getName());
            builder.append("_setCollationName");
            builder.append("_inCollationName: " + inCollationName);
            builder.append("_inCollationLevel: " + inCollationLevel);
            if (runLocale != null) {
                builder.append("_runLocale: " + runLocale.toString());
            }
            logger.debug(builder.toString());
        }
        if (inCollationName != null) {
            if (inCollationLevel != null) {
                collationFullName.append(inCollationName).append(COLON).append(inCollationLevel);
            } else {
                collationFullName.append(inCollationName).append(COLON).append(DEFAULTLEVEL);
            }
        }
        if (collationFullName.length() > 0) {
            dsConnection.setConnectionParameter(LOCALSORT, (Object)collationFullName.toString());
            this.collationName = collationFullName.toString();
        } else if (runLocale != null) {
            this.collationName = runLocale.toString();
        }
    }

    private void setAdvancedParameters(String inAdvancedParameters) {
        if (logger.isDebug()) {
            StringBuilder builder = new StringBuilder();
            builder.append(((Object)((Object)this)).getClass().getName());
            builder.append("_setAdvancedParameters");
            builder.append("_inAdvancedParameters:" + inAdvancedParameters);
            logger.debug(builder.toString());
        }
        if (inAdvancedParameters != null) {
            String[] parts = inAdvancedParameters.split(SEMICOLON);
            for (int i = 0; i < parts.length; ++i) {
                String[] params = parts[i].split(EQUAL);
                if (params.length <= 1 || !params[0].equalsIgnoreCase("primaryrecordonly")) continue;
                this.primaryRecordOnly = params[1].equalsIgnoreCase("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
        } else {
            this.primaryRecordOnly = false;
        }
    }

    private void setLoginRetryCount(String retryCount) {
        if (retryCount != null) {
            this.loginRetryCount = Integer.valueOf(retryCount);
        } else if (logger.isDebug()) {
            logger.debug("SDBLog Login Retry Count set to default");
        }
    }

    private void setLoginRetryDelay(String retryDelay) {
        if (retryDelay != null) {
            this.loginRetryDelay = Integer.valueOf(retryDelay);
        } else if (logger.isDebug()) {
            logger.debug("SDBLog Login Retry Delay set to default");
        }
    }

    private void setCharsetName(String inCharsetName) {
        if (inCharsetName != null) {
            this.charsetName = inCharsetName;
        } else {
            this.charsetName = DEFAULTCHAR;
            if (logger.isDebug()) {
                logger.debug("SDBLog charsetName set to DEFAULTCHAR");
            }
        }
    }

    @Override
    public void connect(Locale runLocale) {
        if (logger.isDebug()) {
            StringBuilder builder = new StringBuilder();
            builder.append(((Object)((Object)this)).getClass().getName());
            builder.append("_connect");
            if (runLocale != null) {
                builder.append("_runLocale:" + runLocale.toString());
            }
            logger.debug(builder.toString());
        }
        IDataSourceConnection dsConnection = this.dataSource.getDataSourceConnection();
        String[] retStr = SiebelConnection.getConnectionInfo(dsConnection);
        if (logger.isDebug()) {
            StringBuilder builder = new StringBuilder();
            builder.append(((Object)((Object)this)).getClass().getName());
            builder.append("_connect");
            builder.append("_siebelURL:" + retStr[COUNT.ZERO.ordinal()] + "_" + "userId" + COLON + retStr[COUNT.ONE.ordinal()] + "_" + "password-hash-code" + COLON + retStr[COUNT.TWO.ordinal()].hashCode() + "_" + "connectionString" + COLON + retStr[COUNT.THREE.ordinal()] + "_" + "collationName" + COLON + retStr[COUNT.FOUR.ordinal()] + "_" + "collationLevel" + COLON + retStr[COUNT.FIVE.ordinal()] + "_" + "charsetName" + COLON + retStr[COUNT.SIX.ordinal()] + "_" + "retryCount" + COLON + retStr[COUNT.SEVEN.ordinal()] + "_" + "retryDelay" + COLON + retStr[COUNT.EIGHT.ordinal()] + "_" + "advancedParameters" + COLON + retStr[COUNT.NINE.ordinal()]);
        }
        if (retStr[COUNT.ZERO.ordinal()] == null || retStr[COUNT.ONE.ordinal()] == null || retStr[COUNT.TWO.ordinal()] == null) {
            logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelParseConnectionException, (Locale)runLocale));
            LogonFailureException logonFailureExceptione = new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CONN_STRING);
            logonFailureExceptione.setDataSource(this.dataSource);
            throw logonFailureExceptione;
        }
        this.siebelURL = retStr[COUNT.ZERO.ordinal()];
        this.userId = retStr[COUNT.ONE.ordinal()];
        this.password = retStr[COUNT.TWO.ordinal()];
        this.connectionString = retStr[COUNT.THREE.ordinal()];
        this.setCollationName(dsConnection, runLocale, retStr[COUNT.FOUR.ordinal()], retStr[COUNT.FIVE.ordinal()]);
        this.setCharsetName(retStr[COUNT.SIX.ordinal()]);
        this.setLoginRetryCount(retStr[COUNT.SEVEN.ordinal()]);
        this.setLoginRetryDelay(retStr[COUNT.EIGHT.ordinal()]);
        this.setAdvancedParameters(retStr[COUNT.NINE.ordinal()]);
        this.driverConnect(runLocale);
        this.setProperty("signon", dsConnection.getSignon());
    }

    @Override
    public void disconnect() {
        super.disconnect();
        if (logger.isDebug()) {
            logger.debug("SDBLog SiebelConnection.disconnect");
        }
        this.sdbConnection.close();
    }

    @Override
    protected SiebelTabularResult getResultSetImpl(XDataContext context, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, ERPDataProvider dataProvider) {
        return new SiebelTabularResult(context, pooledConnection, queryArgs, nodeId, dataProvider);
    }

    @Override
    public String getConnectionCollationSequence() {
        return this.collationName;
    }

    @Override
    public String getDatabaseCharset() {
        return this.charsetName;
    }

    @Override
    public String getDatabaseCollationSequence() {
        return this.collationName;
    }

    public SDBResultSet executeQuery(SiebelQueryBean queryBean) throws SDBException {
        return this.sdbConnection.executeQuery(queryBean);
    }

    public static boolean testConnection(ConnectionTestQueryArguments theQueryArguments) {
        throw new ERPException(XQEMessageKeys.DS_DataSourceTypeNotSupported, SIEBEL);
    }

    private static String[] getConnectionInfo(IDataSourceConnection dsConnection) {
        throw new ERPException(XQEMessageKeys.DS_DataSourceTypeNotSupported, SIEBEL);
    }

    private static enum COUNT {
        ZERO,
        ONE,
        TWO,
        THREE,
        FOUR,
        FIVE,
        SIX,
        SEVEN,
        EIGHT,
        NINE;

    }
}

