/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.siebel;

import com.cognos.cdms.ds.logger.Logger;
import com.cognos.cdms.ds.siebel.beans.SiebelQueryBean;
import com.cognos.cdms.ds.siebel.sdb.SDBLoggerModule;
import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEUberNodeFactory;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLArrayValueConstructor;
import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLCall;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLCoalesce;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLColumnStar;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLComputeBreak;
import com.cognos.xqe.ast.sql.SQLCube;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLDistinct;
import com.cognos.xqe.ast.sql.SQLExists;
import com.cognos.xqe.ast.sql.SQLExtract;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLGroupingSets;
import com.cognos.xqe.ast.sql.SQLHaving;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLIsDistinctFrom;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLateral;
import com.cognos.xqe.ast.sql.SQLLike;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLNativeSQLValueExpression;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.ast.sql.SQLNodeFactory;
import com.cognos.xqe.ast.sql.SQLNull;
import com.cognos.xqe.ast.sql.SQLNullArgument;
import com.cognos.xqe.ast.sql.SQLNullIf;
import com.cognos.xqe.ast.sql.SQLOption;
import com.cognos.xqe.ast.sql.SQLOrdinal;
import com.cognos.xqe.ast.sql.SQLOverlaps;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.ast.sql.SQLPeriodValueConstructor;
import com.cognos.xqe.ast.sql.SQLProduct;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQuantifier;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLRollup;
import com.cognos.xqe.ast.sql.SQLRowValueConstructor;
import com.cognos.xqe.ast.sql.SQLSearchedCase;
import com.cognos.xqe.ast.sql.SQLSelect;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.sql.SQLSimilar;
import com.cognos.xqe.ast.sql.SQLSimpleCase;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.ast.sql.SQLSummaryFilter;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLTableValueConstructor;
import com.cognos.xqe.ast.sql.SQLTop;
import com.cognos.xqe.ast.sql.SQLTrim;
import com.cognos.xqe.ast.sql.SQLUser;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWhen;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.ast.sql.SQLWindowList;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.siebel.SiebelTabularResult;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import java.util.Hashtable;
import java.util.Locale;

public final class SiebelQueryBeanBuilder
extends QueryFormatter {
    private static Logger logger = SDBLoggerModule.getLoggerFactory().getLogger(SiebelQueryBeanBuilder.class);
    public static final String LEFT_BRACKET = "[";
    public static final String RIGHT_BRACKET = "]";
    public static final String LESS = " < ";
    public static final String LESSEQUAL = " <= ";
    public static final String GREATER = " > ";
    public static final String GREATEREQUAL = " >= ";
    public static final String EQUAL = " = ";
    public static final String NOTEQUAL = " <> ";
    public static final String ANDING = " AND ";
    public static final String ORING = " OR ";
    public static final String NOTING = " NOT ";
    public static final String LIKE = " ~LIKE ";
    public static final String NOTLIKE = " NOT ~LIKE ";
    public static final String ISNULL = " IS NULL";
    public static final String ISNOTNULL = " IS NOT NULL";
    public static final String EXISTS = " EXISTS";
    public static final int VIEWMODE = 3;
    public static final String KEYWORD_ASC = " (ASCENDING)";
    public static final String KEYWORD_DESC = " (DESCENDING)";
    private String inColumnIdentifier = null;
    private String betColumnIdentifier = null;
    private SiebelQueryBean queryBean = null;
    private QueryExpressions currentQExp = QueryExpressions.NONE;
    Hashtable<String, Boolean> columnMVL = null;
    Hashtable<String, Boolean> primaryJoinMVL = null;
    private boolean isComparisonMVL = false;
    private boolean isLikeMVL = false;
    private boolean isNullMVL = false;
    private boolean isInMVL = false;
    private boolean isBetMVL = false;
    private String nullMvlHelperString = null;
    private boolean primaryRecordOnly = false;

    public SiebelQueryBeanBuilder(SiebelQueryBean queryBeanParam, Hashtable<String, Boolean> mvlMetadata, Hashtable<String, Boolean> pjMetadata, Boolean inPrimaryRecordOnly) {
        this.queryBean = queryBeanParam;
        this.columnMVL = mvlMetadata;
        this.primaryJoinMVL = pjMetadata;
        this.primaryRecordOnly = inPrimaryRecordOnly;
    }

    public static IXQEQueryNode parseSql(String sql) {
        if (logger.isDebug()) {
            StringBuilder builder = new StringBuilder();
            builder.append(SiebelQueryBeanBuilder.class.getName());
            builder.append("_parseSQL");
            builder.append("_SQL:");
            builder.append(sql);
            logger.debug(builder.toString());
        }
        if (sql == null || !sql.regionMatches(true, 0, "select", 0, COUNT.SIX.ordinal())) {
            logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelNotAbleToProcessNONSelectCommand, (Locale)XQEMessages.getCurrProductLocale()));
            throw new ERPException(XQEMessageKeys.ERP_SiebelNotAbleToProcessNONSelectCommand);
        }
        IXQEQueryNode node = null;
        try {
            node = SiebelQueryBeanBuilder.parseSQLString(sql);
            node.addToIndex();
            if (logger.isDebug()) {
                StringBuilder builder = new StringBuilder();
                builder.append(SiebelQueryBeanBuilder.class.getName());
                builder.append("_");
                builder.append("parseSQL");
                builder.append("_");
                builder.append("nodeDump");
                builder.append(":");
                builder.append(node.dumpToString());
                logger.debug(builder.toString());
            }
        }
        catch (ParseException e) {
            logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelErrorParsingSQL, (Locale)XQEMessages.getCurrProductLocale()), (Throwable)e);
            throw new ERPException(XQEMessageKeys.ERP_SiebelErrorParsingSQL);
        }
        return node;
    }

    private static IXQEQueryNode parseSQLString(String sql) throws ParseException {
        XQEUberNodeFactory nodeFactory = new XQEUberNodeFactory();
        nodeFactory.addNodeFactory((XQENodeFactory)new SQLNodeFactory());
        PlanningEnvironment env = new PlanningEnvironment();
        env.setPlanningActive(null);
        env.setTrace(new XQETrace());
        nodeFactory.setPlanningEnvironment((IPlanningEnvironment)env);
        SQLProcessor parser = new SQLProcessor((IXQENodeFactory)nodeFactory);
        IXQEQueryNode node = parser.parseQuery(sql);
        node.addToIndex();
        return node;
    }

    private SiebelQueryBean getQueryBean() {
        return this.queryBean;
    }

    public void visit(SQLAbstractFunction node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLAggregate node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLAlias node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
    }

    public void visit(SQLArrayValueConstructor node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLBetween node, IDataSourceCapabilities capabilities) {
        this.betColumnIdentifier = null;
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        if (child.getType() != 301005) {
            throw new UnsupportedOperationException();
        }
        child.accept((SQLQueryNodeVisitor)this, capabilities);
        if (this.betColumnIdentifier == null) {
            throw new UnsupportedOperationException();
        }
        child = (SQLQueryNode)node.getChild(1);
        if (child.getType() != 301031) {
            throw new UnsupportedOperationException();
        }
        this.addText(GREATEREQUAL);
        child.accept((SQLQueryNodeVisitor)this, capabilities);
        child = (SQLQueryNode)node.getChild(2);
        if (child.getType() != 301031) {
            throw new UnsupportedOperationException();
        }
        this.addText(ANDING);
        this.addText(this.betColumnIdentifier);
        this.addText(LESSEQUAL);
        child.accept((SQLQueryNodeVisitor)this, capabilities);
        if (this.isBetMVL) {
            this.addText(")");
            this.isBetMVL = false;
        }
        this.betColumnIdentifier = null;
    }

    public void visit(SQLCall node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLCast node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLCoalesce node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLColumnStar node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLColumn node, IDataSourceCapabilities capabilities) {
        this.visit((SQLIdentifier)node, capabilities);
    }

    public void visit(SQLComparison node, IDataSourceCapabilities capabilities) {
        if (node.getNumberChildren() != 2) {
            throw new UnsupportedOperationException();
        }
        ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
        switch (node.getSubType()) {
            case LESS: {
                this.addText(LESS);
                break;
            }
            case LESSEQUAL: {
                this.addText(LESSEQUAL);
                break;
            }
            case GREATER: {
                this.addText(GREATER);
                break;
            }
            case GREATEREQUAL: {
                this.addText(GREATEREQUAL);
                break;
            }
            case EQUAL: {
                this.addText(EQUAL);
                break;
            }
            case NOTEQUAL: {
                this.addText(NOTEQUAL);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        ((SQLQueryNode)node.getChild(1)).accept((SQLQueryNodeVisitor)this, capabilities);
        if (this.isComparisonMVL) {
            this.addText(")");
            this.isComparisonMVL = false;
        }
    }

    public void visit(SQLComputeBreak node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLCube node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLDataType node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLDistinct node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLExists node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLExtract node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLFid node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLFilter node, IDataSourceCapabilities capabilities) {
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        if (child.getType() != 301007 && child.getType() != 301016) {
            throw new UnsupportedOperationException();
        }
        child.accept((SQLQueryNodeVisitor)this, capabilities);
        this.setSearchExpressionActive();
        this.addText("(");
        ((SQLQueryNode)node.getChild(1)).accept((SQLQueryNodeVisitor)this, capabilities);
        this.addText(")");
        this.unsetSearchExpressionActive();
    }

    public void visit(SQLFunction node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLGroupBy node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLGroupByList node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLGroupingSets node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLHaving node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLIdentifier node, IDataSourceCapabilities capabilities) {
        if (logger.isDebug()) {
            logger.debug("Current mode: " + this.currentQExp.name());
        }
        String catalog = node.getCatalogName();
        String schema = node.getSchemaName();
        String table = node.getTableName();
        String name = node.getName();
        if (node.getType() == 301005 || node.getType() == 301032) {
            name = SiebelTabularResult.removeMVLAndPJInfoFromColumnName(name);
        }
        switch (this.currentQExp) {
            case SELECT: {
                if (node.getType() == 301005) {
                    this.queryBean.addField(name);
                    if (!logger.isDebug()) break;
                    logger.debug("field - " + name);
                    break;
                }
                throw new UnsupportedOperationException();
            }
            case FROM: {
                this.queryBean.setBusinessObject(schema);
                this.queryBean.setBusinessComponent(name);
                if (!logger.isDebug()) break;
                logger.debug("catalog - " + catalog);
                logger.debug(" - schema - " + schema);
                logger.debug(" - table - " + table);
                logger.debug(" - name - " + name);
                break;
            }
            case SORT: {
                if (node.getType() == 301005) {
                    this.addText(name);
                    if (!logger.isDebug()) break;
                    logger.debug("sort-field - " + name);
                    break;
                }
                throw new UnsupportedOperationException();
            }
            case SEARCH: {
                if (node.getType() == 301005) {
                    if (logger.isDebug()) {
                        logger.debug("search-field - " + name);
                        logger.debug("search-node-parent " + node.getParent().getNodeTypeName());
                    }
                    if (node.getParent().getType() == 301026) {
                        this.isComparisonMVL = false;
                        if (this.columnMVL.get(name) != null) {
                            this.isComparisonMVL = this.columnMVL.get(name);
                        }
                        if (this.isComparisonMVL && this.primaryJoinMVL.get(name) != null && this.primaryJoinMVL.get(name).booleanValue() && this.primaryRecordOnly) {
                            this.isComparisonMVL = false;
                        }
                        if (this.isComparisonMVL) {
                            this.addText(EXISTS);
                            this.addText("(");
                        }
                    } else if (node.getParent().getType() == 301044) {
                        this.isLikeMVL = false;
                        if (this.columnMVL.get(name) != null) {
                            this.isLikeMVL = this.columnMVL.get(name);
                        }
                        if (this.isLikeMVL && this.primaryJoinMVL.get(name) != null && this.primaryJoinMVL.get(name).booleanValue() && this.primaryRecordOnly) {
                            this.isLikeMVL = false;
                        }
                        if (this.isLikeMVL) {
                            this.addText(EXISTS);
                            this.addText("(");
                        }
                    } else if (node.getParent().getType() == 301024) {
                        this.isNullMVL = false;
                        if (this.columnMVL.get(name) != null) {
                            this.isNullMVL = this.columnMVL.get(name);
                        }
                        if (this.isNullMVL && this.primaryJoinMVL.get(name) != null && this.primaryJoinMVL.get(name).booleanValue() && this.primaryRecordOnly) {
                            this.isNullMVL = false;
                        }
                        if (this.isNullMVL) {
                            this.addText(EXISTS);
                            this.addText("(");
                            this.nullMvlHelperString = " EXISTS([" + name + RIGHT_BRACKET;
                        }
                    } else if (node.getParent().getType() == 301076) {
                        this.isInMVL = false;
                        if (this.columnMVL.get(name) != null) {
                            this.isInMVL = this.columnMVL.get(name);
                        }
                        if (this.isInMVL && this.primaryJoinMVL.get(name) != null && this.primaryJoinMVL.get(name).booleanValue() && this.primaryRecordOnly) {
                            this.isInMVL = false;
                        }
                        if (this.isInMVL) {
                            this.addText(EXISTS);
                            this.addText("(");
                        }
                        this.inColumnIdentifier = LEFT_BRACKET + name + RIGHT_BRACKET;
                    } else if (node.getParent().getType() == 301045) {
                        this.isBetMVL = false;
                        if (this.columnMVL.get(name) != null) {
                            this.isBetMVL = this.columnMVL.get(name);
                        }
                        if (this.isBetMVL && this.primaryJoinMVL.get(name) != null && this.primaryJoinMVL.get(name).booleanValue() && this.primaryRecordOnly) {
                            this.isBetMVL = false;
                        }
                        if (this.isBetMVL) {
                            this.addText(EXISTS);
                            this.addText("(");
                        }
                        this.betColumnIdentifier = LEFT_BRACKET + name + RIGHT_BRACKET;
                    }
                    this.addText(LEFT_BRACKET);
                    this.addText(name);
                    this.addText(RIGHT_BRACKET);
                    break;
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void visit(SQLIn node, IDataSourceCapabilities capabilities) {
        if (node.getNumberChildren() != 2) {
            throw new UnsupportedOperationException();
        }
        this.inColumnIdentifier = null;
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        if (child.getType() != 301005) {
            throw new UnsupportedOperationException();
        }
        child.accept((SQLQueryNodeVisitor)this, capabilities);
        if (this.inColumnIdentifier == null) {
            throw new UnsupportedOperationException();
        }
        child = (SQLQueryNode)node.getChild(1);
        if (child.getType() != 301030) {
            throw new UnsupportedOperationException();
        }
        child.accept((SQLQueryNodeVisitor)this, capabilities);
        if (this.isInMVL) {
            this.addText(")");
            this.isInMVL = false;
        }
        this.inColumnIdentifier = null;
    }

    public void visit(SQLIsNull node, IDataSourceCapabilities capabilities) {
        block16: {
            block15: {
                IXQEQueryNode parent = node.getParent();
                this.nullMvlHelperString = null;
                if (parent.getType() != 301027) break block15;
                if (node.getNumberChildren() != 1) {
                    throw new UnsupportedOperationException();
                }
                SQLQueryNode child = (SQLQueryNode)node.getChild(0);
                if (child.getType() != 301005) {
                    throw new UnsupportedOperationException();
                }
                switch (((SQLLogical)parent).getSubType()) {
                    case AND: 
                    case OR: {
                        child.accept((SQLQueryNodeVisitor)this, capabilities);
                        this.addText(ISNULL);
                        if (this.isNullMVL) {
                            this.addText(")");
                            this.isNullMVL = false;
                            if (this.nullMvlHelperString == null) {
                                throw new UnsupportedOperationException();
                            }
                            this.addText(ORING);
                            this.addText(NOTING);
                            this.addText(this.nullMvlHelperString);
                            this.addText(ISNOTNULL);
                            this.addText(")");
                            break;
                        }
                        break block16;
                    }
                    case NOT: {
                        child.accept((SQLQueryNodeVisitor)this, capabilities);
                        this.addText(ISNOTNULL);
                        if (this.isNullMVL) {
                            this.addText(")");
                            this.isNullMVL = false;
                            break;
                        }
                        break block16;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                break block16;
            }
            if (node.getParent().getType() == 301009) {
                if (node.getNumberChildren() != 1) {
                    throw new UnsupportedOperationException();
                }
                SQLQueryNode child = (SQLQueryNode)node.getChild(0);
                if (child.getType() != 301005) {
                    throw new UnsupportedOperationException();
                }
                child.accept((SQLQueryNodeVisitor)this, capabilities);
                this.addText(ISNULL);
                if (this.isNullMVL) {
                    this.addText(")");
                    this.isNullMVL = false;
                    if (this.nullMvlHelperString == null) {
                        throw new UnsupportedOperationException();
                    }
                    this.addText(ORING);
                    this.addText(NOTING);
                    this.addText(this.nullMvlHelperString);
                    this.addText(ISNOTNULL);
                    this.addText(")");
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }
        this.nullMvlHelperString = null;
    }

    public void visit(SQLIsDistinctFrom node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLJoin node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLLateral node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLLike node, IDataSourceCapabilities capabilities) {
        block12: {
            block11: {
                IXQEQueryNode parent = node.getParent();
                if (parent.getType() != 301027) break block11;
                if (node.getNumberChildren() != 2) {
                    throw new UnsupportedOperationException();
                }
                switch (((SQLLogical)parent).getSubType()) {
                    case AND: 
                    case OR: {
                        ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
                        this.addText(LIKE);
                        ((SQLQueryNode)node.getChild(1)).accept((SQLQueryNodeVisitor)this, capabilities);
                        if (this.isLikeMVL) {
                            this.addText(")");
                            this.isLikeMVL = false;
                        }
                        break block12;
                    }
                    case NOT: {
                        ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
                        this.addText(NOTLIKE);
                        ((SQLQueryNode)node.getChild(1)).accept((SQLQueryNodeVisitor)this, capabilities);
                        if (this.isLikeMVL) {
                            this.addText(")");
                            this.isLikeMVL = false;
                        }
                        break block12;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            if (node.getParent().getType() == 301009) {
                if (node.getNumberChildren() != 2) {
                    throw new UnsupportedOperationException();
                }
                ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
                this.addText(LIKE);
                ((SQLQueryNode)node.getChild(1)).accept((SQLQueryNodeVisitor)this, capabilities);
                if (this.isLikeMVL) {
                    this.addText(")");
                    this.isLikeMVL = false;
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void visit(SQLLiteral node, IDataSourceCapabilities capabilities) {
        Value value = node.getValue();
        this.addText(value.getJDBCLiteral());
    }

    public void visit(SQLLogical node, IDataSourceCapabilities capabilities) {
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() != 301009 && parent.getType() != 301027) {
            throw new UnsupportedOperationException();
        }
        switch (node.getSubType()) {
            case AND: {
                if (node.getNumberChildren() != 2) {
                    throw new UnsupportedOperationException();
                }
                this.addText("(");
                ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
                this.addText(")");
                this.addText(ANDING);
                this.addText("(");
                ((SQLQueryNode)node.getChild(1)).accept((SQLQueryNodeVisitor)this, capabilities);
                this.addText(")");
                break;
            }
            case OR: {
                if (node.getNumberChildren() != 2) {
                    throw new UnsupportedOperationException();
                }
                this.addText("(");
                ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
                this.addText(")");
                this.addText(ORING);
                this.addText("(");
                ((SQLQueryNode)node.getChild(1)).accept((SQLQueryNodeVisitor)this, capabilities);
                this.addText(")");
                break;
            }
            case NOT: {
                if (node.getNumberChildren() != 1) {
                    throw new UnsupportedOperationException();
                }
                SQLQueryNode child = (SQLQueryNode)node.getChild(0);
                if (child.getType() == 301044 || child.getType() == 301024) {
                    child.accept((SQLQueryNodeVisitor)this, capabilities);
                    break;
                }
                this.addText(NOTING);
                this.addText("(");
                ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
                this.addText(")");
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void visit(SQLNativeSql node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLNativeSQLValueExpression node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLNull node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLNullArgument node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLNullIf node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLOption node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLOrdinal node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLOverlaps node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLParameter node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLPartition node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLPeriodValueConstructor node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLProduct node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLProject node, IDataSourceCapabilities capabilities) {
        this.setSelectExpressionActive();
        SQLQueryNode child = (SQLQueryNode)node.getChild(1);
        if (child.getType() != 301030) {
            throw new UnsupportedOperationException();
        }
        child.accept((SQLQueryNodeVisitor)this, capabilities);
        this.unsetSelectExpressionActive();
        child = (SQLQueryNode)node.getChild(0);
        if (child.getType() != 301007 && child.getType() != 301009 && child.getType() != 301016) {
            throw new UnsupportedOperationException();
        }
        child.accept((SQLQueryNodeVisitor)this, capabilities);
        if (node.getNumberChildren() > 2) {
            throw new UnsupportedOperationException();
        }
    }

    public void visit(SQLQuantifier node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLQueryBlock node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLRangeVar node, IDataSourceCapabilities capabilities) {
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        SQLQueryNode parent = (SQLQueryNode)node.getParent();
        int childType = child.getType();
        int parentType = parent.getType();
        if (childType != 301016 || parentType != 301015 && parentType != 301009) {
            throw new UnsupportedOperationException();
        }
        child.accept((SQLQueryNodeVisitor)this, capabilities);
    }

    public void visit(SQLRelation node, IDataSourceCapabilities capabilities) {
        SQLQueryNode parent = (SQLQueryNode)node.getParent();
        int parentType = parent.getType();
        if (parentType != 301007 && parentType != 301015 && parentType != 301009) {
            throw new UnsupportedOperationException();
        }
        this.setFromExpressionActive();
        this.visit((SQLIdentifier)node, capabilities);
        this.unsetFromExpressionActive();
    }

    public void visit(SQLRowValueConstructor node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLRollup node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLSearchedCase node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLSelect node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLSetOperator node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLSimilar node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLSimpleCase node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLSort node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
        if (2 < node.getNumberChildren()) {
            throw new UnsupportedOperationException();
        }
        ((SQLQueryNode)node.getChild(1)).accept((SQLQueryNodeVisitor)this, capabilities);
    }

    public void visit(SQLSortKeyList node, IDataSourceCapabilities capabilities) {
        this.setSortExpressionActive();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(", ");
            }
            ((SQLQueryNode)node.getChild(i)).accept((SQLQueryNodeVisitor)this, capabilities);
        }
        this.unsetSortExpressionActive();
    }

    public void visit(SQLSortKey node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
        if (node.isAscending()) {
            this.addText(KEYWORD_ASC);
        } else {
            this.addText(KEYWORD_DESC);
        }
        if (node.getNullOrder() == SQLSortKey.NullOrdering.NULLS_FIRST || node.getNullOrder() == SQLSortKey.NullOrdering.NULLS_LAST) {
            throw new UnsupportedOperationException();
        }
    }

    public void visit(SQLSubQuery node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLSummaryFilter node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLTableFunction node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLTableValueConstructor node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLTrim node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLTop node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLUser node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLValueExpression node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLValueList node, IDataSourceCapabilities capabilities) {
        if (((SQLQueryNode)node.getParent()).getType() == 301015) {
            for (int i = 0; i < node.getNumberChildren(); ++i) {
                ((SQLQueryNode)node.getChild(i)).accept((SQLQueryNodeVisitor)this, capabilities);
            }
        } else if (((SQLQueryNode)node.getParent()).getType() == 301076) {
            this.addText(EQUAL);
            ((SQLQueryNode)node.getChild(0)).accept((SQLQueryNodeVisitor)this, capabilities);
            for (int i = 1; i < node.getNumberChildren(); ++i) {
                this.addText(ORING);
                this.addText(this.inColumnIdentifier);
                this.addText(EQUAL);
                ((SQLQueryNode)node.getChild(i)).accept((SQLQueryNodeVisitor)this, capabilities);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void visit(SQLWhen node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLWindowList node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLWindow node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void visit(SQLWith node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    public void setSelectExpressionActive() {
        if (!this.noExpressionActive()) {
            throw new UnsupportedOperationException();
        }
        this.currentQExp = QueryExpressions.SELECT;
    }

    public void unsetSelectExpressionActive() {
        if (!this.selectExpressionActive()) {
            throw new UnsupportedOperationException();
        }
        this.clear();
        this.currentQExp = QueryExpressions.NONE;
    }

    public boolean selectExpressionActive() {
        return this.currentQExp == QueryExpressions.SELECT;
    }

    public void setFromExpressionActive() {
        if (!this.noExpressionActive()) {
            throw new UnsupportedOperationException();
        }
        this.currentQExp = QueryExpressions.FROM;
    }

    public void unsetFromExpressionActive() {
        if (!this.fromExpressionActive()) {
            throw new UnsupportedOperationException();
        }
        this.clear();
        this.currentQExp = QueryExpressions.NONE;
    }

    public boolean fromExpressionActive() {
        return this.currentQExp == QueryExpressions.FROM;
    }

    public void setSortExpressionActive() {
        if (!this.noExpressionActive()) {
            throw new UnsupportedOperationException();
        }
        this.currentQExp = QueryExpressions.SORT;
    }

    public void unsetSortExpressionActive() {
        if (!this.sortExpressionActive()) {
            throw new UnsupportedOperationException();
        }
        this.queryBean.setSortSpecification(this.getBuffer().toString());
        this.clear();
        this.currentQExp = QueryExpressions.NONE;
    }

    public boolean sortExpressionActive() {
        return this.currentQExp == QueryExpressions.SORT;
    }

    public void setSearchExpressionActive() {
        if (!this.noExpressionActive()) {
            throw new UnsupportedOperationException();
        }
        this.currentQExp = QueryExpressions.SEARCH;
    }

    public void unsetSearchExpressionActive() {
        if (!this.searchExpressionActive()) {
            throw new UnsupportedOperationException();
        }
        this.queryBean.setSearchExpression(this.getBuffer().toString());
        this.clear();
        this.currentQExp = QueryExpressions.NONE;
    }

    public boolean searchExpressionActive() {
        return this.currentQExp == QueryExpressions.SEARCH;
    }

    public boolean noExpressionActive() {
        return this.currentQExp == QueryExpressions.NONE;
    }

    public String getParsedSQL() {
        if (this.buffer != null) {
            return this.buffer.toString();
        }
        return null;
    }

    private static enum QueryExpressions {
        SELECT,
        FROM,
        SORT,
        SEARCH,
        NONE;

    }

    private static enum COUNT {
        ZERO,
        ONE,
        TWO,
        THREE,
        FOUR,
        FIVE,
        SIX,
        SEVEN,
        EIGHT,
        NINE;

    }
}

