/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.siebel;

import com.cognos.cdms.ds.logger.Logger;
import com.cognos.cdms.ds.siebel.beans.SiebelQueryBean;
import com.cognos.cdms.ds.siebel.sdb.SDBException;
import com.cognos.cdms.ds.siebel.sdb.SDBLoggerModule;
import com.cognos.cdms.ds.siebel.sdb.SDBResultSet;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.cache.ICaching;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.erp.ERPCancelHandler;
import com.cognos.xqe.data.providers.relational.erp.ERPConnection;
import com.cognos.xqe.data.providers.relational.erp.ERPDataProvider;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.ERPTabularResult;
import com.cognos.xqe.data.providers.relational.erp.siebel.SiebelConnection;
import com.cognos.xqe.data.providers.relational.erp.siebel.SiebelQueryBeanBuilder;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IPhysicalColumn;
import com.cognos.xqe.metadata.IPhysicalTable;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.ibm.icu.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SiebelTabularResult
extends ERPTabularResult {
    private static Logger logger = SDBLoggerModule.getLoggerFactory().getLogger(SiebelTabularResult.class);
    private static final String MVL = "(M)";
    private static final String PJ = "(P)";
    private static final String MVL_AND_PJ = "(MP)";
    private static final String PERIOD = ".";
    protected ERPCancelHandler cancelHandler = null;
    static final long serialVersionUID = 1L;
    public static final String DATASOURCE_TYPES_FORMAT = "datasource.type.%1$s";
    public static final String DATASOURCE_SPLIT_FORMAT = "datasource.type.%1$s.separator";
    public static final String DATASOURCE_MAPPING_FORMAT = "datasource.type.%1$s.mapping";
    public static final String DATASOURCE_METHOD_FORMAT = "datasource.type.%1$s.method";
    public static final String SIEBEL = "Siebel Adapter";
    protected ERPDataProvider dataProvider;
    protected IPooledConnection pooledConnection;
    protected SQLQueryArguments queryArgs;
    protected ERPConnection connection;
    protected SDBResultSet resultSet;
    protected boolean emptyResultSet = false;
    protected int nIterators;
    protected List<ITabularResultSet> siblings = new ArrayList<ITabularResultSet>();
    protected IExecutionEnvironment execEnv = null;
    protected boolean getTimeTzUsingCalendar = false;
    protected boolean getTimestampTzUsingCalendar = false;
    protected boolean bCanceled = false;
    protected XQEBaseQueryNode parent;
    public static final String NAME = "name";
    public static final String SCHEMA = "schema";
    public static final String CATALOG = "catalog";
    private final SimpleDateFormat siebelDateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private final SimpleDateFormat siebelDateTimeFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public SiebelTabularResult(XDataContext context, IPooledConnection thePooledConnection, SQLQueryArguments theQueryArgs, Integer nodeId, ERPDataProvider theDataProvider) {
        super(context, thePooledConnection, theQueryArgs, nodeId, theDataProvider);
        if (logger.isDebug()) {
            StringBuilder builder = new StringBuilder();
            builder.append(((Object)((Object)this)).getClass().getName());
            builder.append("_SiebelTabularResult");
            builder.append("_SQLQuery: " + theQueryArgs.getSQLQuery());
            logger.debug(builder.toString());
        }
        this.execEnv = context.getEnvironment();
        this.dataProvider = theDataProvider;
        this.queryArgs = theQueryArgs;
        this.parent = this.queryArgs.getParent();
        this.pooledConnection = thePooledConnection;
        this.connection = (ERPConnection)((Object)this.pooledConnection.getConnection());
        this.cancelHandler = new ERPCancelHandler(this);
        context.getEnvironment().getCancelManager().addCancelHandler((ICancelable)this.cancelHandler);
        this.setEmptyResultset(false);
        SDBResultSet sdbRSet = null;
        RowsetInfo rowsetInfo = new RowsetInfo();
        IXQEQueryNode rootNode = SiebelQueryBeanBuilder.parseSql(theQueryArgs.getSQLQuery());
        IXQEQueryNode tableNode = this.findTableNode(rootNode);
        if (tableNode == null) {
            logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelErrorNotRetrieveTableName, (Locale)XQEMessages.getCurrProductLocale()));
            throw new ERPException(XQEMessageKeys.ERP_SiebelErrorNotRetrieveTableName);
        }
        String tableName = (String)tableNode.getPropertyValue(NAME);
        String tableSchema = (String)tableNode.getPropertyValue(SCHEMA);
        String tableCatalog = (String)tableNode.getPropertyValue(CATALOG);
        try {
            Hashtable<String, IDataType> columnsMetadata = new Hashtable<String, IDataType>();
            Hashtable<String, Boolean> mvlMetadata = new Hashtable<String, Boolean>();
            Hashtable<String, Boolean> pjMetadata = new Hashtable<String, Boolean>();
            this.prepareTableMetadata(theQueryArgs, columnsMetadata, mvlMetadata, pjMetadata, tableCatalog, tableSchema, tableName);
            SiebelQueryBeanBuilder queryTreeWalker = null;
            SiebelQueryBean qBean = new SiebelQueryBean();
            qBean.setViewMode(3);
            queryTreeWalker = this.connection instanceof SiebelConnection ? new SiebelQueryBeanBuilder(qBean, mvlMetadata, pjMetadata, ((SiebelConnection)this.connection).getPrimaryRecordOnly()) : new SiebelQueryBeanBuilder(qBean, mvlMetadata, pjMetadata, false);
            ((SQLQueryNode)rootNode).accept((SQLQueryNodeVisitor)queryTreeWalker, this.connection.getCapabilities());
            qBean.setSql(queryTreeWalker.getParsedSQL());
            this.dumpQbeanInfo(qBean);
            sdbRSet = ((SiebelConnection)this.connection).executeQuery(qBean);
            if (!sdbRSet.first()) {
                logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelErrorNoRowsFetched, (Locale)XQEMessages.getCurrProductLocale()));
                this.setEmptyResultset(true);
            }
            Iterator columns = sdbRSet.getColumns().iterator();
            int i = 0;
            while (columns.hasNext()) {
                String columnName = (String)columns.next();
                rowsetInfo.addColumnInfo((IColumnInfo)new ColumnInfo(columnName, columnsMetadata.get(columnName)));
                ++i;
            }
        }
        catch (SDBException e) {
            logger.log((Throwable)e);
            this.release();
            throw new ERPException(XQEMessageKeys.ERP_SiebelErrorSDBException, e);
        }
        catch (UnsupportedOperationException ue) {
            logger.log((Throwable)ue);
            this.release();
            throw new ERPException(XQEMessageKeys.ERP_SiebelUnsupportedOperationException, ue);
        }
        if (sdbRSet == null || rowsetInfo == null) {
            logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelNullResultset, (Locale)XQEMessages.getCurrProductLocale()));
            throw new ERPException(XQEMessageKeys.ERP_SiebelNullResultset);
        }
        this.setResultset(sdbRSet);
        this.setRowsetInfo((IRowsetInfo)rowsetInfo);
    }

    private void setResultset(SDBResultSet resultSetParam) {
        this.resultSet = resultSetParam;
    }

    private void setEmptyResultset(boolean resultSetParam) {
        this.emptyResultSet = resultSetParam;
    }

    private boolean getEmptyResultset() {
        return this.emptyResultSet;
    }

    private void setRowsetInfo(IRowsetInfo rowsetInfoParam) {
        this.rowsetInfo = rowsetInfoParam;
    }

    private void dumpQbeanInfo(SiebelQueryBean qBean) {
        if (logger.isDebug()) {
            StringBuilder builder = new StringBuilder();
            builder.append(SiebelTabularResult.class.getName());
            builder.append("_dumpQbeanInfo");
            builder.append("_Final Query Bean: ");
            builder.append("_getBusinessObject: " + qBean.getBusinessObject());
            builder.append("_BusinessComponent: " + qBean.getBusinessComponent());
            builder.append("_SearchExpression: " + qBean.getSearchExpression());
            builder.append("_SortSpecification: " + qBean.getSortSpecification());
            builder.append("_Fields: ");
            List fields = qBean.getFields();
            if (fields != null) {
                for (int i = 0; i < fields.size(); ++i) {
                    builder.append(" field " + i + "=" + (String)fields.get(i));
                }
            }
            logger.debug(builder.toString());
        }
    }

    private void prepareTableMetadata(SQLQueryArguments theQueryArgs, Hashtable<String, IDataType> columnsMetadata, Hashtable<String, Boolean> mvlMetadata, Hashtable<String, Boolean> pjMetadata, String catName, String schemaName, String tableName) {
        StringBuilder builder = new StringBuilder();
        builder.append(SiebelTabularResult.class.getName());
        MetadataConnection mdConnection = (MetadataConnection)theQueryArgs.getParent().getPlanningEnvironment().getMetadataConnection();
        List mdlist = mdConnection.getPhysicalMetadata(theQueryArgs.getDataSource().getCMDataSourceName(), catName, schemaName, tableName, true, true);
        String columnActualName = null;
        String columnTechnicalName = null;
        Boolean isMVL = false;
        Boolean isPJ = false;
        Iterator iterator = mdlist.iterator();
        if (iterator.hasNext()) {
            IMetadata md = (IMetadata)iterator.next();
            List columns = ((IPhysicalTable)md).getColumns();
            for (IPhysicalColumn column : columns) {
                columnTechnicalName = column.getName();
                columnActualName = SiebelTabularResult.removeMVLAndPJInfoFromColumnName(columnTechnicalName);
                columnsMetadata.put(columnActualName, column.getDataType());
                isMVL = columnTechnicalName.endsWith(MVL) || columnTechnicalName.endsWith(MVL_AND_PJ);
                mvlMetadata.put(columnActualName, isMVL);
                isPJ = columnTechnicalName.endsWith(PJ) || columnTechnicalName.endsWith(MVL_AND_PJ);
                pjMetadata.put(columnActualName, isPJ);
                if (logger.isDebug()) {
                    builder.append("_prepareTableMetadata");
                    builder.append("_columnActualName:" + columnActualName);
                    builder.append("_columnTechnicalName:" + columnTechnicalName);
                    builder.append("_isMVL:" + isMVL);
                    builder.append("_isPJ:" + isPJ);
                }
                isMVL = false;
                isPJ = false;
            }
        }
        if (logger.isDebug()) {
            logger.debug(builder.toString());
        }
    }

    private IXQEQueryNode findTableNode(IXQEQueryNode rootNode) {
        if (rootNode != null) {
            IXQEQueryNode[] tableNodes = rootNode.getDescendantsOfType(301016, false);
            if (tableNodes != null && tableNodes.length > 0) {
                if (logger.isDebug()) {
                    logger.debug(SiebelTabularResult.class.getName() + "_" + "findTableNode" + "_" + tableNodes[0].getPropertyValue(NAME));
                }
                return tableNodes[0];
            }
        } else {
            logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelErrorNULLRootNode, (Locale)XQEMessages.getCurrProductLocale()));
        }
        return null;
    }

    public long getRowCount() {
        return -1L;
    }

    public ITabularIterator getTabularIterator() {
        if (this.nIterators++ == 0) {
            return new ERPTabularResultIterator(this.getDataContext(), this.nodeId);
        }
        try {
            ITabularResultSet sibling = this.dataProvider.query(this.getDataContext(), this.queryArgs);
            this.siblings.add(sibling);
            return sibling.getTabularIterator();
        }
        catch (XQEException e) {
            logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelErrorGettingResultSetIterator, (Locale)XQEMessages.getCurrProductLocale()));
            throw new XQERuntimeException((Throwable)e);
        }
    }

    public IScrollableIterator getScrollableTabularIterator() {
        throw new UnsupportedOperationException();
    }

    protected void releaseImpl() {
        try {
            for (ITabularResultSet sibling : this.siblings) {
                sibling.release();
            }
        }
        finally {
            this.returnConnection();
            if (this.cancelHandler != null) {
                this.execEnv.getCancelManager().removeCancelHandler((ICancelable)this.cancelHandler);
                this.cancelHandler = null;
                if (this.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
        }
        super.releaseImpl();
    }

    public IDataSourceCapabilities getCapabilities() {
        return this.connection.getCapabilities();
    }

    public boolean isCanceled() {
        return this.bCanceled;
    }

    public void setCanceled(boolean cancelled) {
        this.bCanceled = cancelled;
    }

    private void onEndOfData() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        finally {
            this.returnConnection();
            this.resultSet = null;
        }
    }

    private void returnConnection() {
        if (this.pooledConnection != null) {
            this.pooledConnection.returnConnection();
            this.pooledConnection = null;
        }
    }

    public IPooledConnection delegatePooledConnection() {
        IPooledConnection result = this.pooledConnection;
        this.pooledConnection = null;
        return result;
    }

    public Date siebelParseDate(String date) {
        try {
            if (date != null && !date.equals("")) {
                return this.siebelDateFormat.parse(date);
            }
        }
        catch (ParseException pe) {
            logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelDateParseException, (Locale)XQEMessages.getCurrProductLocale()), (Throwable)pe);
        }
        return null;
    }

    public Date siebelParseDateTime(String date) {
        try {
            if (date != null && !date.equals("")) {
                return this.siebelDateTimeFormat.parse(date);
            }
        }
        catch (ParseException pe) {
            logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelDateTimeParseException, (Locale)XQEMessages.getCurrProductLocale()), (Throwable)pe);
        }
        return null;
    }

    public static String removeMVLAndPJInfoFromColumnName(String inputColName) {
        String output = null;
        if (inputColName.endsWith(MVL_AND_PJ)) {
            int lastIndexOfMVLAndPJ = inputColName.lastIndexOf(MVL_AND_PJ);
            output = inputColName.substring(0, lastIndexOfMVLAndPJ);
        } else if (inputColName.endsWith(PJ)) {
            int lastIndexOfPJ = inputColName.lastIndexOf(PJ);
            output = inputColName.substring(0, lastIndexOfPJ);
        } else if (inputColName.endsWith(MVL)) {
            int lastIndexOfMVL = inputColName.lastIndexOf(MVL);
            output = inputColName.substring(0, lastIndexOfMVL);
        } else if (inputColName.endsWith("(MP).") || inputColName.endsWith("(M).") || inputColName.endsWith("(P).")) {
            int lastIndexOfPeriod = inputColName.lastIndexOf(PERIOD);
            output = inputColName.substring(0, lastIndexOfPeriod);
        } else {
            output = inputColName;
        }
        return output;
    }

    protected class ERPTabularResultIterator
    extends XTabularIterator
    implements ICaching {
        private int nColumns;
        private RowValue row;
        private final AtomicBoolean mReleased;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ERPTabularResultIterator(XDataContext context, Integer id) {
            super(context, id);
            this.mReleased = new AtomicBoolean(false);
            try {
                this.startTimer();
                this.nColumns = SiebelTabularResult.this.rowsetInfo.getNumColumns();
                this.row = DataValueFactory.createRowValue((Collator)context.getLocalCollator(), (IRowsetInfo)SiebelTabularResult.this.rowsetInfo);
            }
            finally {
                this.stopTimer();
            }
            ReleasableResourceTracker parentTracker = SiebelTabularResult.this.getResourceTracker();
            parentTracker.addInstance((IReleasable)this, Thread.currentThread().getStackTrace());
        }

        public Object nextImpl() {
            if (SiebelTabularResult.this.isCanceled()) {
                logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelResultRetrievalCancelled, (Locale)XQEMessages.getCurrProductLocale()));
                throw new OperationCanceledException();
            }
            if (SiebelTabularResult.this.getEmptyResultset()) {
                this.release();
                SiebelTabularResult.this.onEndOfData();
                return null;
            }
            if (this.nRows == 0) {
                this.retrieveOneRowResult();
            } else if (SiebelTabularResult.this.resultSet.next()) {
                this.retrieveOneRowResult();
            } else {
                this.release();
                SiebelTabularResult.this.onEndOfData();
                return null;
            }
            ++this.nRows;
            return this.row;
        }

        private void retrieveOneRowResult() {
            for (int i = 0; i < this.nColumns; ++i) {
                Value outColumnValue = (Value)this.row.getColumn(i);
                String columnName = (String)SiebelTabularResult.this.resultSet.getColumns().get(i);
                String inColumnValue = SiebelTabularResult.this.resultSet.getString(columnName);
                if (logger.isDebug()) {
                    logger.debug(" Column-name " + columnName + " value = " + inColumnValue);
                }
                if (inColumnValue != null) {
                    switch (outColumnValue.getDataType().getCCLTypeCode()) {
                        case 1: 
                        case 45: 
                        case 55: 
                        case 56: {
                            if (outColumnValue.getDataType().getLength() > 0 && inColumnValue.length() > outColumnValue.getDataType().getLength()) {
                                String trucatedValue = inColumnValue.substring(0, outColumnValue.getDataType().getLength());
                                outColumnValue.set(trucatedValue);
                                break;
                            }
                            if (inColumnValue == null) {
                                outColumnValue.setNull();
                                break;
                            }
                            outColumnValue.set(inColumnValue);
                            break;
                        }
                        case 4: 
                        case 6: 
                        case 8: {
                            Long longValue = null;
                            try {
                                longValue = Long.parseLong(inColumnValue);
                                outColumnValue.set((Object)longValue);
                            }
                            catch (NumberFormatException nfe) {
                                outColumnValue.setNull();
                            }
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: {
                            try {
                                outColumnValue.set(Double.parseDouble(inColumnValue));
                            }
                            catch (NumberFormatException nfe) {
                                outColumnValue.setNull();
                            }
                            break;
                        }
                        case 57: {
                            Date dateValue = SiebelTabularResult.this.siebelParseDate(inColumnValue);
                            if (dateValue != null) {
                                outColumnValue.set((Object)dateValue);
                                break;
                            }
                            outColumnValue.setNull();
                            break;
                        }
                        case 59: {
                            Date dateTimeValue = SiebelTabularResult.this.siebelParseDateTime(inColumnValue.toString());
                            if (dateTimeValue != null) {
                                Calendar calendar = Calendar.getInstance();
                                calendar.setTime(dateTimeValue);
                                outColumnValue.set(String.format("%1$04d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13)));
                                break;
                            }
                            outColumnValue.setNull();
                            break;
                        }
                        case 58: {
                            outColumnValue.set(inColumnValue);
                            break;
                        }
                        default: {
                            outColumnValue.setNull();
                            break;
                        }
                    }
                } else {
                    outColumnValue.setNull();
                }
                this.row.setColumn(i, (IValue)outColumnValue);
            }
        }

        public long getIndex() {
            return this.nRows;
        }

        public IDataType getDataType() {
            return SiebelTabularResult.this.rowsetInfo.getDataType();
        }

        public boolean isCaching() {
            return SiebelTabularResult.this.isCaching();
        }

        public void release() {
            try {
                if (this.mReleased.compareAndSet(false, true)) {
                    ReleasableResourceTracker parentTracker = SiebelTabularResult.this.getResourceTracker();
                    parentTracker.removeInstance((IReleasable)this);
                    if (SiebelTabularResult.this.resultSet != null) {
                        SiebelTabularResult.this.resultSet.close();
                        SiebelTabularResult.this.resultSet = null;
                    }
                    --SiebelTabularResult.this.nIterators;
                }
            }
            catch (Throwable e) {
                logger.log(XQEMessages.getMessage((IMessageKey.Param0)XQEMessageKeys.ERP_SiebelErrorInrelease, (Locale)XQEMessages.getCurrProductLocale()), e);
            }
        }
    }
}

