/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sap;

import com.cognos.jdbc.driver.sap.SAPObjectHandler;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPABAPQueryInfo;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPABAPQueryIntrospectorBean;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFunctionalArea;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SAPABAPQueryHandler
extends SAPObjectHandler {
    private SAPABAPQueryIntrospectorBean introspector = null;
    private static final String ABAP_QUERY_NAME_VARIENT_SEPARATOR = "::";
    private static final String ABAP_QUERY_NAME_USER_GRP_SEPARATOR = "::";

    public SAPABAPQueryHandler(SAPABAPQueryIntrospectorBean bean) {
        super("ABAP Queries");
        this.introspector = bean;
    }

    @Override
    public List<String> getCatalogs() {
        ArrayList<String> catalogs = new ArrayList<String>();
        catalogs.add("ABAP Queries");
        return catalogs;
    }

    @Override
    public List<String> getSchemas(String catalogName) {
        try {
            List queryAreas = this.introspector.getQueryAreas();
            if (queryAreas != null) {
                ArrayList<String> schemas = new ArrayList<String>();
                for (String queryArea : queryAreas) {
                    List functionalAreas = this.introspector.getFunctionalAreas(queryArea);
                    for (SAPFunctionalArea area : functionalAreas) {
                        String functionalArea = area.getDescription() + "(" + area.getArea() + ")";
                        schemas.add(this.mergeTwoLevel(queryArea, functionalArea));
                    }
                }
                return schemas;
            }
        }
        catch (ERPException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>();
    }

    @Override
    public void getTables(String catalogName, String schemaName, String tableNameFilter, List<String> tableNames, List<String> remarks) {
        if (tableNameFilter != null) {
            tableNames.add(tableNameFilter);
            return;
        }
        try {
            if (tableNames == null || remarks == null) {
                throw new RuntimeException("List<String> tableNames OR List<String> remarks cannot be null");
            }
            String functionalArea = this.extractLevelTwo(schemaName);
            String functionalAreaTechnicalName = this.extractTechnicalNameFromSchemaName(functionalArea);
            String queryArea = this.extractLevelOne(schemaName);
            List queryInfo = this.introspector.getABAPQueries(functionalAreaTechnicalName, queryArea, this.extractTechnicalNameFromTableName(tableNameFilter));
            for (SAPABAPQueryInfo info : queryInfo) {
                String tableName = (String)info.getAttributes().get("Query Text");
                String queryName = (String)info.getAttributes().get("sap-query-name");
                String varient = (String)info.getAttributes().get("sap-query-variant");
                if (varient != null && varient.length() > 0) {
                    queryName = queryName + "::" + varient;
                }
                String abapQueryUserGroup = (String)info.getAttributes().get("sap-query-usergroup");
                String remark = "attributes:sap-query-usergroup=" + abapQueryUserGroup;
                tableName = tableName + "(" + abapQueryUserGroup + "::" + queryName + ")";
                tableNames.add(tableName);
                remarks.add(remark);
            }
        }
        catch (ERPException e) {
            return;
        }
    }

    @Override
    public List<SAPFieldMetadata> getColumns(String catalogName, String schemaName, String tableName) {
        String queryArea = this.extractLevelOne(schemaName);
        String functionalArea = this.extractLevelTwo(schemaName);
        functionalArea = this.extractTechnicalNameFromSchemaName(functionalArea);
        String queryName = this.extractTechnicalNameFromTableName(tableName);
        try {
            List queryInfo;
            Object genAbapQuery = null;
            List columns = null;
            int indexOfSeparator = queryName.lastIndexOf("::");
            String varient = null;
            if (indexOfSeparator > 0) {
                varient = queryName.substring(indexOfSeparator + "::".length());
                queryName = queryName.substring(0, indexOfSeparator);
            }
            if ((queryInfo = this.introspector.getABAPQueries(functionalArea, queryArea, queryName)) != null && queryInfo.size() > 0) {
                SAPABAPQueryInfo table = (SAPABAPQueryInfo)queryInfo.get(0);
                Map attrs = table.getAttributes();
                String userGroup = (String)attrs.get("sap-query-usergroup");
                if (varient == null) {
                    varient = (String)attrs.get("sap-query-variant");
                }
                columns = this.introspector.getABAPQueryFields(queryArea, userGroup, queryName, varient);
            }
            this.appendTechnicalNames(columns);
            return columns;
        }
        catch (ERPException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void appendTechnicalNames(List<SAPFieldMetadata> columns) {
        for (SAPFieldMetadata column : columns) {
            column.setName(column.getName() + "(" + column.getText() + ")");
        }
    }

    private String extractTechnicalNameFromSchemaName(String tableName) {
        if (tableName == null) {
            return null;
        }
        tableName = this.extractTechnicalName(tableName);
        return tableName;
    }

    private String extractTechnicalNameFromTableName(String tableName) {
        if (tableName == null) {
            return null;
        }
        String[] tokens = (tableName = this.extractTechnicalName(tableName)).split("::");
        if (tokens.length == 2) {
            return tokens[1];
        }
        if (tokens.length == 3) {
            return tokens[1] + "::" + tokens[2];
        }
        return tableName;
    }

    private String extractTechnicalName(String name) {
        if (name == null) {
            return null;
        }
        int indexOfOpenParen = name.lastIndexOf("(");
        int indexOfCloseParen = name.lastIndexOf(")");
        if (indexOfCloseParen > -1 && indexOfOpenParen > -1) {
            name = name.substring(indexOfOpenParen + 1, indexOfCloseParen);
        }
        return name;
    }

    private String extractDescription(String name) {
        if (name == null) {
            return null;
        }
        int indexOfOpenParen = name.lastIndexOf("(");
        int indexOfCloseParen = name.lastIndexOf(")");
        if (indexOfCloseParen > -1 && indexOfOpenParen > -1) {
            name = name.substring(0, indexOfOpenParen);
        }
        return name;
    }
}

