/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sap;

import com.cognos.jdbc.driver.sap.SAPObjectHandler;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPBAPIIntrospectorBean;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import java.util.ArrayList;
import java.util.List;

public class SAPBAPIHandler
extends SAPObjectHandler {
    private SAPBAPIIntrospectorBean mIntrospectorBean = null;

    public SAPBAPIHandler(SAPBAPIIntrospectorBean bean) {
        super("BAPIs");
        this.mIntrospectorBean = bean;
    }

    @Override
    public List<String> getCatalogs() {
        ArrayList<String> catalogs = new ArrayList<String>();
        catalogs.add("BAPIs");
        return catalogs;
    }

    @Override
    public List<String> getSchemas(String catalogName) {
        try {
            List busComps = this.mIntrospectorBean.getBusinessComponents();
            if (busComps != null) {
                ArrayList<String> schemas = new ArrayList<String>();
                for (String busComp : busComps) {
                    List busObjs = this.mIntrospectorBean.getObjects(busComp);
                    if (busObjs == null) continue;
                    for (String busObj : busObjs) {
                        schemas.add(this.mergeTwoLevel(busComp, busObj));
                    }
                }
                return schemas;
            }
        }
        catch (ERPException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>();
    }

    @Override
    public void getTables(String catalogName, String schemaName, String tableNameFilter, List<String> tableNames, List<String> remarks) {
        try {
            if (tableNames == null) {
                throw new RuntimeException("List<String> tableNames cannot be null");
            }
            if (tableNameFilter != null) {
                tableNames.add(tableNameFilter);
            } else {
                List bapiNames = this.mIntrospectorBean.getBAPIs(this.extractLevelTwo(schemaName), tableNameFilter);
                tableNames.addAll(bapiNames);
            }
        }
        catch (ERPException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<SAPFieldMetadata> getColumns(String catalogName, String schemaName, String tableName) {
        try {
            return this.mIntrospectorBean.getBAPIFields(tableName);
        }
        catch (ERPException e) {
            e.printStackTrace();
            return new ArrayList<SAPFieldMetadata>();
        }
    }
}

