/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sap;

import com.cognos.jdbc.driver.sap.SAPObjectHandler;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPABAPQueryIntrospectorBean;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFunctionalArea;
import java.util.ArrayList;
import java.util.List;

public class SAPInfosetHandler
extends SAPObjectHandler {
    private SAPABAPQueryIntrospectorBean introspector = null;
    private static final String ABAP_QUERY_NAME_VARIENT_SEPARATOR = "::";
    private static final String ABAP_QUERY_NAME_USER_GRP_SEPARATOR = "::";

    public SAPInfosetHandler(SAPABAPQueryIntrospectorBean bean) {
        super("Infosets");
        this.introspector = bean;
    }

    @Override
    public List<String> getCatalogs() {
        ArrayList<String> catalogs = new ArrayList<String>();
        catalogs.add("Infosets");
        return catalogs;
    }

    @Override
    public List<String> getSchemas(String catalogName) {
        try {
            List queryAreas = this.introspector.getQueryAreas();
            if (queryAreas != null) {
                ArrayList<String> schemas = new ArrayList<String>();
                for (String queryArea : queryAreas) {
                    schemas.add(queryArea);
                }
                return schemas;
            }
        }
        catch (ERPException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>();
    }

    @Override
    public void getTables(String catalogName, String schemaName, String tableNameFilter, List<String> tableNames, List<String> remarks) {
        if (tableNameFilter != null) {
            tableNames.add(tableNameFilter);
            return;
        }
        try {
            if (tableNames == null || remarks == null) {
                throw new RuntimeException("List<String> tableNames OR List<String> remarks cannot be null");
            }
            List functionalAreas = this.introspector.getFunctionalAreas(schemaName);
            for (SAPFunctionalArea area : functionalAreas) {
                tableNames.add(this.extractDescription(area.getDescription()) + "(" + "SYSTGENERATE" + "::" + area.getArea() + ")");
                remarks.add("attributes:sap-query-usergroup=SYSTGENERATE");
            }
        }
        catch (ERPException e) {
            return;
        }
    }

    @Override
    public List<SAPFieldMetadata> getColumns(String catalogName, String schemaName, String tableName) {
        String functionalArea = this.extractLevelTwo(schemaName);
        functionalArea = this.extractTechnicalNameFromSchemaName(functionalArea);
        String queryName = this.extractTechnicalNameFromTableName(tableName);
        try {
            String genAbapQuery = this.introspector.getInfosetQuery(schemaName, queryName);
            List columns = this.introspector.getABAPQueryFields(schemaName, "SYSTGENERATE", genAbapQuery, "");
            this.introspector.deleteGeneratedQuery(schemaName, "SYSTGENERATE", genAbapQuery);
            this.appendTechnicalNames(columns);
            return columns;
        }
        catch (ERPException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void appendTechnicalNames(List<SAPFieldMetadata> columns) {
        for (SAPFieldMetadata column : columns) {
            column.setName(column.getName() + "(" + column.getText() + ")");
        }
    }

    private String extractTechnicalNameFromSchemaName(String tableName) {
        if (tableName == null) {
            return null;
        }
        tableName = this.extractTechnicalName(tableName);
        return tableName;
    }

    private String extractTechnicalNameFromTableName(String tableName) {
        if (tableName == null) {
            return null;
        }
        String[] tokens = (tableName = this.extractTechnicalName(tableName)).split("::");
        if (tokens.length == 2) {
            return tokens[1];
        }
        if (tokens.length == 3) {
            return tokens[1] + "::" + tokens[2];
        }
        return tableName;
    }

    private String extractTechnicalName(String name) {
        if (name == null) {
            return null;
        }
        int indexOfOpenParen = name.lastIndexOf("(");
        int indexOfCloseParen = name.lastIndexOf(")");
        if (indexOfCloseParen > -1 && indexOfOpenParen > -1) {
            name = name.substring(indexOfOpenParen + 1, indexOfCloseParen);
        }
        return name;
    }

    private String extractDescription(String name) {
        if (name == null) {
            return null;
        }
        int indexOfOpenParen = name.lastIndexOf("(");
        int indexOfCloseParen = name.lastIndexOf(")");
        if (indexOfCloseParen > -1 && indexOfOpenParen > -1) {
            name = name.substring(0, indexOfOpenParen);
        }
        return name;
    }
}

