/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sap;

import com.cognos.jdbc.driver.sap.SAPJdbcConnection;
import com.cognos.jdbc.driver.sfdc.AbstractJdbcDriver;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPClientFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPAdvancedProperties;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConnectionInfo;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPDestinationManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class SAPJdbcDriver
extends AbstractJdbcDriver {
    private static final String SAP_CONN_URL_INVALID = "Unable to connect to SAP using the supplied URL. ";
    private static final String SAP_FAILED_TO_CONNECT = "Failed to connect to SAP. Some of the connection parameters may be incorrect";
    static Pattern loadBalancedPattern;
    static Pattern singleServerPattern;
    private static final String OPTION_MAX_CONN = "MAX_CONN";
    private static final String OPTION_ABAP_QUERY_DB_ACCESSES = "ABAP_QUERY_DB_ACCESSES";
    private static final String OPTION_ROW_COUNT = "TABLE_READ_COUNT";
    private static final String OPTION_READ_TABLE_FUNCTION_NAME = "READ_TABLE_FUNCTION_NAME";
    private static final Integer defaultMaxConn;

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException {
        return null;
    }

    @Override
    protected boolean matchesPattern(String url) {
        if (!singleServerPattern.matcher(url).matches()) {
            return loadBalancedPattern.matcher(url).matches();
        }
        return true;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String[] parts = url.split(";");
        if (parts != null && parts.length > 0) {
            String sapUrl = parts[0];
            String[] urlParts = sapUrl.split(":");
            String[] options = new String[parts.length - 1];
            System.arraycopy(parts, 1, options, 0, options.length);
            this.mergeURLOptions(options, info);
            SAPAdvancedProperties advProps = this.getSAPAdvancedProperties(info);
            String userName = info.getProperty("user");
            String password = info.getProperty("password");
            String client = null;
            String language = null;
            String routerString = null;
            String[] routerStringTempHolder = null;
            SAPConnectionInfo sapConnInfo = new SAPConnectionInfo();
            if (!"LB".equals(urlParts[1])) {
                String appServer = urlParts[1];
                String sysNum = urlParts[2];
                routerString = urlParts[3];
                if (routerString != null) {
                    routerStringTempHolder = routerString.split("=");
                    routerString = routerStringTempHolder.length <= 1 ? null : routerStringTempHolder[1];
                }
                client = urlParts[4];
                language = urlParts[5];
                sapConnInfo.setServer(appServer);
                sapConnInfo.setSystemNo(sysNum);
            } else {
                String msgServer = urlParts[2];
                String sysId = urlParts[3];
                String logonGroup = urlParts[4];
                client = urlParts[6];
                language = urlParts[7];
                sapConnInfo.setMessageServer(msgServer);
                sapConnInfo.setSystemId(sysId);
                sapConnInfo.setLogonGroup(logonGroup);
            }
            sapConnInfo.setUser(userName);
            sapConnInfo.setPassword(password);
            sapConnInfo.setClient(client);
            sapConnInfo.setLanguage(language);
            if (routerString != null) {
                sapConnInfo.setRouterString(routerString);
            }
            try {
                String maxConn = info.getProperty(OPTION_MAX_CONN);
                sapConnInfo.setConnPoolCapacity(Integer.valueOf(maxConn).intValue());
            }
            catch (NumberFormatException nfe) {
                sapConnInfo.setConnPoolCapacity(defaultMaxConn.intValue());
            }
            if (this.isConnectionValid(sapConnInfo)) {
                SAPClient sapClient = SAPClientFactory.getSAPClient((SAPConnectionInfo)sapConnInfo, (SAPAdvancedProperties)advProps);
                return new SAPJdbcConnection(sapClient);
            }
            throw new SQLException(SAP_FAILED_TO_CONNECT);
        }
        throw new SQLException(SAP_CONN_URL_INVALID);
    }

    private boolean isConnectionValid(SAPConnectionInfo sapConnInfo) {
        return SAPDestinationManager.testDestination((SAPConnectionInfo)sapConnInfo);
    }

    private SAPAdvancedProperties getSAPAdvancedProperties(Properties props) {
        String readTableFunctionName;
        String abapQueryDbAccesses;
        SAPAdvancedProperties advProps = new SAPAdvancedProperties();
        String rowCount = props.getProperty(OPTION_ROW_COUNT);
        if (rowCount != null && rowCount.length() > 0) {
            advProps.setRowCount(rowCount);
        }
        if ((abapQueryDbAccesses = props.getProperty(OPTION_ABAP_QUERY_DB_ACCESSES)) != null && abapQueryDbAccesses.length() > 0) {
            advProps.setAbapQueryDbAccesses(abapQueryDbAccesses);
        }
        if ((readTableFunctionName = props.getProperty(OPTION_READ_TABLE_FUNCTION_NAME)) != null && readTableFunctionName.length() > 0) {
            advProps.setReadTableFunctionName(readTableFunctionName);
            if (readTableFunctionName.equalsIgnoreCase("RFC_READ_TABLE")) {
                advProps.setParseDecimalValues(false);
                advProps.setTableReadFunDataFieldMaxLength(512);
            } else if (readTableFunctionName.equalsIgnoreCase("YRFC_READ_TABLE")) {
                advProps.setParseDecimalValues(true);
                advProps.setTableReadFunDataFieldMaxLength(4012);
            }
        }
        return advProps;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger() is not supported.");
    }

    static {
        SAPJdbcDriver thisDriver = new SAPJdbcDriver();
        try {
            DriverManager.registerDriver(thisDriver);
            SAPDestinationManager.registerDestinationProvider();
        }
        catch (SQLException sqe) {
            sqe.printStackTrace();
        }
        loadBalancedPattern = Pattern.compile("sap:LB(:\\S+){6,6}(;\\S+=\\S+)*");
        singleServerPattern = Pattern.compile("sap(:([^:]\\S+)){5,5}(;\\S+=\\S+)*");
        defaultMaxConn = 5;
    }
}

