/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sap;

import com.cognos.jdbc.driver.AbstractJdbcDatabaseMetadata;
import com.cognos.jdbc.driver.AsyncJdbcResultSet;
import com.cognos.jdbc.driver.EOFRow;
import com.cognos.jdbc.driver.JdbcResultSet;
import com.cognos.jdbc.driver.Row;
import com.cognos.jdbc.driver.sap.SAPObjectHandler;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.ERPLog;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class SAPJdbcMetadata
extends AbstractJdbcDatabaseMetadata {
    List<SAPObjectHandler> handlers = new ArrayList<SAPObjectHandler>();
    private static Map<Character, Integer> mappings = new HashMap<Character, Integer>();
    private static Map<Integer, String> typeNames;

    @Override
    public ResultSet getExportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        return new JdbcResultSet(FK_MD_COLUMNS);
    }

    @Override
    public ResultSet getIndexInfo(String arg0, String arg1, String arg2, boolean arg3, boolean arg4) throws SQLException {
        return new JdbcResultSet(IDX_MD_COLUMNS);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalogName, String schemaName, String tableName) throws SQLException {
        JdbcResultSet rs = new JdbcResultSet(PK_MD_COLUMNS);
        if (!"Tables".equals(catalogName)) {
            return rs;
        }
        List<SAPFieldMetadata> pkColumns = SAPObjectHandler.getHandler("Tables").getPKColumns();
        if (pkColumns != null) {
            int seqCount = 0;
            for (SAPFieldMetadata field : pkColumns) {
                if (!field.isKey()) continue;
                HashMap<String, String> rowMap = new HashMap<String, String>();
                rowMap.put("TABLE_CAT", catalogName);
                rowMap.put("TABLE_SCHEM", schemaName);
                rowMap.put("TABLE_NAME", tableName);
                rowMap.put("COLUMN_NAME", field.getName());
                rowMap.put("KEY_SEQ", String.valueOf(++seqCount));
                rowMap.put("PK_NAME", tableName + "_PK");
                rs.addResult(new Row(rowMap));
            }
        }
        return rs;
    }

    @Override
    public ResultSet getProcedureColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return new JdbcResultSet(PROC_COLS_MD_COLUMNS);
    }

    @Override
    public ResultSet getProcedures(String arg0, String arg1, String arg2) throws SQLException {
        return new JdbcResultSet(PROC_MD_COLUMNS);
    }

    public void addObjectHandler(SAPObjectHandler handler) {
        if (!this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    private List<String> getCatalogNames() {
        ArrayList<String> catalogNames = new ArrayList<String>();
        for (SAPObjectHandler handler : this.handlers) {
            List<String> catalogs = handler.getCatalogs();
            if (catalogs == null) continue;
            catalogNames.addAll(catalogs);
        }
        return catalogNames;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        JdbcResultSet resultSet = new JdbcResultSet(CATALOG_MD_COLUMNS);
        List<String> catalogNames = this.getCatalogNames();
        for (String catalogName : catalogNames) {
            HashMap<String, String> rowData = new HashMap<String, String>();
            rowData.put("TABLE_CAT", catalogName);
            resultSet.addResult(new Row(rowData));
        }
        return resultSet;
    }

    @Override
    public ResultSet getSchemas(String catalogName, String schemaPattern) throws SQLException {
        JdbcResultSet rs = new JdbcResultSet(SCHEMA_MD_COLUMNS);
        List<String> schemas = this.getSchemaNames(catalogName);
        if (schemas != null && schemas.size() > 0) {
            Collections.sort(schemas, String.CASE_INSENSITIVE_ORDER);
            for (String schema : schemas) {
                HashMap<String, String> rowData = new HashMap<String, String>();
                rowData.put("TABLE_SCHEM", schema);
                rowData.put("TABLE_CATALOG", catalogName);
                rs.addResult(new Row(rowData));
            }
        }
        return rs;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        final LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        AsyncJdbcResultSet resultSet = new AsyncJdbcResultSet(SCHEMA_MD_COLUMNS, queue);
        new Thread(){

            @Override
            public void run() {
                try {
                    List catalogNames = SAPJdbcMetadata.this.getCatalogNames();
                    for (String catalogName : catalogNames) {
                        List schemas = SAPJdbcMetadata.this.getSchemaNames(catalogName);
                        if (schemas == null || schemas.size() <= 0) continue;
                        Collections.sort(schemas, String.CASE_INSENSITIVE_ORDER);
                        for (String schema : schemas) {
                            HashMap<String, String> rowData = new HashMap<String, String>();
                            rowData.put("TABLE_SCHEM", schema);
                            rowData.put("TABLE_CATALOG", catalogName);
                            try {
                                queue.put(new Row(rowData));
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                catch (ERPException e) {
                    ERPLog.getLogger().log("Error in getting Schemas");
                    ERPLog.getLogger((LogLevel)LogLevel.ERROR).log((Throwable)e);
                    throw new XQERuntimeException((Throwable)e);
                }
                finally {
                    try {
                        queue.put(new EOFRow());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }.start();
        return resultSet;
    }

    private void getTableNames(String catalogName, String schemaName, String tableNameFilter, List<String> tableNames, List<String> remarks) {
        SAPObjectHandler handler;
        if (catalogName != null && (handler = SAPObjectHandler.getHandler(catalogName)) != null) {
            handler.getTables(catalogName, schemaName, tableNameFilter, tableNames, remarks);
            Collections.sort(tableNames, String.CASE_INSENSITIVE_ORDER);
        }
    }

    private List<String> getSchemaNames(String catalogName) {
        SAPObjectHandler handler;
        if (catalogName != null && (handler = SAPObjectHandler.getHandler(catalogName)) != null) {
            return handler.getSchemas(catalogName);
        }
        return null;
    }

    @Override
    public ResultSet getTables(String catalogName, String schemaName, String tableNameFilter, String[] types) throws SQLException {
        if (catalogName == null) {
            return this.getCatalogs();
        }
        if (catalogName != null && schemaName == null) {
            return this.getSchemas(catalogName, null);
        }
        boolean isTableTypeSearch = false;
        if (types == null) {
            types = new String[]{"TABLE"};
        }
        for (String type : types) {
            if (!"TABLE".equals(type)) continue;
            isTableTypeSearch = true;
            break;
        }
        if (!isTableTypeSearch) {
            return new JdbcResultSet(TABLE_MD_COLUMNS);
        }
        JdbcResultSet resultSet = new JdbcResultSet(TABLE_MD_COLUMNS);
        try {
            ArrayList<String> tableNames = new ArrayList<String>();
            ArrayList<String> remarks = new ArrayList<String>();
            this.getTableNames(catalogName, schemaName, tableNameFilter, tableNames, remarks);
            if (tableNames != null) {
                int length = tableNames.size();
                for (int i = 0; i < length; ++i) {
                    HashMap<String, String> rowData = new HashMap<String, String>();
                    String tableName = (String)tableNames.get(i);
                    rowData.put("TABLE_CAT", catalogName);
                    rowData.put("TABLE_SCHEM", schemaName);
                    rowData.put("TABLE_NAME", tableName);
                    rowData.put("TABLE_TYPE", "TABLE");
                    if (remarks.size() > i) {
                        rowData.put("REMARKS", (String)remarks.get(i));
                    }
                    resultSet.addResult(new Row(rowData));
                }
            }
        }
        catch (ERPException e) {
            ERPLog.getLogger().log("Error in getting Table List of Pattern :- " + schemaName);
            ERPLog.getLogger((LogLevel)LogLevel.ERROR).log((Throwable)e);
            throw new XQERuntimeException((Throwable)e);
        }
        return resultSet;
    }

    private List<SAPFieldMetadata> getColumnNames(String catalogName, String schemaName, String tableName) {
        SAPObjectHandler handler;
        if (catalogName != null && (handler = SAPObjectHandler.getHandler(catalogName)) != null) {
            return handler.getColumns(catalogName, schemaName, tableName);
        }
        return null;
    }

    @Override
    public ResultSet getColumns(String catalogName, String schemaName, String tableName, String columnNamePattern) throws SQLException {
        JdbcResultSet resultSet = new JdbcResultSet(COLUMN_MD_COLUMNS);
        try {
            List<SAPFieldMetadata> fields = this.getColumnNames(catalogName, schemaName, tableName);
            if (fields != null) {
                for (SAPFieldMetadata field : fields) {
                    HashMap<String, String> rowData = new HashMap<String, String>();
                    rowData.put("TABLE_CAT", catalogName);
                    rowData.put("TABLE_SCHEM", schemaName);
                    rowData.put("TABLE_NAME", tableName);
                    rowData.put("COLUMN_NAME", field.getName());
                    rowData.put("REMARKS", field.getText());
                    rowData.put("DATA_TYPE", this.getFieldType(field).toString());
                    rowData.put("TYPE_NAME", this.getTypeName(field));
                    rowData.put("COLUMN_SIZE", String.valueOf(field.getLength()));
                    rowData.put("DECIMAL_DIGITS", String.valueOf(field.getDecimal()));
                    rowData.put("NULLABLE", field.isMandatory() ? String.valueOf(0) : String.valueOf(1));
                    rowData.put("IS_NULLABLE", field.isMandatory() ? "NO" : "YES");
                    resultSet.addResult(new Row(rowData));
                }
            }
        }
        catch (ERPException e) {
            ERPLog.getLogger().log("Error in getting Column details of table :- " + tableName);
            ERPLog.getLogger((LogLevel)LogLevel.ERROR).log((Throwable)e);
            throw new XQERuntimeException((Throwable)e);
        }
        return resultSet;
    }

    private Integer getFieldType(SAPFieldMetadata field) {
        Integer fieldType = mappings.get(Character.valueOf(field.getType()));
        if (fieldType == null) {
            return 12;
        }
        return fieldType;
    }

    private String getTypeName(SAPFieldMetadata field) {
        String typeName = typeNames.get(this.getFieldType(field));
        if (typeName == null) {
            return "NULL";
        }
        return typeName;
    }

    static {
        mappings.put(Character.valueOf('C'), 12);
        mappings.put(Character.valueOf('N'), 12);
        mappings.put(Character.valueOf('X'), 12);
        mappings.put(Character.valueOf('g'), 12);
        mappings.put(Character.valueOf('y'), 12);
        mappings.put(Character.valueOf('I'), 4);
        mappings.put(Character.valueOf('P'), 3);
        mappings.put(Character.valueOf('F'), 6);
        mappings.put(Character.valueOf('D'), 91);
        mappings.put(Character.valueOf('T'), 92);
        typeNames = new HashMap<Integer, String>();
        typeNames.put(12, "VARCHAR");
        typeNames.put(4, "INTEGER");
        typeNames.put(3, "DECIMAL");
        typeNames.put(6, "FLOAT");
        typeNames.put(91, "DATE");
        typeNames.put(92, "TIME");
    }
}

