/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sap;

import com.cognos.jdbc.driver.sap.SAPObjectHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTableIntrospectorBean;
import java.util.ArrayList;
import java.util.List;

public class SAPTableHandler
extends SAPObjectHandler {
    private SAPTableIntrospectorBean mIntrospector = null;

    public SAPTableHandler(SAPTableIntrospectorBean bean) {
        super("Tables");
        if (bean == null) {
            throw new IllegalArgumentException();
        }
        this.mIntrospector = bean;
    }

    @Override
    public List<String> getCatalogs() {
        ArrayList<String> catalogs = new ArrayList<String>();
        catalogs.add("Tables");
        return catalogs;
    }

    @Override
    public List<String> getSchemas(String catalogName) {
        if (!this.canHandle(catalogName)) {
            return null;
        }
        String[] tableGroups = this.mIntrospector.getSAPTableGroups();
        if (tableGroups != null) {
            ArrayList<String> schemas = new ArrayList<String>();
            for (String tableGroup : tableGroups) {
                String[] schemaNames = this.mIntrospector.getSAPSchema(tableGroup);
                if (schemaNames == null) continue;
                for (String schemaName : schemaNames) {
                    schemas.add(schemaName);
                }
            }
            return schemas;
        }
        return null;
    }

    @Override
    public void getTables(String catalogName, String schemaName, String tableNameFilter, List<String> tableNames, List<String> remarks) {
        if (tableNames == null) {
            throw new RuntimeException("List<String> tableNames cannot be null");
        }
        if (!this.canHandle(catalogName)) {
            return;
        }
        List tableNamesWithDesc = this.mIntrospector.getTablesNamesWithDesc(schemaName, tableNameFilter);
        if (tableNamesWithDesc != null) {
            tableNames.addAll(tableNamesWithDesc);
        }
    }

    @Override
    public List<SAPFieldMetadata> getColumns(String catalogName, String schemaName, String tableName) {
        if (!this.canHandle(catalogName)) {
            return null;
        }
        List columns = this.mIntrospector.getSAPTableFields(tableName);
        return columns;
    }

    public List<SAPFieldMetadata> getPKColumns(String tableName) {
        List columns = this.mIntrospector.getSAPTableFields(tableName);
        ArrayList<SAPFieldMetadata> pkColumns = new ArrayList<SAPFieldMetadata>();
        if (columns != null) {
            for (SAPFieldMetadata field : columns) {
                if (!field.isKey()) continue;
                pkColumns.add(field);
            }
        }
        return pkColumns;
    }
}

