/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sfdc;

import java.util.HashMap;
import java.util.Map;

public enum SFDCOptionEnum {
    USER_NAME("USER_NAME", "userName"),
    PASSWORD("PASSWORD", "password"),
    URL("URL", "url"),
    USER_CONCURRENT_CALLS_LIMIT("USER_CONCURRENT_CALLS_LIMIT", "userConcurrentCallsLimit"),
    CONCURRENT_CALLS_LIMIT("CONCURRENT_CALLS_LIMIT", "concurrentCallsLimit"),
    QUERY_BATCH_SIZE("QUERY_BATCH_SIZE", "queryBatchSize"),
    MAXIMUM_RETRIES("MAXIMUM_RETRIES", "maximumRetries"),
    WAIT_BETWEEN_RETRIES("WAIT_BETWEEN_RETRIES", "waitBetweenRetries"),
    PROXY_ENABLED("PROXY_ENABLED", "proxyEnabled"),
    PROXY_HOST("PROXY_HOST", "proxyHost"),
    PROXY_PORT("PROXY_PORT", "proxyPort"),
    PROXY_USER("proxyUserName", "proxyUserName"),
    PROXY_PWD("proxyPassword", "proxyPassword"),
    BATCH_DELETES_ENABLED("BATCH_DELETES_ENABLED", "batchDeletesEnabled"),
    BATCH_UPDATES_ENABLED("BATCH_UPDATES_ENABLED", "batchUpdatesEnabled"),
    CONNECTION_TIMEOUT("CONNECTION_TIMEOUT", "connectionTimeOut");

    private String mOptionName = null;
    private String mSForceKey = null;
    private static Map<String, SFDCOptionEnum> mOptionMap;

    private SFDCOptionEnum(String optionName, String key) {
        this.mOptionName = optionName;
        this.mSForceKey = key;
    }

    public String getOptionName() {
        return this.mOptionName;
    }

    public String getSForceKey() {
        return this.mSForceKey;
    }

    public static SFDCOptionEnum lookup(String optionName) {
        return mOptionMap.get(optionName);
    }

    static {
        mOptionMap = new HashMap<String, SFDCOptionEnum>();
        for (SFDCOptionEnum optionEnum : SFDCOptionEnum.values()) {
            mOptionMap.put(optionEnum.getOptionName(), optionEnum);
        }
    }
}

