/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.siebel;

import com.cognos.cdms.ds.siebel.beans.SiebelFieldBean;
import java.util.HashMap;
import java.util.Map;

public class SiebelDataTypeHelper {
    private static Map<Integer, Integer> map = new HashMap<Integer, Integer>();

    public static String getTypeName(SiebelFieldBean field) {
        switch (SiebelDataTypeHelper.getSQLType(field)) {
            case 12: {
                return "VARCHAR";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 3: {
                return "DECIMAL";
            }
            case -5: {
                return "BIGINT";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 6: {
                return "FLOAT";
            }
        }
        return "NULL";
    }

    public static int getSQLType(SiebelFieldBean field) {
        Integer sqlType = map.get(field.getDType());
        if (sqlType != null) {
            return sqlType;
        }
        return 0;
    }

    public static int getColumnSize(SiebelFieldBean field) {
        switch (SiebelDataTypeHelper.getSQLType(field)) {
            case -5: 
            case 3: 
            case 6: {
                int precision = field.getPrecision();
                int textLength = field.getTextLength();
                if (precision == 0) {
                    if (textLength == 0) {
                        return 38;
                    }
                    return textLength;
                }
                return precision;
            }
        }
        return field.getTextLength();
    }

    public static int getDecimalDigits(SiebelFieldBean field) {
        if (SiebelDataTypeHelper.getSQLType(field) == 3 || SiebelDataTypeHelper.getSQLType(field) == 6) {
            return field.getScale();
        }
        return 0;
    }

    static {
        map.put(1, 12);
        map.put(3, 16);
        map.put(6, 6);
        map.put(7, 91);
        map.put(10, 93);
        map.put(4, -5);
        map.put(12, 12);
        map.put(5, 6);
        map.put(2, 12);
        map.put(0, 12);
        map.put(11, 93);
        map.put(8, 92);
    }
}

