/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.olap.common;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.TimestampValue;

public final class MSASCommonDatatypes {
    public static final int OLEDB_DATATYPE_INT1 = 16;
    public static final int OLEDB_DATATYPE_INT2 = 2;
    public static final int OLEDB_DATATYPE_INT4 = 3;
    public static final int OLEDB_DATATYPE_INT8 = 20;
    public static final int OLEDB_DATATYPE_R4 = 4;
    public static final int OLEDB_DATATYPE_R8 = 5;
    public static final int OLEDB_DATATYPE_CURRENCY = 6;
    public static final int OLEDB_DATATYPE_DATE = 7;
    public static final int OLEDB_DATATYPE_BSTR = 8;
    public static final int OLEDB_DATATYPE_BOOLEAN = 11;
    public static final int OLEDB_DATATYPE_VARIANT = 12;
    public static final int OLEDB_DATATYPE_DECIMAL = 14;
    public static final int OLEDB_DATATYPE_UINT1 = 17;
    public static final int OLEDB_DATATYPE_UINT2 = 18;
    public static final int OLEDB_DATATYPE_UINT4 = 19;
    public static final int OLEDB_DATATYPE_UINT8 = 21;
    public static final int OLEDB_DATATYPE_GUID = 72;
    public static final int OLEDB_DATATYPE_ERROR = 10;
    public static final int OLEDB_DATATYPE_WSTR = 130;
    public static final int OLEDB_DATATYPE_STR = 129;
    public static final int OLEDB_DATATYPE_DBDATE = 133;
    public static final int OLEDB_DATATYPE_DBTIME = 134;
    public static final int OLEDB_DATATYPE_DBTIMESTAMP = 135;
    public static final int OLEDB_DATATYPE_NUMERIC = 131;
    public static final int OLEDB_DATATYPE_FILETIME = 64;
    public static final int OLEDB_DATATYPE_HCHAPTER = 136;
    public static final int OLEDB_DATATYPE_VARNUMERIC = 139;
    public static final int OLEDB_DATATYPE_BYTES = 508;
    public static final int OLEDB_DATATYPE_EMPTY = 0;
    public static final int OLEDB_DATATYPE_NULL = 1;
    public static final int OLEDB_DATATYPE_ARRAY = 8192;
    public static final int OLEDB_DATATYPE_BYREF = 16384;
    public static final int OLEDB_DATATYPE_VECTOR = 4096;
    public static final int OLEDB_DATATYPE_RESERVED = 32768;
    public static final int OLEDB_DATATYPE_IDISPATCH = 9;
    public static final int OLEDB_DATATYPE_UDT = 132;
    public static final int OLEDB_DATATYPE_IUNKNOWN = 13;
    public static final int OLEDB_DATATYPE_PROPVARIANT = 138;
    public static final int OLEDB_DATATYPE_XML = 141;
    public static final int MAX_SCALE = 255;
    public static final int DATATYPE_CURRENCY_SCALE = 4;
    public static final int MAX_PRECISION = 65535;

    private MSASCommonDatatypes() {
    }

    public static IDataType convertMSASDatatype(long intValue, int precision, int scale) {
        DoubleType dataType = DataTypeFactory.getDoubleType();
        switch ((int)intValue) {
            case 2: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                if (0 != precision) {
                    dataType = DataTypeFactory.getSmallintType((int)precision, (int)scale);
                    break;
                }
                dataType = DataTypeFactory.getSmallintType((int)scale);
                break;
            }
            case 3: 
            case 10: 
            case 19: {
                if (0 != precision) {
                    dataType = DataTypeFactory.getIntegerType((int)precision, (int)scale);
                    break;
                }
                dataType = DataTypeFactory.getIntegerType((int)scale);
                break;
            }
            case 14: 
            case 131: 
            case 139: {
                if (0 != scale) {
                    dataType = DataTypeFactory.getDecimalType((int)precision, (int)scale);
                    break;
                }
                dataType = DataTypeFactory.getDecimalType((int)precision);
                break;
            }
            case 6: 
            case 20: 
            case 21: 
            case 64: {
                if (0 != precision) {
                    dataType = DataTypeFactory.getLongType((int)precision, (int)scale);
                    break;
                }
                if (0 == scale) {
                    dataType = DataTypeFactory.getLongType();
                    break;
                }
                dataType = DataTypeFactory.getLongType((int)scale);
                break;
            }
            case 4: {
                dataType = DataTypeFactory.getFloatType();
                break;
            }
            case 5: 
            case 12: {
                if (0 == scale) {
                    dataType = DataTypeFactory.getDoubleType();
                    break;
                }
                dataType = DataTypeFactory.getDoubleType();
                break;
            }
            case 7: 
            case 135: {
                dataType = DataTypeFactory.getTimestampType();
                break;
            }
            case 133: {
                dataType = DataTypeFactory.getDateType();
                break;
            }
            case 134: {
                dataType = DataTypeFactory.getTimeType();
                break;
            }
            case 8: 
            case 72: 
            case 129: 
            case 130: 
            case 508: {
                dataType = DataTypeFactory.getStringType();
                break;
            }
            default: {
                dataType = DataTypeFactory.getFloatType();
            }
        }
        return dataType;
    }

    public static DateTimeValue convertTimestampToDateTime(String ts, boolean isNull) {
        TimestampValue result = null;
        result = DataValueFactory.createTimestampValue();
        if (!isNull) {
            if (ts != null) {
                result.set(ts);
                long millis = result.getMilliseconds();
                result.set(millis);
            } else {
                result.setNull();
            }
        } else {
            result.setNull();
        }
        return result;
    }
}

