/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.xml;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.XmlType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.xml.XMLFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;

public class XMLElement
extends XMLFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{1}, {100, 107}, {100, 107}, {1, 107}, DataTypeCode.ALL_TYPES};
    private static final int ELEMENT_CONTENT_IDX = ACCEPTED_TYPES.length - 1;

    public XMLElement() {
        super("XMLElement", ACCEPTED_TYPES, false, ELEMENT_CONTENT_IDX);
    }

    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        int i;
        IValue attributes;
        XmlValue output = (XmlValue)outputArg;
        IValue identifier = pEvaluator.getParameter(context, 0);
        Element element = DocumentHelper.createElement((String)identifier.toString());
        IValue nameSpaces = pEvaluator.getParameter(context, 1);
        if (!nameSpaces.isNull()) {
            for (Node node : ((XmlValue)nameSpaces).getNodeList()) {
                element.add((Namespace)node);
            }
        }
        if (!(attributes = pEvaluator.getParameter(context, 2)).isNull()) {
            List attrList = ((XmlValue)attributes).getNodeList();
            for (i = 0; i < attrList.size(); ++i) {
                Attribute attribute1 = (Attribute)attrList.get(i);
                String prefix = attribute1.getNamespacePrefix();
                Attribute attribute2 = DocumentHelper.createAttribute((Element)element, (String)attribute1.getName(), (String)attribute1.getValue());
                element.add(attribute2);
                if (prefix == null || prefix.equals("")) {
                    Namespace namespace;
                    String attrName = attribute1.getName();
                    int colonPos = attrName.indexOf(":");
                    if (colonPos == -1 || (namespace = element.getNamespaceForPrefix(prefix = attrName.substring(0, colonPos))) == null) continue;
                    attribute2.setNamespace(namespace);
                    continue;
                }
                Namespace namespace = element.getNamespaceForPrefix(prefix);
                attribute2.setNamespace(namespace);
            }
        }
        int nNonNullValues = 0;
        for (i = ELEMENT_CONTENT_IDX; i < pEvaluator.getParameterCount(); ++i) {
            Value v = (Value)pEvaluator.getParameter(context, i);
            if (v.isNull()) continue;
            ++nNonNullValues;
            if (v.getDataType() != XmlType.XMLTYPE) {
                element.add(DocumentHelper.createText((String)v.toString()));
                continue;
            }
            List nodeList = ((XmlValue)v).getNodeList();
            for (int j = 0; j < nodeList.size(); ++j) {
                Node child = (Node)nodeList.get(j);
                if (child.getNodeType() == 9) {
                    child = ((Document)child).getRootElement();
                }
                if (child.getParent() != null || child.getDocument() != null) {
                    child = (Node)child.clone();
                }
                element.add(child);
            }
        }
        IValue contentOption = pEvaluator.getParameter(context, ELEMENT_CONTENT_IDX - 1);
        if (contentOption.isNull() || contentOption.toString().equals("EMPTY ON NULL")) {
            output.set((Node)element);
        } else if (nNonNullValues > 0) {
            output.set((Node)element);
        } else {
            output.setNull();
        }
    }
}

