/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.xml;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.TableFunction;
import com.cognos.xqe.function.xml.XMLErrorHandler;
import com.cognos.xqe.function.xml.xltxej.XQEDynamicContext;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XTableFunction;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.util.CAMUrl;
import com.cognos.xqe.util.io.TempFileUtil;
import com.ibm.icu.text.Collator;
import com.ibm.xml.xapi.XItemView;
import com.ibm.xml.xapi.XSequenceCursor;
import com.ibm.xml.xapi.XViewException;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicCompilationParameters;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.CompilationParameters;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.ErrorHandler;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import java.io.File;
import java.io.FilenameFilter;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.RandomStringUtils;

public class XMLExternalData
extends TableFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{100}};
    private static final String NAMESPACE_PREFIX = "ns";
    private static final String NAMESPACE_URI = "http://developer.cognos.com/schemas/xmldata/1/";
    private static final String XPATH_PREFIX = "XPath_";
    private static final String XQUERY_PREFIX = "XQuery_";
    private static final int RANDOMALPHACOUNT = 6;
    private static final String UNDERSCORE = "_";
    public static final String XQUERY = "for $r in doc(\"%1$s\")/ns:dataset/ns:data/ns:row\nreturn $r";
    public static final String XPATH = "ns:value";

    public XMLExternalData() {
        super("XMLExternalData", ACCEPTED_TYPES, true);
    }

    public IHybridResultSet execute(XDataContext context, IParameterEvaluator pEvaluator, IRowsetInfo rowsetInfo) throws XQERuntimeException {
        return new TabularHybridResultSet(context, (ITabularResultSet)new XMLExternalDataResultSet(context, pEvaluator, rowsetInfo));
    }

    public IDataType getResultDataTypeImpl(IDataType[] ins) {
        return DataTypeFactory.getXmlType();
    }

    private final class XMLExternalDataResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IParameterEvaluator pEvaluator;
        private SessionContext session;
        private ErrorHandler eHandler;
        private StaticContext staticCxt;
        private Executable qExpr;
        private Executable xPathExpr;
        private int nColumns;
        private String xQueryClassName;
        private String xPathClassName;
        private String classesDir;
        private XVectorContext vContext;

        XMLExternalDataResultSet(XDataContext context, IParameterEvaluator parameterEvaluator, IRowsetInfo theRowsetInfo) {
            super(context, context.getNodeId());
            this.classesDir = System.getProperty("xqe.xml.classesDir", System.getProperty("user.dir"));
            this.pEvaluator = parameterEvaluator;
            this.rowsetInfo = theRowsetInfo;
            this.nColumns = this.rowsetInfo.getNumColumns();
            this.session = new SessionContext(((Object)((Object)this)).getClass().getClassLoader());
            this.eHandler = new XMLErrorHandler();
            this.staticCxt = new BasicStaticContext(this.session.getTypeRegistry());
            this.staticCxt.setBaseURI(this.classesDir);
            this.staticCxt.setErrorHandler(this.eHandler);
            this.staticCxt.declareNamespace(XMLExternalData.NAMESPACE_PREFIX, XMLExternalData.NAMESPACE_URI);
            this.vContext = ((XTableFunction)this.pEvaluator).getVectorizationContext();
            try {
                this.staticCxt.setLanguageTypeAndVersion(3);
                Preparer preparer = this.session.getPreparer(RequestInfo.XPath2);
                this.xPathClassName = XMLExternalData.XPATH_PREFIX + System.currentTimeMillis() + XMLExternalData.UNDERSCORE + RandomStringUtils.randomAlphanumeric((int)6);
                BasicCompilationParameters cp = new BasicCompilationParameters(this.xPathClassName);
                cp.setDirectoryName(this.classesDir);
                preparer.compile(XMLExternalData.XPATH, this.staticCxt, (CompilationParameters)cp, -1);
                this.xPathExpr = preparer.load((CompilationParameters)cp);
                String uriStr = this.pEvaluator.getParameter(context, 0).toString();
                String xQuery = String.format(XMLExternalData.XQUERY, uriStr);
                xQuery = xQuery.replaceAll("&", "&amp;");
                this.staticCxt.setLanguageTypeAndVersion(1);
                preparer = this.session.getPreparer(RequestInfo.XQuery);
                this.xQueryClassName = XMLExternalData.XQUERY_PREFIX + System.currentTimeMillis() + XMLExternalData.UNDERSCORE + RandomStringUtils.randomAlphanumeric((int)6);
                cp = new BasicCompilationParameters(this.xQueryClassName);
                cp.setDirectoryName(this.classesDir);
                preparer.compile(xQuery, this.staticCxt, (CompilationParameters)cp, -1);
                this.qExpr = preparer.load((CompilationParameters)cp);
            }
            catch (ClassNotFoundException e) {
                throw new XQERuntimeException((Throwable)e);
            }
        }

        public ITabularIterator getTabularIterator() {
            return new XMLExternalDataIterator(this.getDataContext());
        }

        public void releaseImpl() {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(XMLExternalDataResultSet.this.xPathClassName) || name.startsWith(XMLExternalDataResultSet.this.xQueryClassName);
                }
            };
            String[] fileList = new File(this.classesDir).list(filter);
            if (fileList == null) {
                return;
            }
            if (this.classesDir.contains("\\")) {
                if (!this.classesDir.endsWith("\\")) {
                    this.classesDir = this.classesDir + "\\";
                }
            } else if (this.classesDir.contains("/") && !this.classesDir.endsWith("/")) {
                this.classesDir = this.classesDir + "/";
            }
            for (String fileName : fileList) {
                TempFileUtil.deleteTempFile((File)new File(this.classesDir + fileName));
            }
        }

        private final class XMLExternalDataIterator
        extends XTabularIterator {
            private RowValue row;
            private XVectorRowBatch batch;
            private Cursor result;
            private boolean eod;
            private DynamicContext dynamicCxt;

            private XMLExternalDataIterator(XDataContext context) {
                super(context, context.getNodeId());
                this.dynamicCxt = new XQEDynamicContext(XMLExternalDataResultSet.this.session, XMLExternalDataResultSet.this.staticCxt, context);
                this.dynamicCxt.setErrorHandler(XMLExternalDataResultSet.this.eHandler);
                this.dynamicCxt.setSourceURIResolver((URIResolver)new XQEUriResolver());
                try {
                    this.result = XMLExternalDataResultSet.this.qExpr.execute(null, this.dynamicCxt, Cursor.RANDOM_ACCESS, null);
                    this.row = DataValueFactory.createRowValue((Collator)context.getLocalCollator(), (IRowsetInfo)XMLExternalDataResultSet.this.rowsetInfo);
                    if (XMLExternalDataResultSet.this.vContext != null) {
                        this.batch = XVectorRowBatchUtil.createRowBatch((XVectorContext)XMLExternalDataResultSet.this.vContext, (IRowsetInfo)XMLExternalDataResultSet.this.rowsetInfo, (Collator)context.getLocalCollator());
                    }
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
            }

            public Object nextImpl() {
                if (this.result == null || this.eod) {
                    return null;
                }
                ++this.nRows;
                Cursor xPathCursor = this.result.fork(true);
                if (xPathCursor == null) {
                    this.eod = true;
                    return null;
                }
                xPathCursor.toSelf();
                Cursor cursor = XMLExternalDataResultSet.this.xPathExpr.execute(xPathCursor, this.dynamicCxt, Cursor.RANDOM_ACCESS, null);
                XSequenceCursor xSeqCursor = cursor.getSequenceCursor();
                for (int i = 0; i < XMLExternalDataResultSet.this.nColumns; ++i) {
                    Value value = (Value)this.row.getColumn(i);
                    XItemView iView = xSeqCursor.getSingletonItem();
                    IDataType dataType = XMLExternalDataResultSet.this.rowsetInfo.getColumnInfo(i).getDataType();
                    try {
                        if (dataType.getCCLTypeCode() == 6 || dataType.getCCLTypeCode() == 8) {
                            value.set(iView.getDoubleValue());
                        } else {
                            String sValue = iView.getStringValue();
                            if (sValue.isEmpty()) {
                                value.setNull();
                            } else {
                                value.set(sValue);
                            }
                        }
                    }
                    catch (XViewException e) {
                        value.setNull();
                    }
                    xSeqCursor.toNext();
                }
                cursor.release();
                xPathCursor.release();
                this.eod = !this.result.toNext();
                return this.row;
            }

            public Object nextBatch() {
                this.batch.reset();
                if (this.result == null || this.eod) {
                    this.batch.eod = true;
                    return this.batch;
                }
                while (this.batch.size != this.batch.maxBatchSize && !this.eod) {
                    ++this.nRows;
                    Cursor xPathCursor = this.result.fork(true);
                    if (xPathCursor == null) {
                        this.eod = true;
                        return null;
                    }
                    xPathCursor.toSelf();
                    Cursor cursor = XMLExternalDataResultSet.this.xPathExpr.execute(xPathCursor, this.dynamicCxt, Cursor.RANDOM_ACCESS, null);
                    XSequenceCursor xSeqCursor = cursor.getSequenceCursor();
                    for (int i = 0; i < XMLExternalDataResultSet.this.nColumns; ++i) {
                        ColumnVector vector = this.batch.columns[i];
                        XItemView iView = xSeqCursor.getSingletonItem();
                        IDataType dataType = XMLExternalDataResultSet.this.rowsetInfo.getColumnInfo(i).getDataType();
                        try {
                            if (dataType.isInteger()) {
                                vector.assign(this.batch.size, (Object)iView.getDoubleValue());
                            } else {
                                String sValue = iView.getStringValue();
                                if (sValue.isEmpty()) {
                                    vector.noNulls = false;
                                    vector.isNull[this.batch.size] = true;
                                } else {
                                    vector.assign(this.batch.size, (Object)sValue);
                                }
                            }
                        }
                        catch (XViewException e) {
                            vector.noNulls = false;
                            vector.isNull[this.batch.size] = true;
                        }
                        xSeqCursor.toNext();
                    }
                    ++this.batch.size;
                    xPathCursor.release();
                    this.eod = !this.result.toNext();
                }
                return this.batch;
            }

            public long getIndex() {
                return this.nRows;
            }

            public void release() {
                if (this.result != null) {
                    try {
                        this.result.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log((Throwable)e);
                    }
                    finally {
                        this.result = null;
                    }
                }
            }
        }

        private final class XQEUriResolver
        implements URIResolver {
            private XQEUriResolver() {
            }

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                StreamSource streamSource = null;
                if (href.startsWith("https:")) {
                    streamSource = new StreamSource(CAMUrl.createInputStream((String)href));
                }
                return streamSource;
            }
        }
    }
}

