/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.xml;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.xml.XMLFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.xml.XMLUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class XMLParse
extends XMLFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{1}, DataTypeCode.ALL_CHARACTER_TYPES, {1}};

    public XMLParse() {
        super("XMLParse", ACCEPTED_TYPES, false);
    }

    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        Matcher m;
        TextValue docOrContent = (TextValue)pEvaluator.getParameter(context, 0);
        TextValue text = (TextValue)pEvaluator.getParameter(context, 1);
        TextValue whitespaceOption = (TextValue)pEvaluator.getParameter(context, 2);
        XmlValue output = (XmlValue)outputArg;
        if (text.isNull()) {
            output.setNull();
            return;
        }
        boolean content = docOrContent.toString().equalsIgnoreCase("CONTENT");
        boolean stripWhitespace = whitespaceOption.toString().equalsIgnoreCase("STRIP WHITESPACE");
        String s = text.toString();
        StringBuilder sBuffer = new StringBuilder(s.length());
        if (content) {
            sBuffer.append("<wrapper>");
        }
        if ((m = XMLUtils.XMLDECL_PATTERN.matcher(s)).find()) {
            sBuffer.append(m.group(1));
        } else {
            sBuffer.append(s);
        }
        if (content) {
            sBuffer.append("</wrapper>");
        }
        try {
            SAXReader reader = new SAXReader(false);
            reader.setMergeAdjacentText(stripWhitespace);
            reader.setStripWhitespaceText(stripWhitespace);
            Document document = reader.read((Reader)new StringReader(sBuffer.toString()));
            if (!content) {
                output.set((Node)document);
            } else {
                ArrayList<Node> nodeList = new ArrayList<Node>();
                Iterator it = document.getRootElement().nodeIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    nodeList.add(n);
                }
                for (Node node : nodeList) {
                    node.detach();
                }
                output.set(nodeList);
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap((Throwable)e);
        }
    }
}

