/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.xml;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.function.xml.XMLErrorHandler;
import com.cognos.xqe.function.xml.xltxej.XQEDynamicContext;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.ErrorHandler;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XMLTransform
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{100}, {100}};

    public XMLTransform() {
        super("XMLTransform", ACCEPTED_TYPES, false);
    }

    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        XmlValue input = (XmlValue)pEvaluator.getParameter(context, 0);
        XmlValue styleSheet = (XmlValue)pEvaluator.getParameter(context, 1);
        XmlValue output = (XmlValue)outputArg;
        if (input.isNull()) {
            output.setNull();
            return;
        }
        SessionContext session = new SessionContext((ClassLoader)null);
        XMLErrorHandler eHandler = new XMLErrorHandler();
        BasicStaticContext staticCxt = new BasicStaticContext(session.getTypeRegistry());
        staticCxt.setLanguageTypeAndVersion(5);
        staticCxt.setBaseURI(System.getProperty("user.dir"));
        staticCxt.setErrorHandler((ErrorHandler)eHandler);
        XQEDynamicContext dynamicCxt = new XQEDynamicContext(session, (StaticContext)staticCxt, context);
        dynamicCxt.setErrorHandler(eHandler);
        Preparer preparer = session.getPreparer(RequestInfo.XSLT2);
        StreamSource source = new StreamSource(new StringReader(styleSheet.getString()));
        Executable xsltExec = preparer.prepare((Source)source, (StaticContext)staticCxt, -1);
        RequestInfo request = new RequestInfo(Cursor.RANDOM_ACCESS, (StaticContext)staticCxt);
        StreamSource document = new StreamSource(new StringReader(input.getString()));
        Cursor contextDoc = session.document((Source)document, request);
        Cursor result = xsltExec.execute(contextDoc, (DynamicContext)dynamicCxt, Cursor.RANDOM_ACCESS, null);
        if (null != result) {
            VolatileCData cData = result.serialize(null);
            output.set(cData.toString());
        }
    }

    public IDataType getResultDataTypeImpl(IDataType[] ins) {
        return DataTypeFactory.getXmlType();
    }
}

