/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts;

import com.cognos.xts.XTSException;
import com.cognos.xts.interpreter.instructions.XTSFaultException;
import com.cognos.xts.interpreter.instructions.request.XTSBusException;
import com.cognos.xts.interpreter.instructions.request.XTSSoapFaultException;
import com.cognos.xts.properties.PropertiesManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public final class UXTSExceptionUtils {
    private static final int BUFFER_SIZE = 4096;
    private static final String XTS_ERROR = "error";
    private static final String XTS_FAULTCODE = "faultcode";
    private static final String XTS_FAULTSTRING = "faultstring";
    private static final String XTS_DETAIL = "detail";

    public static Element getFaultXMLForThrowable(Throwable e, Locale locale, boolean stackdump) {
        Element exceptionElement = DocumentHelper.createElement((QName)XTSException.EXCEPTION_QNAME);
        Element excpetionCodeElement = DocumentHelper.createElement((QName)XTSException.EXCEPTIONCODE_QNAME);
        excpetionCodeElement.addText(e.getClass().getName());
        exceptionElement.add(excpetionCodeElement);
        Element excpetionMsgElement = DocumentHelper.createElement((QName)XTSException.EXCEPTIONMSG_QNAME);
        StringBuffer msg = new StringBuffer();
        msg.append(e.getClass().getName());
        if (e.getMessage() != null) {
            msg.append(" : ");
            msg.append(e.getMessage());
        }
        excpetionMsgElement.addText(msg.toString());
        exceptionElement.add(excpetionMsgElement);
        if (stackdump) {
            Element exceptionSTElement = DocumentHelper.createElement((QName)XTSException.EXCEPTIONST_QNAME);
            StringWriter sw = new StringWriter(4096);
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            exceptionSTElement.addText(sw.toString());
            exceptionElement.add(exceptionSTElement);
        }
        return exceptionElement;
    }

    public static Element generateFaultXML(XTSException e, Locale locale, boolean stackdump) {
        Element fault = DocumentHelper.createElement((String)"fault");
        for (Throwable curEx = e; curEx != null; curEx = curEx.getDetail()) {
            if (curEx instanceof XTSException) {
                fault.add(curEx.getFaultXML(locale, stackdump));
                continue;
            }
            fault.add(UXTSExceptionUtils.getFaultXMLForThrowable(curEx, locale, stackdump));
            break;
        }
        return fault;
    }

    public static Element generateErrorXML(XTSException e, Locale locale) {
        boolean debug = false;
        String sDebugEnable = PropertiesManager.getInstance().getProperty("option.fullexceptionlist");
        if (sDebugEnable != null && sDebugEnable.equals("true")) {
            debug = true;
        }
        XTSException curEx = e;
        if (!debug) {
            Throwable nextEx = e.getDetail();
            while (nextEx != null && nextEx instanceof XTSException) {
                curEx = (XTSException)nextEx;
                nextEx = ((XTSException)nextEx).getDetail();
            }
        }
        Element errorElement = DocumentHelper.createElement((String)XTS_ERROR);
        Element faultcodeElement = DocumentHelper.createElement((String)XTS_FAULTCODE);
        String key = curEx.getKey();
        if (key != null) {
            faultcodeElement.addText(key);
        }
        errorElement.add(faultcodeElement);
        Element faultstringElement = DocumentHelper.createElement((String)XTS_FAULTSTRING);
        String msg = curEx.getLocalizedMsgString(locale);
        if (msg != null) {
            faultstringElement.addText(msg);
        }
        errorElement.add(faultstringElement);
        Element detailElement = DocumentHelper.createElement((String)XTS_DETAIL);
        errorElement.add(detailElement);
        detailElement.add(curEx.getFaultXML(locale, false));
        Throwable detailEx = curEx.getDetail();
        if (detailEx != null) {
            while (detailEx != null) {
                if (detailEx instanceof XTSException) {
                    detailElement.add(((XTSException)detailEx).getFaultXML(locale, false));
                    detailEx = ((XTSException)detailEx).getDetail();
                    continue;
                }
                detailElement.add(UXTSExceptionUtils.getFaultXMLForThrowable(detailEx, locale, false));
                detailEx = null;
                break;
            }
        }
        return errorElement;
    }

    public static Element convertXTSExceptionToSoapEnvelope(XTSException e, int soapVersion, Locale locale) {
        boolean debug = false;
        String sDebugEnable = PropertiesManager.getInstance().getProperty("option.fullexceptionlist");
        if (sDebugEnable != null && sDebugEnable.equals("true")) {
            debug = true;
        }
        XTSException curEx = e;
        if (!debug) {
            Throwable nextEx = e.getDetail();
            while (nextEx != null && nextEx instanceof XTSException) {
                curEx = (XTSException)nextEx;
                nextEx = ((XTSException)nextEx).getDetail();
            }
        }
        if (curEx instanceof XTSBusException) {
            return ((XTSBusException)curEx).getSoapEnvElementCopy(locale, soapVersion);
        }
        if (curEx instanceof XTSSoapFaultException) {
            return ((XTSSoapFaultException)curEx).getSoapEnvElementCopy(locale, soapVersion);
        }
        if (curEx instanceof XTSFaultException) {
            return ((XTSFaultException)curEx).getSoapEnvElementCopy(locale, soapVersion);
        }
        return curEx.getSoapEnvElementCopy(locale, soapVersion);
    }
}

