/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSObject;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.blockprocessor.IXTSBlockProcessor;
import com.cognos.xts.blockprocessor.XTSBlockProcessorException;
import com.cognos.xts.blockprocessor.XTSBlockProcessorGenerator;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.compiler.logicsheet.XTSLogicsheetTransfomer;
import com.cognos.xts.compiler.message.XTSMessageTransformer;
import com.cognos.xts.logging.IXTSDebugLog;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSDebugManager;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.output.XTSOutputContext;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.util.StopWatchTimer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.InvalidXPathException;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class XTSBlock
implements URIResolver {
    public static final String BLOCK = "block";
    public static final QName XTS_BLOCK_QNAME = new QName("block", XTSProcessor.XTS_NAMESPACE);
    public static final QName XTS_BLOCK_LOGICSHEET = new QName("logicsheet", XTSProcessor.XTS_NAMESPACE);
    public static final String BLOCK_LOGICSHEET_PATH = "path";
    public static final String BLOCK_ID = "id";
    public static final String BLOCK_TYPE = "type";
    public static final String BLOCK_MODE = "mode";
    public static final String BLOCK_CONDITION = "condition";
    public static final String BLOCK_MANDATORY = "mandatory";
    public static final String BLOCK_DEPENDENCY = "dependency";
    public static final String BLOCK_FAULTBLOCK = "faultBlock";
    public static final String BLOCK_PROCESSOR = "processor";
    public static final String BLOCK_DEBUG = "debug";
    public static final String BLOCK_PATH = "path";
    public static final String BLOCK_RESOLVERBASE = "resolverBase";
    public static final String BLOCK_NODELIST = "nodelist";
    public static final int TYPE_EXEC = 0;
    public static final int TYPE_TEST = 1;
    public static final int TYPE_FAULT = 2;
    public static final int MODE_INPUT = 0;
    public static final int MODE_OUTPUT = 1;
    public static final int MODE_INTERPRET = 2;
    public static final int BLOCK_DEBUG_ENABLED = 1;
    public static final int BLOCK_DEBUG_DISABLED = 2;
    public static final String BLOCK_PROCESSOR_VALUE_XML = "XML";
    public static final String BLOCK_TYPE_VALUE_EXEC = "exec";
    public static final String BLOCK_TYPE_VALUE_TEST = "test";
    public static final String BLOCK_TYPE_VALUE_FAULT = "fault";
    public static final String BLOCK_MODE_VALUE_INPUT = "input";
    public static final String BLOCK_MODE_VALUE_OUTPUT = "output";
    public static final String BLOCK_MODE_VALUE_INTERPRET = "interpret";
    public static final String BLOCK_DEBUG_TRUE = "true";
    public static final String BLOCK_DEBUG_FALSE = "false";
    private static final int BUFFER_SIZE = 4096;
    public static final String FILE_SCHEME_URI_IDENTIFIER = "file:/";
    private static final String VERIFY_PROPERTY = "xpath.verify";
    private static final String VERIFY_FORMAT_PROPERTY = "xpath.verifyformat";
    private String m_sId;
    private int m_nType;
    private int m_nMode;
    private XPath m_oCondition;
    private boolean m_bMandatory;
    private String m_sDependency;
    private String m_sFaultBlock;
    private IXTSBlockProcessor m_oProcessor;
    private int m_iDebugEnabled;
    private HashMap m_nodelist;
    private String m_sResolverBase;
    private XTSObject m_oParentObj;
    private XTSOutputContext m_oOutputContextObj;
    private Locale m_creationLocale;
    private boolean m_bCompiled;
    private boolean m_bPreProcessed;
    private Element m_oBlkEle;
    private String[] m_sMsgFileList;
    private String m_sProcessorIdentifier;
    private static final String XTS_STRING_EXISTANCE_CHECK = ".//*[local-name()='string' and namespace-uri()='http://developer.cognos.com/schemas/xts/'][1]";

    public String getId() {
        return this.m_sId;
    }

    public int getType() {
        return this.m_nType;
    }

    public int getMode() {
        return this.m_nMode;
    }

    public boolean isMandatory() {
        return this.m_bMandatory;
    }

    public String getDependency() {
        return this.m_sDependency;
    }

    public String getFaultBlock() {
        return this.m_sFaultBlock;
    }

    public String getProcessorIdentifier() {
        return this.m_sProcessorIdentifier;
    }

    public IXTSBlockProcessor getProcessor() {
        return this.m_oProcessor;
    }

    public HashMap getNodeList() {
        return this.m_nodelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XTSBlock(XTSEnvironment env, XTSObject parent, Element block, String[] msgFileList) throws XTSException {
        Object[] args;
        String list;
        String sDebugAttribute;
        boolean modeSet;
        block42: {
            String sMandatory;
            String condition;
            this.m_sId = null;
            this.m_nType = 0;
            this.m_nMode = 2;
            this.m_oCondition = null;
            this.m_bMandatory = true;
            this.m_sDependency = null;
            this.m_sFaultBlock = null;
            this.m_oProcessor = null;
            this.m_iDebugEnabled = 2;
            this.m_nodelist = null;
            this.m_sResolverBase = null;
            this.m_oParentObj = null;
            this.m_oOutputContextObj = null;
            this.m_creationLocale = null;
            this.m_bCompiled = false;
            this.m_bPreProcessed = false;
            this.m_oBlkEle = null;
            this.m_sMsgFileList = null;
            this.m_sProcessorIdentifier = null;
            this.m_creationLocale = env.getLocale();
            this.m_oParentObj = parent;
            this.m_oBlkEle = block;
            this.m_sMsgFileList = msgFileList;
            this.m_sId = block.attributeValue(BLOCK_ID);
            if (this.m_sId == null || this.m_sId.length() == 0) {
                throw new XTSException("block.emptyid");
            }
            this.m_nType = 0;
            String sType = block.attributeValue(BLOCK_TYPE);
            if (sType == null || sType.length() == 0) {
                Object[] args2 = new String[]{this.m_sId};
                throw new XTSException("block.emptytype", args2);
            }
            if (sType.equals(BLOCK_TYPE_VALUE_EXEC)) {
                this.m_nType = 0;
            } else if (sType.equals(BLOCK_TYPE_VALUE_TEST)) {
                this.m_nType = 1;
            } else {
                if (!sType.equals(BLOCK_TYPE_VALUE_FAULT)) {
                    Object[] args3 = new String[]{sType, this.m_sId};
                    throw new XTSException("block.invalidtype", args3);
                }
                this.m_nType = 2;
            }
            modeSet = false;
            this.m_nMode = 2;
            String sMode = block.attributeValue(BLOCK_MODE);
            if (sMode != null) {
                modeSet = true;
                if (sMode.equals(BLOCK_MODE_VALUE_INPUT)) {
                    this.m_nMode = 0;
                } else if (sMode.equals(BLOCK_MODE_VALUE_OUTPUT)) {
                    this.m_nMode = 1;
                } else {
                    if (!sMode.equals(BLOCK_MODE_VALUE_INTERPRET)) {
                        Object[] args4 = new String[]{sMode, this.m_sId};
                        throw new XTSException("block.invalidmode", args4);
                    }
                    this.m_nMode = 2;
                }
            }
            if ((condition = block.attributeValue(BLOCK_CONDITION)) != null && condition.length() > 0) {
                try {
                    this.m_oCondition = DocumentHelper.createXPath((String)condition);
                }
                catch (InvalidXPathException e) {
                    Object[] args5 = new String[]{condition, this.m_sId};
                    throw new XTSException("block.invalidcondition", args5, e);
                }
            }
            if ((sMandatory = block.attributeValue(BLOCK_MANDATORY)) != null) {
                if (sMandatory.equals(Boolean.TRUE.toString())) {
                    this.m_bMandatory = true;
                } else {
                    if (!sMandatory.equals(Boolean.FALSE.toString())) {
                        Object[] args6 = new String[]{sMode, this.m_sId};
                        throw new XTSException("block.invalidmandatory", args6);
                    }
                    this.m_bMandatory = false;
                }
            } else {
                this.m_bMandatory = true;
            }
            this.m_sResolverBase = block.attributeValue(BLOCK_RESOLVERBASE);
            if (this.m_sResolverBase != null && this.m_sResolverBase.startsWith("/")) {
                this.m_sResolverBase = this.m_sResolverBase.substring("/".length());
            }
            if (this.m_sResolverBase == null) {
                this.m_sResolverBase = parent.getResolverBase();
            }
            if (this.m_sResolverBase == null) {
                this.m_sResolverBase = ".";
            }
            this.m_sProcessorIdentifier = block.attributeValue(BLOCK_PROCESSOR);
            if (this.m_sProcessorIdentifier == null) {
                this.m_sProcessorIdentifier = BLOCK_PROCESSOR_VALUE_XML;
            }
            this.m_sDependency = block.attributeValue(BLOCK_DEPENDENCY);
            this.m_sFaultBlock = block.attributeValue(BLOCK_FAULTBLOCK);
            String source = block.attributeValue("path");
            if (source != null && source.length() > 0) {
                try {
                    InputStream is = XTSResourceManager.getInstance().getResource(source);
                    if (is == null) break block42;
                    AXTSPoolObject reader = XTSSAXReaderPool.getInstance().acquire();
                    try {
                        Document doc = ((SAXReader)reader.get()).read(new InputSource(is));
                        this.m_oBlkEle.add(doc.getRootElement().createCopy());
                    }
                    finally {
                        XTSSAXReaderPool.getInstance().put(reader);
                    }
                }
                catch (XTSException e) {
                    Object[] args7 = new String[]{source, this.m_sId};
                    throw new XTSException("block.sourceeleexception", args7, e);
                }
                catch (DocumentException e) {
                    Object[] args8 = new String[]{source, this.m_sId};
                    throw new XTSException("block.sourceeleexception", args8, e);
                }
            }
        }
        if (this.m_nMode == 1) {
            this.m_oOutputContextObj = new XTSOutputContext(this.m_oBlkEle, 2);
        }
        if ((sDebugAttribute = this.m_oBlkEle.attributeValue(BLOCK_DEBUG)) != null) {
            if (sDebugAttribute.equals(BLOCK_DEBUG_TRUE)) {
                this.m_iDebugEnabled = 1;
            } else {
                if (!sDebugAttribute.equals(BLOCK_DEBUG_FALSE)) {
                    Object[] args9 = new String[]{BLOCK_DEBUG, sDebugAttribute, this.m_oBlkEle.getQualifiedName()};
                    throw new XTSException("block.invalidinstructionattributevalue", args9);
                }
                this.m_iDebugEnabled = 2;
            }
        }
        if ((list = block.attributeValue(BLOCK_NODELIST)) != null && list.length() > 0) {
            this.m_nodelist = new HashMap();
            StringTokenizer st = new StringTokenizer(list, ",");
            while (st.hasMoreTokens()) {
                this.m_nodelist.put(st.nextToken().trim(), null);
            }
        }
        if ((this.m_nType == 1 || this.m_nType == 2) && modeSet) {
            args = new String[]{this.m_sId};
            throw new XTSException("block.testfaultmodespecified", args);
        }
        if (this.m_sFaultBlock != null && this.m_nType != 2) {
            args = new String[]{this.m_sId};
            throw new XTSException("block.invalidfaultBlockspecified", args);
        }
    }

    protected XTSBlock() {
        this.m_sId = null;
        this.m_nType = 0;
        this.m_nMode = 2;
        this.m_oCondition = null;
        this.m_bMandatory = true;
        this.m_sDependency = null;
        this.m_sFaultBlock = null;
        this.m_oProcessor = null;
        this.m_iDebugEnabled = 2;
        this.m_nodelist = null;
        this.m_sResolverBase = null;
        this.m_oParentObj = null;
        this.m_oOutputContextObj = null;
        this.m_creationLocale = null;
        this.m_bCompiled = false;
        this.m_bPreProcessed = false;
        this.m_oBlkEle = null;
        this.m_sMsgFileList = null;
        this.m_sProcessorIdentifier = null;
    }

    public synchronized void compile(XTSEnvironment env, String baseDebugDumpDir, StopWatchTimer timer) throws XTSException {
        if (this.m_bCompiled) {
            return;
        }
        IXTSLogger pLogger = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
            pLogger.log(env, 6, this.getClass().getName(), "compile", "Start applying logicsheets for : " + env.getMorphletName() + "(" + this.m_sId + ")");
            pLogger.starttimer();
        }
        try {
            if ((env.getMode() & 2) > 0) {
                timer.start();
            }
            StopWatchTimer childTimer = null;
            if ((env.getMode() & 2) > 0) {
                childTimer = timer.createChild();
            }
            this.m_oBlkEle = this.applyLogicSheets(env, this.m_oBlkEle, baseDebugDumpDir, childTimer);
            if ((env.getMode() & 2) > 0) {
                timer.stop();
                timer.getParent().pause();
                IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                if (debuglogger != null) {
                    debuglogger.log(env, baseDebugDumpDir, "timing.xml", timer.toXMLString());
                }
                timer.getParent().unpause();
            }
            this.m_bCompiled = true;
        }
        catch (XTSException e) {
            Object[] args = new String[]{this.m_sId};
            throw new XTSException("block.compilefailed", args, e);
        }
        if (pLogger != null) {
            pLogger.stoptimer();
            pLogger.log(env, 1, this.getClass().getName(), "compile", "Start applying logicsheets for : " + env.getMorphletName() + "(" + this.m_sId + ")");
        }
    }

    public synchronized void preprocess(XTSEnvironment env, String baseDebugDumpDir, StopWatchTimer timer) throws XTSException {
        if (this.m_bPreProcessed) {
            return;
        }
        try {
            if ((env.getMode() & 2) > 0) {
                timer.start();
            }
            StopWatchTimer childTimer = null;
            if ((env.getMode() & 2) > 0) {
                childTimer = timer.createChild();
            }
            IXTSLogger pLogger1 = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger1 = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                pLogger1.log(env, 6, this.getClass().getName(), "compile", "Start applying message transform for : " + env.getMorphletName() + "(" + this.m_sId + ")");
                pLogger1.starttimer();
            }
            this.m_oBlkEle = this.applyMessageTransform(env, this.m_oBlkEle, this.m_sMsgFileList, baseDebugDumpDir, childTimer);
            if (pLogger1 != null) {
                pLogger1.stoptimer();
                pLogger1.log(env, 1, this.getClass().getName(), "compile", "Start applying message transform for : " + env.getMorphletName() + "(" + this.m_sId + ")");
            }
            if ((env.getMode() & 2) > 0) {
                childTimer = timer.createChild();
            }
            IXTSLogger pLogger2 = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger2 = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                pLogger2.log(env, 6, this.getClass().getName(), "compile", "Start compiling block source for : " + env.getMorphletName() + "(" + this.m_sId + ")");
                pLogger2.starttimer();
            }
            this.compileBlockProcessor(env, this.m_oBlkEle, baseDebugDumpDir, childTimer);
            if (pLogger2 != null) {
                pLogger2.stoptimer();
                pLogger2.log(env, 1, this.getClass().getName(), "compile", "Start compiling block source for : " + env.getMorphletName() + "(" + this.m_sId + ")");
            }
            if ((env.getMode() & 2) > 0) {
                timer.stop();
                timer.getParent().pause();
                IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                if (debuglogger != null) {
                    debuglogger.log(env, baseDebugDumpDir, "timing.xml", timer.toXMLString());
                }
                timer.getParent().unpause();
            }
            this.m_oBlkEle = null;
            this.m_sMsgFileList = null;
            this.m_bPreProcessed = true;
        }
        catch (XTSException e) {
            Object[] args = new String[]{this.m_sId};
            throw new XTSException("block.compilefailed", args, e);
        }
    }

    private Element applyLogicSheets(XTSEnvironment env, Element blk, String baseDebugDumpDir, StopWatchTimer timer) throws XTSException {
        int bytesRead;
        char[] cbuf;
        StringBuffer buffer;
        List lsElemList = blk.elements(XTS_BLOCK_LOGICSHEET);
        if (lsElemList.isEmpty()) {
            return blk;
        }
        IXTSLogger traceLogger3 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger3.log(env, 4, "applyLogicSheets " + this.m_sId, null, null);
        }
        IXTSLogger traceLogger5 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger5.log(env, 8, "Input:", null, null);
            traceLogger5.log(env, 8, blk.asXML(), null, null);
        }
        if ((env.getMode() & 2) > 0) {
            timer.start();
        }
        String logicsheetBaseDebugDumpDir = null;
        if ((env.getMode() & 2) > 0) {
            StringBuffer tmp = new StringBuffer();
            tmp.append(baseDebugDumpDir);
            tmp.append(File.separatorChar);
            tmp.append(XTSDebugManager.getInstance().generateDirName(0, "logicsheets", null));
            logicsheetBaseDebugDumpDir = tmp.toString();
        }
        if ((env.getMode() & 2) > 0) {
            timer.pause();
            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debuglogger.log(env, logicsheetBaseDebugDumpDir, "input.xml", logicsheetBaseDebugDumpDir);
            }
            timer.unpause();
        }
        ArrayList<String> lsList = new ArrayList<String>();
        Element lsElem = null;
        String lsPath = null;
        for (int k = 0; k < lsElemList.size(); ++k) {
            lsElem = (Element)lsElemList.get(k);
            lsElem.detach();
            lsPath = lsElem.attributeValue("path");
            if (lsPath == null) continue;
            lsList.add(lsPath);
        }
        DocumentSource docsrc = new DocumentSource(DocumentHelper.createDocument((Element)blk));
        Source result = XTSLogicsheetTransfomer.applyLogicsheets(env, (Source)docsrc, lsList, (URIResolver)this);
        Reader resultReader = null;
        if (!(result instanceof StreamSource)) {
            Object[] args = new Object[]{this.m_sId};
            throw new XTSException("block.failedtoparselsresult", args);
        }
        resultReader = ((StreamSource)result).getReader();
        if (resultReader == null) {
            Object[] args = new Object[]{this.m_sId};
            throw new XTSException("block.failedtoparselsresult", args);
        }
        if ((env.getMode() & 2) > 0) {
            timer.pause();
            buffer = new StringBuffer(4096);
            try {
                cbuf = new char[4096];
                bytesRead = resultReader.read(cbuf, 0, 4096);
                while (bytesRead != -1) {
                    buffer.append(cbuf, 0, bytesRead);
                    bytesRead = resultReader.read(cbuf, 0, 4096);
                }
                resultReader = new StringReader(buffer.toString());
                IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                if (debuglogger != null) {
                    debuglogger.log(env, logicsheetBaseDebugDumpDir, "output.xml", buffer.toString());
                }
            }
            catch (IOException e) {
                Object[] args = new Object[]{this.m_sId};
                throw new XTSException("block.failedtoparselsresult", args);
            }
            timer.unpause();
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
            try {
                buffer = new StringBuffer(4096);
                cbuf = new char[4096];
                bytesRead = resultReader.read(cbuf, 0, 4096);
                while (bytesRead != -1) {
                    buffer.append(cbuf, 0, bytesRead);
                    bytesRead = resultReader.read(cbuf, 0, 4096);
                }
                resultReader = new StringReader(buffer.toString());
                traceLogger5.log(env, 8, "Output:", null, null);
                traceLogger5.log(env, 8, buffer.toString(), null, null);
            }
            catch (Exception e) {
                Object[] args = new Object[]{this.m_sId};
                throw new XTSException("block.failedtoparselsresult", args);
            }
        }
        AXTSPoolObject domReader = null;
        try {
            domReader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            Object[] args = new Object[]{this.m_sId};
            throw new XTSException("block.failedtoparselsresult", args, e);
        }
        Element ret = null;
        try {
            ret = ((SAXReader)domReader.get()).read(new InputSource(resultReader)).getRootElement();
            ret.detach();
        }
        catch (Exception e) {
            Object[] args = new Object[]{this.m_sId};
            throw new XTSException("block.failedtoparselsresult", args, e);
        }
        finally {
            XTSSAXReaderPool.getInstance().put(domReader);
        }
        if ((env.getMode() & 2) > 0) {
            timer.stop();
            timer.getParent().pause();
            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debuglogger.log(env, logicsheetBaseDebugDumpDir, "timing.xml", timer.toXMLString());
            }
            timer.getParent().unpause();
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
            traceLogger3.log(env, 5, "applyLogicSheets " + this.m_sId, null, null);
        }
        return ret;
    }

    private Element applyMessageTransform(XTSEnvironment env, Element blk, String[] msgFileList, String baseDebugDumpDir, StopWatchTimer timer) throws XTSException {
        int bytesRead;
        char[] cbuf;
        StringBuffer buffer;
        if (msgFileList == null) {
            return blk;
        }
        Node stringNode = blk.selectSingleNode(XTS_STRING_EXISTANCE_CHECK);
        if (stringNode == null) {
            return blk;
        }
        IXTSLogger traceLogger3 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger3.log(env, 4, "applyMessageTransform " + this.m_sId, null, null);
        }
        IXTSLogger traceLogger5 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger5.log(env, 8, "Input:", null, null);
            traceLogger5.log(env, 8, blk.asXML(), null, null);
        }
        String messageBaseDebugDumpDir = null;
        if ((env.getMode() & 2) > 0) {
            timer.start();
            StringBuffer tmp = new StringBuffer();
            tmp.append(baseDebugDumpDir);
            tmp.append(File.separatorChar);
            tmp.append(XTSDebugManager.getInstance().generateDirName(1, "messages", null));
            messageBaseDebugDumpDir = tmp.toString();
        }
        if ((env.getMode() & 2) > 0) {
            timer.pause();
            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debuglogger.log(env, messageBaseDebugDumpDir, "input.xml", blk.asXML());
            }
            timer.unpause();
        }
        ArrayList<String> tmplist = new ArrayList<String>();
        for (int i = 0; i < msgFileList.length; ++i) {
            tmplist.add(msgFileList[i]);
        }
        DocumentSource docsrc = new DocumentSource(DocumentHelper.createDocument((Element)blk));
        Source result = XTSMessageTransformer.applyMessage(env, (Source)docsrc, tmplist);
        Reader resultReader = null;
        if (!(result instanceof StreamSource)) {
            Object[] args = new Object[]{this.m_sId};
            throw new XTSException("block.failedtoparsemsgresult", args);
        }
        resultReader = ((StreamSource)result).getReader();
        if (resultReader == null) {
            Object[] args = new Object[]{this.m_sId};
            throw new XTSException("block.failedtoparsemsgresult", args);
        }
        if ((env.getMode() & 2) > 0) {
            timer.pause();
            buffer = new StringBuffer(4096);
            try {
                cbuf = new char[4096];
                bytesRead = resultReader.read(cbuf, 0, 4096);
                while (bytesRead != -1) {
                    buffer.append(cbuf, 0, bytesRead);
                    bytesRead = resultReader.read(cbuf, 0, 4096);
                }
                resultReader = new StringReader(buffer.toString());
                IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                if (debuglogger != null) {
                    debuglogger.log(env, messageBaseDebugDumpDir, "output.xml", buffer.toString());
                }
            }
            catch (IOException e) {
                Object[] args = new Object[]{this.m_sId};
                throw new XTSException("block.failedtoparsemsgresult", args);
            }
            timer.unpause();
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
            try {
                buffer = new StringBuffer(4096);
                cbuf = new char[4096];
                bytesRead = resultReader.read(cbuf, 0, 4096);
                while (bytesRead != -1) {
                    buffer.append(cbuf, 0, bytesRead);
                    bytesRead = resultReader.read(cbuf, 0, 4096);
                }
                resultReader = new StringReader(buffer.toString());
                traceLogger5.log(env, 8, "Output:", null, null);
                traceLogger5.log(env, 8, buffer.toString(), null, null);
            }
            catch (Exception e) {
                Object[] args = new Object[]{this.m_sId};
                throw new XTSException("block.failedtoparsemsgresult", args);
            }
        }
        AXTSPoolObject domReader = null;
        try {
            domReader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            Object[] args = new Object[]{this.m_sId};
            throw new XTSException("block.failedtoparsemsgresult", args, e);
        }
        Element ret = null;
        try {
            ret = ((SAXReader)domReader.get()).read(new InputSource(resultReader)).getRootElement();
            ret.detach();
        }
        catch (Exception e) {
            Object[] args = new Object[]{this.m_sId};
            throw new XTSException("block.failedtoparsemsgresult", args, e);
        }
        finally {
            XTSSAXReaderPool.getInstance().put(domReader);
        }
        if ((env.getMode() & 2) > 0) {
            timer.stop();
            timer.getParent().pause();
            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debuglogger.log(env, messageBaseDebugDumpDir, "timing.xml", timer.toXMLString());
            }
            timer.getParent().unpause();
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
            traceLogger3.log(env, 5, "applyMessageTransform " + this.m_sId, null, null);
        }
        return ret;
    }

    private void compileBlockProcessor(XTSEnvironment env, Element blk, String baseDebugDumpDir, StopWatchTimer timer) throws XTSException {
        IXTSDebugLog debuglogger;
        IXTSLogger traceLogger3 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger3.log(env, 4, "compileBlockProcessor " + this.m_sId, null, null);
        }
        IXTSLogger traceLogger5 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger5.log(env, 8, "Input:", null, null);
            traceLogger5.log(env, 8, blk.asXML(), null, null);
        }
        try {
            this.m_oProcessor = XTSBlockProcessorGenerator.createProcessor(this.m_sProcessorIdentifier);
        }
        catch (XTSBlockProcessorException e) {
            Object[] args = new String[]{this.m_sId};
            throw new XTSException("block.processorinstantiationerror", args, e);
        }
        String compileProcessBaseDebugDumpDir = null;
        if ((env.getMode() & 2) > 0) {
            timer.start();
            StringBuffer tmp = new StringBuffer();
            tmp.append(baseDebugDumpDir);
            tmp.append(File.separatorChar);
            tmp.append(XTSDebugManager.getInstance().generateDirName(2, BLOCK_PROCESSOR, this.m_sProcessorIdentifier));
            compileProcessBaseDebugDumpDir = tmp.toString();
        }
        if ((env.getMode() & 2) > 0) {
            timer.pause();
            debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debuglogger.log(env, compileProcessBaseDebugDumpDir, "input.xml", blk.asXML());
            }
            timer.unpause();
        }
        this.m_oProcessor.compile(env, blk, this, this.m_sId);
        if ((env.getMode() & 2) > 0) {
            timer.stop();
            timer.getParent().pause();
            debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debuglogger.log(env, compileProcessBaseDebugDumpDir, "timing.xml", timer.toXMLString());
            }
            timer.getParent().unpause();
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
            traceLogger5.log(env, 8, "Output:", null, null);
            traceLogger5.log(env, 8, blk.asXML(), null, null);
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
            traceLogger3.log(env, 5, "compileBlockProcessor " + this.m_sId, null, null);
        }
    }

    public String toString() {
        if (this.m_oBlkEle != null) {
            return this.m_oBlkEle.asXML();
        }
        return "";
    }

    public void process(XTSEnvironment env, Source source, Result result, String baseDebugDumpDir, StopWatchTimer timer) throws XTSException {
        StringBuffer tmp;
        StopWatchTimer childTimer;
        if (!this.m_bCompiled) {
            childTimer = null;
            if ((env.getMode() & 2) > 0) {
                childTimer = timer.createChild();
            }
            tmp = new StringBuffer();
            tmp.append(baseDebugDumpDir).append(File.separatorChar).append("00-compile");
            this.compile(env, tmp.toString(), childTimer);
        }
        if (!this.m_bPreProcessed) {
            childTimer = null;
            if ((env.getMode() & 2) > 0) {
                childTimer = timer.createChild();
            }
            tmp = new StringBuffer();
            tmp.append(baseDebugDumpDir).append(File.separatorChar).append("00-preprocess");
            this.preprocess(env, tmp.toString(), childTimer);
        }
        if ((env.getMode() & 2) > 0) {
            timer.start();
        }
        String processorBaseDebugDumpDir = null;
        if ((env.getMode() & 2) > 0) {
            timer.pause();
            tmp = new StringBuffer();
            tmp.append(baseDebugDumpDir);
            tmp.append(File.separatorChar);
            tmp.append(XTSDebugManager.getInstance().generateDirName(1, BLOCK_PROCESSOR, this.m_sProcessorIdentifier));
            processorBaseDebugDumpDir = tmp.toString();
            String processorSrc = this.m_oProcessor.getSource();
            if (processorSrc != null) {
                if (this.m_sProcessorIdentifier.startsWith("XSLT")) {
                    IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                    if (debuglogger != null) {
                        debuglogger.log(env, processorBaseDebugDumpDir, "source.xslt", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + processorSrc);
                    }
                } else {
                    IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                    if (debuglogger != null) {
                        debuglogger.log(env, processorBaseDebugDumpDir, "source.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + processorSrc);
                    }
                }
            }
            timer.unpause();
        }
        try {
            this.m_oProcessor.process(env, source, result, this.m_nMode == 1, this.m_sId);
        }
        catch (XTSException e) {
            Object[] args = new String[]{this.m_sId};
            throw new XTSException("block.processfailed", args, e);
        }
        if ((env.getMode() & 2) > 0) {
            timer.stop();
            timer.getParent().pause();
            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debuglogger.log(env, processorBaseDebugDumpDir, "timing.xml", timer.toXMLString());
            }
            timer.getParent().unpause();
        }
    }

    public boolean checkCondition(Document doc) {
        List queryNodes;
        return this.m_oCondition == null || !(queryNodes = this.m_oCondition.selectNodes((Object)doc)).isEmpty();
    }

    public XTSOutputContext getOutputContext() {
        return this.m_oOutputContextObj;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        try {
            if (href.indexOf(58) == -1) {
                String name = href.startsWith("$CONFIG_ROOT$") ? href : PathUtils.buildPath(this.m_sResolverBase, href);
                InputStream is = null;
                try {
                    is = XTSResourceManager.getInstance().getResource(name);
                }
                catch (XTSException e) {
                    Object[] args = new String[]{this.m_sId, href};
                    throw new TransformerException(new XTSException("reader.nonexistantfile", args).getRootCauseLocalizedMsgString(this.m_creationLocale));
                }
                if (is == null) {
                    Object[] args = new String[]{this.m_sId, href};
                    throw new TransformerException(new XTSException("reader.nonexistantfile", args).getRootCauseLocalizedMsgString(this.m_creationLocale));
                }
                return new StreamSource(is, name);
            }
            return new StreamSource(href);
        }
        catch (IOException e) {
            Object[] args = new String[]{this.m_sId, href};
            throw new TransformerException(new XTSException("block.resolverfailed", args).getRootCauseLocalizedMsgString(this.m_creationLocale));
        }
    }
}

