/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts;

import com.cognos.xts.XTSBlock;
import com.cognos.xts.XTSBlockOrganizerThread;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSObject;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSDebugManager;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.util.StopWatchTimer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Document;

public class XTSBlockOrganizer {
    private ArrayList m_SortedExecBlkArray = null;
    private Map m_ExecBlkMap = null;
    private Map m_TestBlkMap = null;
    private Map m_FaultBlkMap = null;
    private XTSObject m_Parent = null;
    private StopWatchTimer m_timer = null;
    private XTSException m_FaultException = null;
    private HashMap m_blockExecutionMap = null;

    public XTSBlockOrganizer(ArrayList sortedExecuteBlocks, Map executeBlocks, Map testBlocks, Map faultBlocks, XTSObject parent, StopWatchTimer timer) {
        this.m_SortedExecBlkArray = sortedExecuteBlocks;
        this.m_ExecBlkMap = executeBlocks;
        this.m_TestBlkMap = testBlocks;
        this.m_FaultBlkMap = faultBlocks;
        this.m_Parent = parent;
        this.m_timer = timer;
        this.m_blockExecutionMap = new HashMap();
    }

    public XTSBlock getExecblock(String id) {
        return (XTSBlock)this.m_ExecBlkMap.get(id);
    }

    public XTSBlock getTestBlock(String id) {
        return (XTSBlock)this.m_TestBlkMap.get(id);
    }

    public XTSBlock getFaultBlock(String id) {
        return (XTSBlock)this.m_FaultBlkMap.get(id);
    }

    public void setFault(String blkid, XTSException exception) {
        this.markBlockExecution(blkid, false);
        this.m_FaultException = exception;
    }

    public void start(Document rootDoc, XTSEnvironment env) throws XTSException {
        IXTSLogger traceLogger3 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger3.log(env, 4, "XTSBlockOrganizer " + this.m_Parent.getName(), null, null);
        }
        IXTSLogger traceLogger5 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger5.log(env, 8, "RootDoc:", null, null);
            traceLogger5.log(env, 8, rootDoc.asXML(), null, null);
        }
        IXTSLogger pLogger1 = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[1][0] && (pLogger1 = XTSPerfLoggerManager.getInstance().getLogger(1, 0)) != null) {
            pLogger1.log(env, 6, this.getClass().getName(), "execute", "executing all block" + env.getMorphletName());
            pLogger1.starttimer();
        }
        int blockExecutionCount = 0;
        for (int i = 0; i < this.m_SortedExecBlkArray.size(); ++i) {
            XTSBlock blk = (XTSBlock)this.m_SortedExecBlkArray.get(i);
            if (!this.canProcessBlock(blk)) {
                this.markBlockExecution(blk.getId(), false);
                continue;
            }
            IXTSLogger pLogger2 = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger2 = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                pLogger2.log(env, 6, this.getClass().getName(), "executeBlock", "Start checking block condition for : " + env.getMorphletName() + "(" + blk.getId() + ")");
                pLogger2.starttimer();
            }
            boolean bConditionPassed = blk.checkCondition(rootDoc);
            if (pLogger2 != null) {
                pLogger2.stoptimer();
                pLogger2.log(env, 1, this.getClass().getName(), "executeBlock", "Completed checking block condition for : " + env.getMorphletName() + "(" + blk.getId() + ")");
            }
            this.markBlockExecution(blk.getId(), bConditionPassed || !blk.isMandatory());
            if (!bConditionPassed) continue;
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                traceLogger3.log(env, 2, "XTSBlockOrganizerThread " + this.m_Parent.getName(), null, null);
            }
            StopWatchTimer childTimer = null;
            if ((env.getMode() & 2) > 0) {
                childTimer = this.m_timer.createChild();
            }
            XTSBlockOrganizerThread blkExecutor = new XTSBlockOrganizerThread();
            blkExecutor.initialize(env, blk, this, this.m_Parent, rootDoc, childTimer);
            if ((env.getMode() & 2) > 0) {
                StringBuffer tmp = new StringBuffer();
                tmp.append(env.getDebugRequestPath());
                tmp.append(File.separatorChar);
                tmp.append(XTSDebugManager.getInstance().generateDirName(blockExecutionCount++, "block", blk.getId()));
                blkExecutor.setBaseDebugDir(tmp.toString());
            }
            blkExecutor.run();
            if (!XTSTraceLoggerManager.getInstance().isEnabled[4][0] || traceLogger3 == null) continue;
            traceLogger3.log(env, 3, "XTSBlockOrganizerThread " + this.m_Parent.getName(), null, null);
        }
        if (pLogger1 != null) {
            pLogger1.stoptimer();
            pLogger1.log(env, 1, this.getClass().getName(), "execute", "executing all block" + env.getMorphletName());
        }
        if (this.m_FaultException != null) {
            throw this.m_FaultException;
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
            traceLogger3.log(env, 5, "XTSBlockOrganizer " + this.m_Parent.getName(), null, null);
        }
    }

    private void markBlockExecution(String blkId, boolean result) {
        this.m_blockExecutionMap.put(blkId, new Boolean(result));
    }

    private boolean canProcessBlock(XTSBlock blk) {
        String dependency = blk.getDependency();
        if (dependency != null && !"".equals(dependency)) {
            StringTokenizer t = new StringTokenizer(dependency);
            while (t.hasMoreTokens()) {
                Boolean result = (Boolean)this.m_blockExecutionMap.get(t.nextToken());
                boolean canProcess = result == null || result != false;
                if (canProcess) continue;
                return false;
            }
        }
        return true;
    }
}

