/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts;

import com.cognos.xts.XTSBlock;
import com.cognos.xts.XTSBlockOrganizer;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSObject;
import com.cognos.xts.XTSSAXWriter;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.common.thread.IXTSRerunnable;
import com.cognos.xts.interpreter.XTSBlockInterpreter2;
import com.cognos.xts.logging.IXTSDebugLog;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSDebugManager;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.output.XTSOutputContext;
import com.cognos.xts.output.XTSOutputObject;
import com.cognos.xts.output.XTSOutputSpecUtils;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.CharArrayReaderWriter;
import com.cognos.xts.util.StopWatchTimer;
import java.io.File;
import javax.mail.internet.InternetHeaders;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XTSBlockOrganizerThread
implements IXTSRerunnable {
    private static final int BIG_BUFFER_SIZE = 65536;
    private XTSBlock m_block = null;
    private XTSBlockOrganizer m_organizer = null;
    private XTSObject m_parent = null;
    private String m_baseDebugDumpDir = null;
    private Document m_document = null;
    private XTSEnvironment m_env = null;
    private StopWatchTimer m_timer = null;

    @Override
    public boolean recycle() {
        this.cleanup();
        return true;
    }

    @Override
    public void terminate() {
        this.cleanup();
    }

    private void cleanup() {
        this.m_env = null;
        this.m_block = null;
        this.m_organizer = null;
        this.m_parent = null;
        this.m_document = null;
        this.m_timer = null;
        this.m_baseDebugDumpDir = null;
    }

    public void initialize(XTSEnvironment env, XTSBlock block, XTSBlockOrganizer organizer, XTSObject parent, Document document, StopWatchTimer timer) {
        this.m_env = env;
        this.m_block = block;
        this.m_organizer = organizer;
        this.m_parent = parent;
        this.m_document = document;
        this.m_timer = timer;
    }

    public void setBaseDebugDir(String baseDebugDumpDir) {
        this.m_baseDebugDumpDir = baseDebugDumpDir;
    }

    @Override
    public void run() {
        IXTSLogger traceLogger3 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger3.log(this.m_env, 4, "XTSBlockOrganizerThread " + this.m_parent.getName(), null, null);
        }
        if ((this.m_env.getMode() & 2) > 0) {
            this.m_timer.start();
        }
        try {
            IXTSLogger pLogger1 = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[1][0] && (pLogger1 = XTSPerfLoggerManager.getInstance().getLogger(1, 0)) != null) {
                pLogger1.log(this.m_env, 6, this.getClass().getName(), "run", "Block::" + this.m_block.getId());
                pLogger1.starttimer();
            }
            boolean success = this.executeBlock();
            if (pLogger1 != null) {
                pLogger1.stoptimer();
                pLogger1.log(this.m_env, 1, this.getClass().getName(), "run", "Block::" + this.m_block.getId());
            }
        }
        catch (XTSException e) {
            this.m_organizer.setFault(this.m_block.getId(), e);
        }
        if ((this.m_env.getMode() & 2) > 0) {
            this.m_timer.stop();
            this.m_timer.getParent().pause();
            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debuglogger.log(this.m_env, this.m_baseDebugDumpDir, "timing.xml", this.m_timer.toXMLString());
            }
            this.m_timer.getParent().unpause();
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
            traceLogger3.log(this.m_env, 5, "XTSBlockOrganizerThread " + this.m_parent.getName(), null, null);
        }
    }

    private boolean executeBlock() throws XTSException {
        XTSBlock blk = this.m_block;
        boolean bBlockDebugEnabled = (this.m_env.getMode() & 2) > 0;
        try {
            IXTSDebugLog debuglogger;
            IXTSLogger traceLogger3 = null;
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                traceLogger3.log(this.m_env, 4, "XTSBlockOrganizerThread - executeBlock: " + blk.getId(), null, null);
            }
            if (bBlockDebugEnabled) {
                this.m_timer.pause();
                debuglogger = XTSDebugManager.getInstance().getLogger();
                if (debuglogger != null) {
                    debuglogger.log(this.m_env, this.m_baseDebugDumpDir, "input.xml", this.m_document);
                }
                this.m_timer.unpause();
            }
            if (bBlockDebugEnabled) {
                this.m_timer.pause();
                debuglogger = XTSDebugManager.getInstance().getLogger();
                if (debuglogger != null) {
                    debuglogger.log(this.m_env, this.m_baseDebugDumpDir, "source.xml", blk.toString());
                }
                this.m_timer.unpause();
            }
            if (bBlockDebugEnabled) {
                IXTSDebugLog debuglogger2;
                this.m_timer.pause();
                String processorBaseDebugDumpDir = null;
                if ((this.m_env.getMode() & 2) > 0) {
                    StringBuffer tmp = new StringBuffer();
                    tmp.append(this.m_baseDebugDumpDir);
                    tmp.append(File.separatorChar);
                    tmp.append(XTSDebugManager.getInstance().generateDirName(1, "processor", blk.getProcessorIdentifier()));
                    processorBaseDebugDumpDir = tmp.toString();
                }
                if ((debuglogger2 = XTSDebugManager.getInstance().getLogger()) != null) {
                    debuglogger2.log(this.m_env, processorBaseDebugDumpDir, "input.xml", this.m_document);
                }
                this.m_timer.unpause();
            }
            IXTSLogger traceLogger5 = null;
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                traceLogger5.log(this.m_env, 8, blk.getId() + " mode: " + this.m_block.getMode(), null, null);
            }
            StopWatchTimer childTimer = null;
            if ((this.m_env.getMode() & 2) > 0) {
                childTimer = this.m_timer.createChild();
            }
            switch (this.m_block.getMode()) {
                case 2: {
                    StopWatchTimer intChildTimer = null;
                    if ((this.m_env.getMode() & 2) > 0) {
                        intChildTimer = this.m_timer.createChild();
                    }
                    String debugdir = null;
                    if ((this.m_env.getMode() & 2) > 0) {
                        StringBuffer tmp = new StringBuffer();
                        tmp.append(this.m_baseDebugDumpDir);
                        tmp.append(File.separatorChar);
                        tmp.append(XTSDebugManager.getInstance().generateDirName(2, "interpreter", null));
                        debugdir = tmp.toString();
                    }
                    IXTSLogger pLogger3 = null;
                    if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger3 = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        pLogger3.log(this.m_env, 6, this.getClass().getName(), "executeBlock", "Start parsing interpret block : " + this.m_env.getMorphletName() + "(" + blk.getId() + ")");
                        pLogger3.starttimer();
                    }
                    XTSBlockInterpreter2 interpreter2 = new XTSBlockInterpreter2(this.m_env, this.m_organizer, this.m_document, debugdir, intChildTimer, this.m_block.getId());
                    DocumentSource docsrc = new DocumentSource(this.m_document);
                    XTSSAXWriter writer = new XTSSAXWriter(this.m_block.getNodeList());
                    SAXResult result = new SAXResult(interpreter2);
                    result.setLexicalHandler(interpreter2);
                    docsrc.setXMLReader((XMLReader)((Object)writer));
                    this.m_block.process(this.m_env, (Source)docsrc, result, this.m_baseDebugDumpDir, childTimer);
                    if (pLogger3 != null) {
                        pLogger3.stoptimer();
                        pLogger3.log(this.m_env, 1, this.getClass().getName(), "executeBlock", "Completed parsing interpret block : " + this.m_env.getMorphletName() + "(" + blk.getId() + ")");
                    }
                    interpreter2.checkStatus();
                    break;
                }
                case 1: {
                    IXTSLogger pLogger3 = null;
                    if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger3 = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        pLogger3.log(this.m_env, 6, this.getClass().getName(), "executeBlock", "Start parsing output block : " + this.m_env.getMorphletName() + "(" + blk.getId() + ")");
                        pLogger3.starttimer();
                    }
                    ByteArrayIOStream bio = new ByteArrayIOStream(65536);
                    DocumentSource docsrc = new DocumentSource(this.m_document);
                    XTSSAXWriter writer = new XTSSAXWriter(this.m_block.getNodeList());
                    docsrc.setXMLReader((XMLReader)((Object)writer));
                    this.m_block.process(this.m_env, (Source)docsrc, new StreamResult(bio), this.m_baseDebugDumpDir, childTimer);
                    int size = bio.size();
                    XTSOutputObject obj = new XTSOutputObject(bio.convert());
                    obj.setInMemory(true);
                    obj.setStreamSize(size);
                    String refId = this.m_env.setContentStream(obj);
                    XTSOutputContext outputContext = this.m_block.getOutputContext();
                    switch (outputContext.getOption()) {
                        case 2: {
                            Element contentElem = XTSOutputSpecUtils.createContentElement(outputContext, refId);
                            if (this.m_document == null) {
                                throw new XTSException("interpreter.nulldocument");
                            }
                            Element rootElem = this.m_document.getRootElement();
                            if (rootElem == null) {
                                throw new XTSException("interpreter.missingrootelement");
                            }
                            Element outputElem = rootElem.element("output");
                            if (outputElem == null) {
                                throw new XTSException("interpreter.missingoutputelement");
                            }
                            XTSOutputSpecUtils.updateOutputSpec(outputContext, outputElem, contentElem);
                            break;
                        }
                        case 4: {
                            InternetHeaders hdrs = new InternetHeaders();
                            hdrs.addHeader("Content-Type", outputContext.getMimeType());
                            Element partElem = XTSOutputSpecUtils.createPartElement(outputContext, hdrs, refId);
                            if (this.m_document == null) {
                                throw new XTSException("interpreter.nulldocument");
                            }
                            Element rootElem = this.m_document.getRootElement();
                            if (rootElem == null) {
                                throw new XTSException("interpreter.missingrootelement");
                            }
                            Element outputElem = rootElem.element("output");
                            if (outputElem == null) {
                                throw new XTSException("interpreter.missingoutputelement");
                            }
                            outputElem.add(partElem);
                            break;
                        }
                        default: {
                            Object[] args = new Object[]{outputContext.getOptionString()};
                            throw new XTSException("blkprocessor.outputoptionnotsupported", args);
                        }
                    }
                    if (pLogger3 == null) break;
                    pLogger3.stoptimer();
                    pLogger3.log(this.m_env, 1, this.getClass().getName(), "executeBlock", "Completed parsing output block : " + this.m_env.getMorphletName() + "(" + blk.getId() + ")");
                    break;
                }
                case 0: {
                    IXTSLogger pLogger3 = null;
                    if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger3 = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        pLogger3.log(this.m_env, 6, this.getClass().getName(), "executeBlock", "Start parsing input block : " + this.m_env.getMorphletName() + "(" + blk.getId() + ")");
                        pLogger3.starttimer();
                    }
                    CharArrayReaderWriter rw = new CharArrayReaderWriter(65536);
                    rw.write("<content>");
                    DocumentSource docsrc = new DocumentSource(this.m_document);
                    XTSSAXWriter writer = new XTSSAXWriter(this.m_block.getNodeList());
                    docsrc.setXMLReader((XMLReader)((Object)writer));
                    this.m_block.process(this.m_env, (Source)docsrc, new StreamResult(rw), this.m_baseDebugDumpDir, childTimer);
                    rw.write("</content>");
                    Element miiElem = null;
                    AXTSPoolObject reader = null;
                    try {
                        reader = XTSSAXReaderPool.getInstance().acquire();
                    }
                    catch (XTSException e) {
                        Object[] args = new Object[]{this.m_block.getProcessorIdentifier()};
                        throw new XTSException("blkprocessor.parseresultfailed", args, e);
                    }
                    try {
                        miiElem = ((SAXReader)reader.get()).read(new InputSource(rw.convert())).getRootElement();
                        miiElem.detach();
                    }
                    catch (Exception e) {
                        Object[] args = new Object[]{this.m_block.getProcessorIdentifier()};
                        throw new XTSException("blkprocessor.parseresultfailed", args, e);
                    }
                    finally {
                        XTSSAXReaderPool.getInstance().put(reader);
                    }
                    if (this.m_document == null) {
                        throw new XTSException("interpreter.nulldocument");
                    }
                    this.m_document.getRootElement().appendContent((Branch)miiElem);
                    if (pLogger3 == null) break;
                    pLogger3.stoptimer();
                    pLogger3.log(this.m_env, 1, this.getClass().getName(), "executeBlock", "Completed parsing input block : " + this.m_env.getMorphletName() + "(" + blk.getId() + ")");
                }
            }
            if (bBlockDebugEnabled) {
                this.m_timer.pause();
                if (this.m_document == null) {
                    throw new XTSException("interpreter.nulldocument");
                }
                IXTSDebugLog debuglogger3 = XTSDebugManager.getInstance().getLogger();
                if (debuglogger3 != null) {
                    debuglogger3.log(this.m_env, this.m_baseDebugDumpDir, "output.xml", this.m_document);
                }
                this.m_timer.unpause();
            }
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                traceLogger3.log(this.m_env, 5, "XTSBlockOrganizerThread - executeBlock: " + blk.getId(), null, null);
            }
        }
        catch (Throwable e) {
            Object[] args = new String[]{blk.getId()};
            throw new XTSException("block.executionexception", args, e);
        }
        return true;
    }
}

