/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.thread.XTSThread;
import com.cognos.xts.common.thread.XTSThreadPool;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.PropertiesManager;

public class XTSBlockThreadPool {
    private static final String PROPERTY_BLOCKPOOL_INITSIZE = "blockthreadpool.initsize";
    private static final String PROPERTY_BLOCKPOOL_CLEANUPTIME = "blockthreadpool.cleanuptime";
    private static final String IDENTIFIER = "XTSBlockThreadPool";
    private static final String THREAD_CLASS = "com.cognos.xts.XTSBlockOrganizerThread";
    private static XTSBlockThreadPool m_instance = new XTSBlockThreadPool();
    private XTSThreadPool m_threadPool = new XTSThreadPool("xts-blocks");

    public static XTSBlockThreadPool getInstance() {
        return m_instance;
    }

    private XTSBlockThreadPool() {
    }

    public synchronized void initialize() throws XTSException {
        IXTSLogger logger;
        int initPoolSize = 10;
        String sInitPoolSize = PropertiesManager.getInstance().getProperty(PROPERTY_BLOCKPOOL_INITSIZE);
        if (sInitPoolSize != null) {
            try {
                initPoolSize = Integer.parseInt(sInitPoolSize);
            }
            catch (NumberFormatException e) {
                Object[] args = new String[]{IDENTIFIER};
                throw new XTSException("threadpool.poolinitfailed", args, e);
            }
        }
        long cleanupTime = 3600000L;
        String sCleanupTime = PropertiesManager.getInstance().getProperty(PROPERTY_BLOCKPOOL_CLEANUPTIME);
        if (sCleanupTime != null) {
            try {
                cleanupTime = Long.parseLong(sCleanupTime);
            }
            catch (NumberFormatException e) {
                Object[] args = new String[]{IDENTIFIER};
                throw new XTSException("threadpool.poolinitfailed", args, e);
            }
        }
        this.m_threadPool.initialize(initPoolSize, "Block", cleanupTime, THREAD_CLASS);
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 0, IDENTIFIER, null, null);
        }
    }

    public synchronized void terminate() throws XTSException {
        IXTSLogger logger;
        try {
            this.m_threadPool.terminate();
        }
        catch (XTSException e) {
            Object[] args = new String[]{IDENTIFIER};
            throw new XTSException("threadpool.pooltermfailed", args, e);
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 1, IDENTIFIER, null, null);
        }
    }

    public synchronized void reinitialize() throws XTSException {
        this.terminate();
        this.initialize();
    }

    public synchronized void interrupt() throws XTSException {
        this.m_threadPool.interrupt();
    }

    public synchronized XTSThread getBlockThread() throws XTSException {
        return this.m_threadPool.acquireThread();
    }
}

