/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts;

import com.cognos.i18n.TimeZone;
import com.cognos.xts.XTSException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.output.XTSOutputObject;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.security.IXTSCacheSecurity;
import com.cognos.xts.security.XTSSecurityFactory;
import com.cognos.xts.util.soaputil;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public final class XTSEnvironment {
    private Locale m_locale = null;
    private TimeZone m_timezone;
    private ArrayList m_lookupList = null;
    private int m_mode = 0;
    private String m_compilePath;
    private String m_debugRequestPath;
    private String m_debugCompilePath;
    private UID m_uid = new UID();
    private HashMap m_contentMap = new HashMap();
    private String m_morphletName = null;
    private String m_requestContext = "";
    private String m_sessionContext = "";
    private String m_stepContext = "";
    private String m_subRequestContext = "";
    private String m_callerID;
    private HashSet userCapabilities = null;

    public XTSEnvironment() {
        this.m_callerID = "";
    }

    public XTSEnvironment(String id) {
        this.m_callerID = id;
    }

    public String getCallerID() {
        return this.m_callerID;
    }

    public String getUID() {
        return this.m_uid.toString();
    }

    public static String createUID() {
        return new UID().toString();
    }

    public void setRequestContext(String context) {
        this.m_requestContext = context;
    }

    public String getRequestContext() {
        return this.m_requestContext;
    }

    public void setSessionContext(String context) {
        this.m_sessionContext = context;
    }

    public String getSessionContext() {
        return this.m_sessionContext;
    }

    public void setStepContext(String context) {
        this.m_stepContext = context;
    }

    public String getStepContext() {
        return this.m_stepContext;
    }

    public void setSubRequestContext(String context) {
        this.m_subRequestContext = context;
    }

    public String getSubRequestContext() {
        return this.m_subRequestContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setContentStream(XTSOutputObject obj) {
        String uid = new UID().toString();
        HashMap hashMap = this.m_contentMap;
        synchronized (hashMap) {
            this.m_contentMap.put(uid, obj);
        }
        return uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XTSOutputObject getContentStream(String uid) {
        if (uid == null) {
            return null;
        }
        XTSOutputObject obj = null;
        HashMap hashMap = this.m_contentMap;
        synchronized (hashMap) {
            obj = (XTSOutputObject)this.m_contentMap.remove(uid);
        }
        return obj;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public ArrayList getLookupList() {
        return this.m_lookupList;
    }

    public void setLookupList(ArrayList lookupList) {
        this.m_lookupList = lookupList;
    }

    public TimeZone getTimeZone() {
        return this.m_timezone;
    }

    public void setTimeZone(TimeZone timezone) {
        this.m_timezone = timezone;
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int mode) {
        this.m_mode = mode;
    }

    public String getMorphletName() {
        return this.m_morphletName;
    }

    public void setMorphletName(String name) {
        this.m_morphletName = name;
    }

    public String getDebugRequestPath() {
        return this.m_debugRequestPath;
    }

    public void setDebugRequestPath(String debugRequestPath) {
        this.m_debugRequestPath = debugRequestPath;
    }

    public void cleanup() {
        XTSOutputObject obj = null;
        for (Map.Entry pair : this.m_contentMap.entrySet()) {
            obj = (XTSOutputObject)this.m_contentMap.get((String)pair.getKey());
            obj.release();
        }
        this.m_contentMap.clear();
    }

    public void setUserCapabilities(HashSet userCapabilities) {
        this.userCapabilities = userCapabilities;
    }

    public HashSet getUserCapabilities() {
        return this.userCapabilities;
    }

    public HashSet setupUserCapabilities(Element soapHeader, Document rootDoc) throws XTSException {
        if (this.userCapabilities == null) {
            Element userCapabilitiesEle;
            Element userCapabilityCacheEle;
            Element biBusHeader;
            Element element = biBusHeader = soapHeader != null ? soapHeader.element("biBusHeader") : (Element)rootDoc.selectSingleNode("/root/*/*[local-name()='biBusHeader']");
            if (biBusHeader == null) {
                biBusHeader = (Element)rootDoc.selectSingleNode("/root//*[local-name()='biBusHeader']");
            }
            Element element2 = userCapabilityCacheEle = biBusHeader != null ? biBusHeader.element("userCapabilityCache") : null;
            if (userCapabilityCacheEle != null && (userCapabilitiesEle = userCapabilityCacheEle.element("userCapabilities")) != null) {
                String userCapabilitiesVerifyXML = userCapabilitiesEle.asXML();
                String token = null;
                Element signature = userCapabilityCacheEle.element("signature");
                if (signature != null) {
                    token = signature.getText();
                }
                if (userCapabilitiesVerifyXML == null) {
                    userCapabilitiesVerifyXML = "";
                }
                if (token == null) {
                    token = "";
                }
                boolean limitUserCapabilties = false;
                boolean noUserCapabilityCheck = "false".equals(PropertiesManager.getInstance().getProperty("option.usercapabilitycheck"));
                if (!noUserCapabilityCheck) {
                    HashMap<String, String> attr = new HashMap<String, String>();
                    attr.put("name", "cognos.cam");
                    IXTSCacheSecurity security = (IXTSCacheSecurity)((Object)XTSSecurityFactory.getInstance().getObject(null, attr));
                    if (security != null) {
                        boolean verified = false;
                        XTSException verifyException = null;
                        String passportID = null;
                        try {
                            boolean ignoreVerification = false;
                            passportID = soaputil.getPassportIDFromBusHeader(biBusHeader);
                            if (passportID == null || "".equals(passportID)) {
                                boolean bl = ignoreVerification = rootDoc.selectSingleNode("/root/envelope/*[local-name() = 'Envelope']/*[local-name() = 'Body']//*[local-name() = 'Fault']") != null || rootDoc.selectSingleNode("/root/command/envelope/*[local-name() = 'Envelope']/*[local-name() = 'Body']//*[local-name() = 'Fault']") != null;
                            }
                            if (!ignoreVerification) {
                                verified = security.verifyUserCapabilities(token, userCapabilitiesVerifyXML, passportID);
                            } else {
                                verified = true;
                                limitUserCapabilties = true;
                            }
                        }
                        catch (XTSException e) {
                            verifyException = e;
                        }
                        if (!verified) {
                            boolean isHandlingFault;
                            boolean bl = isHandlingFault = rootDoc.selectSingleNode(".//*[local-name() = 'Fault']") != null;
                            if (isHandlingFault) {
                                limitUserCapabilties = true;
                            } else {
                                IXTSLogger logger;
                                XTSException e;
                                XTSException xTSException = e = verifyException != null ? verifyException : new XTSException("security.sessioncapabilityviolation");
                                if (XTSTraceLoggerManager.getInstance().isEnabled[0][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) != null) {
                                    String msg;
                                    String string = msg = e.getMessage() != null ? e.getMessage() : "";
                                    if (Locale.getDefault() != null) {
                                        msg = msg + "\n" + e.getLocalizedMsgString(Locale.getDefault());
                                    }
                                    msg = msg + "\nStart of the userCapability XML block in the SOAP header[[[\n";
                                    msg = msg + userCapabilityCacheEle.asXML();
                                    msg = msg + "\n]]]End of the userCapability XML block in the SOAP header\n";
                                    msg = msg + "**userCapabilitiesVerifyXML value is: [[[" + userCapabilitiesVerifyXML + "]]]";
                                    msg = msg + "**Signature value is: [[[" + token + "]]]";
                                    msg = msg + "**PassportID value is: [[[" + passportID + "]]]";
                                    logger.log(null, 8, msg.toString(), null, null);
                                }
                                throw e;
                            }
                        }
                    }
                }
                this.userCapabilities = new HashSet();
                List userCapabilitiesList = userCapabilitiesEle.elements("item");
                if (userCapabilitiesList != null) {
                    for (int i = 0; i < userCapabilitiesList.size(); ++i) {
                        Element item = (Element)userCapabilitiesList.get(i);
                        String capability = item.getText();
                        if (limitUserCapabilties && !"canReceiveDetailedErrors".equals(capability)) {
                            capability = null;
                        }
                        if (capability == null) continue;
                        this.userCapabilities.add(capability);
                    }
                }
            }
        }
        return this.userCapabilities;
    }
}

