/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts;

import com.cognos.xts.UXTSExceptionUtils;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.messages.MessagesManager;
import com.cognos.xts.util.soaputil;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Locale;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class XTSException
extends Exception {
    protected String m_key = null;
    protected Object[] m_args = null;
    protected Throwable m_detail = null;
    public static final QName EXCEPTION_QNAME = new QName("exception", XTSProcessor.XTS_NAMESPACE);
    public static final QName EXCEPTIONCODE_QNAME = new QName("exceptionCode", XTSProcessor.XTS_NAMESPACE);
    public static final QName EXCEPTIONMSG_QNAME = new QName("exceptionMsg", XTSProcessor.XTS_NAMESPACE);
    public static final QName EXCEPTIONDETAIL_QNAME = new QName("exceptionDetail", XTSProcessor.XTS_NAMESPACE);
    public static final QName EXCEPTIONST_QNAME = new QName("exceptionStackTrace", XTSProcessor.XTS_NAMESPACE);
    protected static final int BUFFER_SIZE = 4096;

    public XTSException(String key) {
        super(key);
        this.m_key = key;
        this.log();
    }

    public XTSException(String key, Throwable exception) {
        super(key);
        this.m_key = key;
        this.m_detail = exception;
        if (!(exception instanceof XTSException)) {
            this.log();
        }
    }

    public XTSException(String key, Object[] args) {
        super(key);
        this.m_key = key;
        this.m_args = args;
        this.log();
    }

    public XTSException(String key, Object[] args, Throwable exception) {
        super(key);
        this.m_key = key;
        this.m_args = args;
        this.m_detail = exception;
        if (!(exception instanceof XTSException)) {
            this.log();
        }
    }

    protected void log() {
        int level = 0;
        boolean logit = true;
        if (this.m_detail != null && this.m_detail instanceof FileNotFoundException || this.m_key.startsWith("reader.")) {
            logit = false;
        }
        if (logit && XTSTraceLoggerManager.getInstance().isEnabled[level][0]) {
            StringWriter tmp;
            StringBuffer msg = new StringBuffer();
            msg.append("Exception encountered...\n");
            msg.append("  Exception Class: ").append(this.getClass().getName()).append("\n");
            msg.append("  Exception Key: ").append(this.m_key).append("\n");
            if (this.m_detail != null) {
                msg.append("  Cause: ").append(this.m_detail.getClass().getName()).append("\n");
                msg.append("    ").append(this.m_detail.getMessage()).append("\n");
                msg.append("  Stack dump (cause): ").append("\n");
                tmp = new StringWriter();
                this.m_detail.printStackTrace(new PrintWriter(tmp));
                msg.append(tmp.toString()).append("\n");
                Throwable cause = this.m_detail.getCause();
                if (cause != null) {
                    StringWriter causeMsg = new StringWriter();
                    cause.printStackTrace(new PrintWriter(causeMsg));
                    msg.append(causeMsg.toString()).append("\n");
                }
            }
            msg.append("  Stack dump: ").append("\n");
            tmp = new StringWriter();
            this.printStackTrace(new PrintWriter(tmp));
            msg.append(tmp.toString()).append("\n");
            IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(level, 0);
            if (logger != null) {
                logger.log(null, 8, msg.toString(), null, null);
            }
        }
    }

    public String getKey() {
        return this.m_key;
    }

    public Throwable getDetail() {
        return this.m_detail;
    }

    public String getLocalizedMsgString(Locale locale) {
        if (this.m_args == null) {
            return MessagesManager.getInstance().getMessage(locale, this.m_key);
        }
        return MessagesManager.getInstance().getMessage(locale, this.m_key, this.m_args);
    }

    public Element getFaultXML(Locale locale, boolean stackdump) {
        Element exceptionElement = DocumentHelper.createElement((QName)EXCEPTION_QNAME);
        Element excpetionCodeElement = DocumentHelper.createElement((QName)EXCEPTIONCODE_QNAME);
        excpetionCodeElement.addText(this.m_key);
        exceptionElement.add(excpetionCodeElement);
        Element excpetionMsgElement = DocumentHelper.createElement((QName)EXCEPTIONMSG_QNAME);
        String msg = this.getLocalizedMsgString(locale);
        if (msg != null) {
            excpetionMsgElement.addText(msg);
        }
        exceptionElement.add(excpetionMsgElement);
        if (stackdump) {
            Element exceptionSTElement = DocumentHelper.createElement((QName)EXCEPTIONST_QNAME);
            StringWriter sw = new StringWriter(4096);
            PrintWriter pw = new PrintWriter(sw);
            this.printStackTrace(pw);
            pw.close();
            exceptionSTElement.addText(sw.toString());
            exceptionElement.add(exceptionSTElement);
        }
        return exceptionElement;
    }

    public String getRootCauseLocalizedMsgString(Locale locale) {
        XTSException xtsEx = this;
        Throwable containedException = this.m_detail;
        while (containedException instanceof XTSException) {
            xtsEx = (XTSException)containedException;
            containedException = xtsEx.m_detail;
        }
        return xtsEx.getLocalizedMsgString(locale);
    }

    public String getLastLocalizedMsgString(Locale locale, int level) {
        int msgssize;
        if (level <= 0) {
            return "";
        }
        ArrayList<String> msgs = new ArrayList<String>();
        Throwable curEx = this;
        while (curEx != null) {
            if (curEx instanceof XTSException) {
                msgs.add(curEx.getLocalizedMsgString(locale));
                curEx = curEx.m_detail;
                continue;
            }
            msgs.add(((Exception)curEx).getMessage());
            break;
        }
        if ((msgssize = msgs.size()) < level) {
            level = msgssize;
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 1; i <= level; ++i) {
            ret.append((String)msgs.get(msgssize - i));
            ret.append("\n");
        }
        return ret.toString();
    }

    public Element getSoapEnvElementCopy(Locale locale, int soapVer) {
        Element faultDetailEle = soaputil.createSOAPFaultDetail(soapVer);
        faultDetailEle.add(this.getFaultXML(locale, false));
        Throwable nestedEx = this.getDetail();
        if (nestedEx != null) {
            while (nestedEx != null) {
                if (nestedEx instanceof XTSException) {
                    faultDetailEle.add(((XTSException)nestedEx).getFaultXML(locale, false));
                    nestedEx = ((XTSException)nestedEx).getDetail();
                    continue;
                }
                faultDetailEle.add(UXTSExceptionUtils.getFaultXMLForThrowable(nestedEx, locale, false));
                nestedEx = null;
                break;
            }
        }
        Element faultEle = soaputil.createSOAPFault(soapVer, this.getKey(), this.getLocalizedMsgString(locale), faultDetailEle);
        Element bodyEle = soaputil.createSOAPBody(soapVer);
        bodyEle.add(faultEle);
        Element envEle = soaputil.createSOAPEnvelope(soapVer, null, bodyEle);
        return envEle;
    }
}

