/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts;

import com.cognos.xts.XTSBlock;
import com.cognos.xts.XTSBlockOrganizer;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.capability.RequiredCapabilities;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSDebugManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.util.Scheduler;
import com.cognos.xts.util.StopWatchTimer;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public final class XTSObject {
    private static final int BUFFER_SIZE = 4096;
    public static final String MORPHLET = "morphlet";
    public static final String MESSAGES = "messageBase";
    public static final String RESOLVERBASE = "resolverBase";
    public static final String INCLUDECONFIG = "includeConfig";
    public static final String REQUIREDCAPABILITY = "requiredCapability";
    public static final String MORPHLET_PACKAGE = "com/cognos/xts/morphlets";
    private String m_Name = null;
    private ArrayList m_oSortedExecBlkArray = new ArrayList();
    private Map m_oExecBlkMap = new LinkedHashMap();
    private Map m_oTestBlkMap = new LinkedHashMap();
    private Map m_oFaultBlkMap = new LinkedHashMap();
    private boolean m_bIncludeConfigInfo = false;
    private String m_sResolverBase = null;
    private String m_sRequiredCapability = null;
    private String[] m_aMessageFileList = null;

    public XTSObject(XTSEnvironment env, String name, boolean fromSource) throws XTSException {
        this.m_Name = name;
        this.initialize(env, fromSource);
    }

    public String getName() {
        return this.m_Name;
    }

    public XTSBlock getExecBlock(String id) {
        return (XTSBlock)this.m_oExecBlkMap.get(id);
    }

    public XTSBlock getTestBlock(String id) {
        return (XTSBlock)this.m_oTestBlkMap.get(id);
    }

    public XTSBlock getFaultBlock(String id) {
        return (XTSBlock)this.m_oFaultBlkMap.get(id);
    }

    public void compile(XTSEnvironment env, String baseDebugDumpDir, StopWatchTimer timer) throws XTSException {
        IXTSLogger traceLogger2 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger2 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger2.log(env, 4, "Compile", null, null);
        }
        int count = 0;
        Iterator execblkite = this.m_oExecBlkMap.values().iterator();
        XTSBlock block2 = null;
        while (execblkite.hasNext()) {
            block2 = (XTSBlock)execblkite.next();
            String debugdir = null;
            if ((env.getMode() & 2) > 0) {
                StringBuffer tmp = new StringBuffer();
                tmp.append(baseDebugDumpDir);
                tmp.append(File.separatorChar);
                tmp.append(XTSDebugManager.getInstance().generateDirName(count, "block", block2.getId()));
                debugdir = tmp.toString();
            }
            block2.compile(env, debugdir, timer);
            ++count;
        }
        for (XTSBlock block2 : this.m_oTestBlkMap.values()) {
            String debugdir = null;
            if ((env.getMode() & 2) > 0) {
                StringBuffer tmp = new StringBuffer();
                tmp.append(baseDebugDumpDir);
                tmp.append(File.separatorChar);
                tmp.append(XTSDebugManager.getInstance().generateDirName(count, "block", block2.getId()));
                debugdir = tmp.toString();
            }
            block2.compile(env, debugdir, timer);
            ++count;
        }
        for (XTSBlock block2 : this.m_oFaultBlkMap.values()) {
            String debugdir = null;
            if ((env.getMode() & 2) > 0) {
                StringBuffer tmp = new StringBuffer();
                tmp.append(baseDebugDumpDir);
                tmp.append(File.separatorChar);
                tmp.append(XTSDebugManager.getInstance().generateDirName(count, "block", block2.getId()));
                debugdir = tmp.toString();
            }
            block2.compile(env, debugdir, timer);
            ++count;
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger2 != null) {
            traceLogger2.log(env, 5, "Compile", null, null);
        }
    }

    public void execute(XTSEnvironment env, Document rootDoc, StopWatchTimer timer) throws XTSException {
        IXTSLogger traceLogger2 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger2 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger2.log(env, 4, "Execute", null, null);
        }
        this.checkRequiredCapabilities(env, rootDoc, this.m_sRequiredCapability);
        XTSBlockOrganizer organizer = null;
        try {
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger2 != null) {
                traceLogger2.log(env, 2, "XTSBlockOrganizer", null, null);
            }
            organizer = new XTSBlockOrganizer(this.m_oSortedExecBlkArray, this.m_oExecBlkMap, this.m_oTestBlkMap, this.m_oFaultBlkMap, this, timer);
            organizer.start(rootDoc, env);
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger2 != null) {
                traceLogger2.log(env, 3, "XTSBlockOrganizer", null, null);
            }
        }
        catch (XTSException e) {
            Object[] args = new String[]{this.m_Name};
            throw new XTSException("object.organizercreationfailed", args, e);
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger2 != null) {
            traceLogger2.log(env, 5, "Execute", null, null);
        }
    }

    private void checkRequiredCapabilities(XTSEnvironment env, Document rootDoc, String requiredCapabilities) throws XTSException {
        if (requiredCapabilities == null) {
            return;
        }
        RequiredCapabilities rc = new RequiredCapabilities(env, requiredCapabilities, true);
        boolean hasCapability = rc.hasCapabilities(env.getUserCapabilities());
        if (!hasCapability) {
            Object[] args = new String[]{this.m_Name};
            throw new XTSException("object.missingcapability", args);
        }
    }

    public String toString() {
        StringBuffer sRet = new StringBuffer(4096);
        sRet.append("<");
        sRet.append("xts");
        sRet.append(":");
        sRet.append(MORPHLET);
        sRet.append(" xmlns:");
        sRet.append("xts");
        sRet.append("=\"");
        sRet.append("http://developer.cognos.com/schemas/xts/");
        sRet.append("\"");
        if (this.m_aMessageFileList != null && this.m_aMessageFileList.length > 0) {
            sRet.append(" ");
            sRet.append(MESSAGES);
            sRet.append("=\"");
            sRet.append(this.m_aMessageFileList[0]);
            for (int i = 1; i < this.m_aMessageFileList.length; ++i) {
                sRet.append(",");
                sRet.append(this.m_aMessageFileList[i]);
            }
            sRet.append("\"");
        }
        if (this.m_bIncludeConfigInfo) {
            sRet.append(" ");
            sRet.append(INCLUDECONFIG);
            sRet.append("=\"true\"");
        }
        if (this.m_sResolverBase != null) {
            sRet.append(" ");
            sRet.append(RESOLVERBASE);
            sRet.append("=\"");
            sRet.append(this.m_sResolverBase);
            sRet.append("\"");
        }
        if (this.m_sRequiredCapability != null) {
            sRet.append(" ");
            sRet.append(REQUIREDCAPABILITY);
            sRet.append("=\"");
            sRet.append(this.m_sRequiredCapability);
            sRet.append("\"");
        }
        sRet.append(">");
        Iterator execblkite = this.m_oExecBlkMap.values().iterator();
        while (execblkite.hasNext()) {
            sRet.append(((XTSBlock)execblkite.next()).toString());
        }
        Iterator testblkite = this.m_oTestBlkMap.values().iterator();
        while (testblkite.hasNext()) {
            sRet.append(((XTSBlock)testblkite.next()).toString());
        }
        Iterator faultblkite = this.m_oFaultBlkMap.values().iterator();
        while (faultblkite.hasNext()) {
            sRet.append(((XTSBlock)faultblkite.next()).toString());
        }
        sRet.append("</");
        sRet.append("xts");
        sRet.append(":");
        sRet.append(MORPHLET);
        sRet.append(">");
        return sRet.toString();
    }

    private void initialize(XTSEnvironment env, boolean fromSource) throws XTSException {
        Element rootele;
        String sIncludeConfigInfo;
        IXTSLogger traceLogger3 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger3.log(env, 4, "Initialize", null, null);
        }
        if ((sIncludeConfigInfo = (rootele = this.loadTemplate(env, fromSource)).attributeValue(INCLUDECONFIG)) != null && sIncludeConfigInfo.equals(Boolean.TRUE.toString())) {
            this.m_bIncludeConfigInfo = true;
        }
        this.m_sResolverBase = rootele.attributeValue(RESOLVERBASE);
        if (this.m_sResolverBase != null && this.m_sResolverBase.startsWith("/")) {
            this.m_sResolverBase = this.m_sResolverBase.substring("/".length());
        }
        this.m_sRequiredCapability = rootele.attributeValue(REQUIREDCAPABILITY);
        this.createBlockLists(env, rootele);
        this.m_oSortedExecBlkArray = XTSObject.sortBlockMap(this.m_oExecBlkMap, this.m_Name);
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
            traceLogger3.log(env, 5, "Initialize", null, null);
        }
    }

    private String[] generateMessageFileList(String msgFileList) throws XTSException {
        if (msgFileList == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(msgFileList, ",");
        String[] messageFileList = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            messageFileList[i] = st.nextToken().trim();
            ++i;
        }
        return messageFileList;
    }

    private void createBlockLists(XTSEnvironment env, Element morphlet) throws XTSException {
        this.m_oExecBlkMap = new LinkedHashMap();
        this.m_oTestBlkMap = new LinkedHashMap();
        this.m_oFaultBlkMap = new LinkedHashMap();
        this.m_aMessageFileList = this.generateMessageFileList(morphlet.attributeValue(MESSAGES));
        List nsList = morphlet.additionalNamespaces();
        List eleList = morphlet.elements(XTSBlock.XTS_BLOCK_QNAME);
        Element blkele = null;
        XTSBlock oBlk = null;
        Namespace ns = null;
        List blkNSList = null;
        Namespace blkNS = null;
        for (int i = 0; i < eleList.size(); ++i) {
            blkele = (Element)eleList.get(i);
            blkele.detach();
            blkNSList = blkele.declaredNamespaces();
            blkNSList.add(blkele.getNamespace());
            for (int k = 0; k < nsList.size(); ++k) {
                ns = (Namespace)nsList.get(k);
                boolean bFound = false;
                for (int j = 0; j < blkNSList.size() && !bFound; ++j) {
                    blkNS = (Namespace)blkNSList.get(j);
                    if (!blkNS.getPrefix().equals(ns.getPrefix())) continue;
                    bFound = true;
                }
                if (bFound) continue;
                blkele = blkele.addNamespace(ns.getPrefix(), ns.getURI());
            }
            try {
                oBlk = new XTSBlock(env, this, blkele, this.m_aMessageFileList);
                if (oBlk.getType() == 1) {
                    this.m_oTestBlkMap.put(oBlk.getId(), oBlk);
                    continue;
                }
                if (oBlk.getType() == 2) {
                    this.m_oFaultBlkMap.put(oBlk.getId(), oBlk);
                    continue;
                }
                this.m_oExecBlkMap.put(oBlk.getId(), oBlk);
                continue;
            }
            catch (XTSException e) {
                Object[] args = new String[]{this.m_Name};
                throw new XTSException("object.blockcreationfailed", args, e);
            }
        }
    }

    protected static ArrayList sortBlockMap(Map blkmap, String name) throws XTSException {
        if (blkmap.size() > 0) {
            ArrayList tempBlockList = new ArrayList();
            for (Map.Entry e : blkmap.entrySet()) {
                tempBlockList.add(e.getValue());
            }
            LinkedHashMap<String, XTSBlock> reverse_blkmap = new LinkedHashMap<String, XTSBlock>();
            for (int i = tempBlockList.size() - 1; i >= 0; --i) {
                XTSBlock blk = (XTSBlock)tempBlockList.get(i);
                reverse_blkmap.put(blk.getId(), blk);
            }
            blkmap = reverse_blkmap;
        }
        Scheduler oScheduler = new Scheduler();
        ArrayList<String> dependencyList = new ArrayList<String>();
        for (Map.Entry entry : blkmap.entrySet()) {
            XTSBlock blk;
            String id = (String)entry.getKey();
            if (!oScheduler.addTask(id, blk = (XTSBlock)entry.getValue())) {
                Object[] args = new String[]{id, name};
                throw new XTSException("object.duplicateblockid", args);
            }
            String sDependency = blk.getDependency();
            if (sDependency == null || sDependency.length() <= 0) continue;
            sDependency = id + " " + sDependency;
            dependencyList.add(sDependency);
        }
        for (int i = 0; i < dependencyList.size(); ++i) {
            StringTokenizer st = new StringTokenizer((String)dependencyList.get(i));
            String sChildId = st.nextToken();
            while (st.hasMoreTokens()) {
                String sParentId = st.nextToken();
                if (oScheduler.addDependency(sChildId, sParentId)) continue;
                Object[] args = new String[]{sChildId, name};
                throw new XTSException("object.invaliddependency", args);
            }
        }
        oScheduler.compile();
        if (oScheduler.isCyclic()) {
            Object[] args = new String[]{oScheduler.getCyclicKeyList().toString(), name};
            throw new XTSException("object.cyclicblockdependency", args);
        }
        return oScheduler.getSortedObjList();
    }

    private Element loadTemplate(XTSEnvironment env, boolean fromSource) throws XTSException {
        IXTSLogger traceLogger4;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger4 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger4.log(env, 8, "load template: " + this.m_Name + " from: " + (fromSource ? "Tempate" : "JAR"), null, null);
        }
        InputStream is = null;
        is = fromSource ? XTSResourceManager.getInstance().getResourceFromTemplates(this.m_Name) : XTSResourceManager.getInstance().getResource(this.m_Name);
        if (is == null) {
            Object[] args = new String[]{this.m_Name, env.getLocale().getDisplayName()};
            throw new XTSException("object.creationfailed", args);
        }
        AXTSPoolObject reader = null;
        try {
            reader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            Object[] args = new String[]{this.m_Name, env.getLocale().getDisplayName()};
            throw new XTSException("object.creationfailed", args, e);
        }
        Document doc = null;
        try {
            doc = ((SAXReader)reader.get()).read(new InputSource(is));
        }
        catch (Exception e) {
            Object[] args = new String[]{this.m_Name, env.getLocale().getDisplayName()};
            throw new XTSException("object.creationfailed", args, e);
        }
        finally {
            XTSSAXReaderPool.getInstance().put(reader);
        }
        Element rootele = doc.getRootElement();
        if (!rootele.getName().equals(MORPHLET)) {
            Object[] args = new String[]{rootele.getName()};
            throw new XTSException("object.invalidrootelement", args);
        }
        if (!rootele.getNamespaceURI().equals("http://developer.cognos.com/schemas/xts/")) {
            Object[] args = new String[]{rootele.getNamespaceURI()};
            throw new XTSException("object.invalidnamespaceuri", args);
        }
        return rootele;
    }

    public boolean isIncludeConfigInfo() {
        return this.m_bIncludeConfigInfo;
    }

    public String getResolverBase() {
        return this.m_sResolverBase;
    }
}

