/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSObject;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.LocaleUtils;
import com.cognos.xts.util.XTSObjectCache;
import java.util.List;
import java.util.Locale;

public final class XTSObjectFactory {
    private static final String CACHE_SIZE_PROPERTY_NAME = "templatecache.size";
    private static XTSObjectCache m_oObjCache = new XTSObjectCache();
    private static Object m_oMutexObj = new Object();

    public static void initialize() throws XTSException {
        IXTSLogger traceLogger2;
        String sCacheSize = PropertiesManager.getInstance().getProperty(CACHE_SIZE_PROPERTY_NAME);
        if (sCacheSize != null) {
            try {
                int iCacheSize = Integer.parseInt(sCacheSize);
                m_oObjCache.setCacheSize(iCacheSize);
            }
            catch (NumberFormatException e) {
                throw new XTSException("objectfactory.cacheinitfailed", e);
            }
            catch (InterruptedException e) {
                throw new XTSException("objectfactory.cacheinitfailed", e);
            }
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (traceLogger2 = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            traceLogger2.log(null, 0, "XTSObjectFactory", null, null);
        }
    }

    public static void terminate() throws XTSException {
        IXTSLogger traceLogger2;
        try {
            m_oObjCache.clearCache();
        }
        catch (InterruptedException e) {
            throw new XTSException("objectfactory.cachetermfailed", e);
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (traceLogger2 = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            traceLogger2.log(null, 1, "XTSObjectFactory", null, null);
        }
    }

    public static void reinitialize() throws XTSException {
        XTSObjectFactory.terminate();
        XTSObjectFactory.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XTSObject getXTSObject(XTSEnvironment env, String name) throws XTSException {
        XTSObject oObj;
        IXTSLogger traceLogger3;
        block14: {
            traceLogger3 = null;
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                traceLogger3.log(env, 4, "XTSObjectFactory - getXTSObject", null, null);
            }
            oObj = null;
            try {
                String sKey = XTSObjectFactory.generateCacheKey(env.getLocale(), name);
                oObj = (XTSObject)m_oObjCache.getObject(sKey);
                if (oObj != null) break block14;
                Object object = m_oMutexObj;
                synchronized (object) {
                    oObj = (XTSObject)m_oObjCache.getObject(sKey);
                    if (oObj == null) {
                        try {
                            try {
                                oObj = new XTSObject(env, name, false);
                            }
                            catch (XTSException e) {
                                if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                                    traceLogger3.log(env, 2, "XTSObjectFactory - createObject", null, null);
                                }
                                oObj = new XTSObject(env, name, true);
                                if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                                    traceLogger3.log(env, 3, "XTSObjectFactory - createObject", null, null);
                                }
                            }
                        }
                        catch (XTSException e) {
                            throw new XTSException("objectfactory.objectcreationfailure", e);
                        }
                        m_oObjCache.addObject(sKey, oObj);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new XTSException("objectfactory.lockinterrupted", e);
            }
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
            traceLogger3.log(env, 5, "XTSObjectFactory - getXTSObject", null, null);
        }
        return oObj;
    }

    private static String generateCacheKey(Locale locale, String name) {
        if (name.startsWith("/")) {
            return LocaleUtils.toJavaString(locale) + "-" + name.substring("/".length());
        }
        return LocaleUtils.toJavaString(locale) + "-" + name;
    }

    public static void preload(XTSEnvironment env, List names) {
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            try {
                env.setMorphletName(name);
                XTSObjectFactory.getXTSObject(env, name);
                continue;
            }
            catch (XTSException e) {
                System.out.println("Object factory initialization failed (" + name + ").");
            }
        }
    }
}

