/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts;

import com.cognos.xts.UXTSExceptionUtils;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSObject;
import com.cognos.xts.XTSObjectFactory;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.baltic.request.CMTemplateFactory;
import com.cognos.xts.capability.XTSCapabilityFactory;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.compiler.logicsheet.XTSLogicsheetTransfomer;
import com.cognos.xts.compiler.message.XTSMessageTransformer;
import com.cognos.xts.configinfo.IXTSCacheConfigInfo;
import com.cognos.xts.configinfo.XTSConfigInfoFactory;
import com.cognos.xts.configuration.IXTSConfiguration;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.interpreter.instructions.function.XTSFunctionFactory;
import com.cognos.xts.interpreter.instructions.nodeop.XTSNodeOpFactory;
import com.cognos.xts.interpreter.instructions.request.XTSRequestFactory;
import com.cognos.xts.interpreter.instructions.transform.XTSTransformFactory;
import com.cognos.xts.logging.IXTSDebugLog;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSAuditLoggerManager;
import com.cognos.xts.logging.XTSDebugManager;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.messages.MessagesManager;
import com.cognos.xts.properties.IXTSPropertiesCallback;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.IXTSResourceReader;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.security.XTSSecurityFactory;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.RWLockManager;
import com.cognos.xts.util.StopWatchTimer;
import com.cognos.xts.validation.XTSValidatorFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class XTSProcessor {
    public static final String XTS_NAMESPACE_URI = "http://developer.cognos.com/schemas/xts/";
    public static final String XTS_NAMESPACE_PREFIX = "xts";
    public static final Namespace XTS_NAMESPACE = new Namespace("xts", "http://developer.cognos.com/schemas/xts/");
    public static final int MODE_TEST = 1;
    public static final int MODE_DEBUG = 2;
    public static final int MODE_RESTART = 4;
    public static final int MODE_END = 7;
    private static HashMap m_oProcessorMap = new HashMap();
    private static RWLockManager m_oProcessorMutex = new RWLockManager(new Object());
    private static final String PROPERTY_EXECWAITTIME = "processor.execwaittime";
    private static final String PROPERTY_ADMINPARTIALWAITTIME = "processor.adminpartialwaittime";
    private static final String PROPERTY_ADMINFULLWAITTIME = "processor.adminfullwaittime";
    private static final long DEFAULT_EXECWAITTIME = 240000L;
    private static final long DEFAULT_ADMINPARTIALWAITTIME = 60000L;
    private static final long DEFAULT_ADMINFULLWAITTIME = 15000L;
    private String m_id = null;
    private boolean m_debugEnable = false;
    private IXTSPropertiesCallback m_propCallback = null;
    private Properties m_props = null;
    private IXTSConfiguration m_config = null;
    private IXTSResourceReader m_reader = null;
    private RWLockManager m_oMutex = new RWLockManager(new Object());
    private long m_lInitializeCount = 0L;
    private boolean m_bInitialized = false;
    private boolean m_reinitInProgress = false;
    private long m_lExecWaitTime = 240000L;
    private long m_lAdminPartialWaitTime = 60000L;
    private long m_lAdminFullWaitTime = 15000L;

    public static XTSProcessor getInstance(String id) throws XTSException {
        XTSProcessor proc = null;
        try {
            m_oProcessorMutex.readLock();
            try {
                proc = (XTSProcessor)m_oProcessorMap.get(id);
            }
            finally {
                m_oProcessorMutex.releaseReadLock();
            }
            if (proc == null) {
                m_oProcessorMutex.writeLock();
                try {
                    proc = new XTSProcessor(id);
                    m_oProcessorMap.put(id, proc);
                }
                finally {
                    m_oProcessorMutex.releaseWriteLock();
                }
            }
            return proc;
        }
        catch (InterruptedException e) {
            throw new XTSException("processor.getInstanceFailed", e);
        }
    }

    private XTSProcessor(String id) {
        this.m_id = id;
    }

    private boolean tryInternalReadLock(long waittime) throws InterruptedException {
        return this.m_oMutex.internalReadLockWait(waittime) != null;
    }

    private boolean tryReadLock(long waittime) throws InterruptedException {
        return this.m_oMutex.readLockWait(waittime) != null;
    }

    private boolean tryWriteLock(long waittime) throws InterruptedException {
        return this.m_oMutex.writeLockWait(waittime) != null;
    }

    private synchronized boolean retryWriteLock(long waittime, boolean reinit) throws InterruptedException, XTSException {
        return this.m_oMutex.writeLockWait(waittime * 2L) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkConfig(IXTSConfiguration config) throws XTSException {
        try {
            if (!this.tryReadLock(this.m_lExecWaitTime)) {
                throw new XTSException("processor.pendingWriteLock");
            }
            try {
                if (!this.m_bInitialized) {
                    boolean bl = true;
                    return bl;
                }
                if (this.m_config == null || config == null || !this.m_config.equals(config)) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.m_oMutex.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            throw new XTSException("processor.checkconfigfailed", e);
        }
    }

    public void initialize(IXTSConfiguration config, IXTSResourceReader reader, IXTSPropertiesCallback callback, Properties props, boolean blocking) throws XTSException {
        if (blocking) {
            this.doInitialize(config, reader, callback, props);
        } else {
            _initThread init = new _initThread(this, config, reader, callback, props);
            init.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doInitialize(IXTSConfiguration config, IXTSResourceReader reader, IXTSPropertiesCallback callback, Properties props) throws XTSException {
        try {
            if (!this.tryReadLock(this.m_lExecWaitTime)) {
                throw new XTSException("processor.pendingWriteLock");
            }
            try {
                XTSProcessor xTSProcessor = this;
                synchronized (xTSProcessor) {
                    if (this.m_lInitializeCount > 0L) {
                        ++this.m_lInitializeCount;
                        return;
                    }
                }
            }
            finally {
                this.m_oMutex.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            throw new XTSException("processor.initfailed", e);
        }
        try {
            if (!this.tryWriteLock(this.m_lAdminFullWaitTime)) {
                boolean gotLock = false;
                try {
                    gotLock = this.retryWriteLock(this.m_lAdminFullWaitTime, false);
                }
                catch (XTSException e) {
                    throw new XTSException("processor.initfailed", e);
                }
                if (!gotLock) {
                    throw new XTSException("processor.pendingWriteLock");
                }
            }
            try {
                Object logger;
                XTSProcessor gotLock = this;
                synchronized (gotLock) {
                    if (this.m_lInitializeCount > 0L) {
                        ++this.m_lInitializeCount;
                        return;
                    }
                }
                this.m_config = config;
                this.m_reader = reader;
                this.m_propCallback = callback;
                this.m_props = props;
                XTSConfigManager.getInstance().initialize(this.m_config);
                XTSResourceManager.getInstance().initialize(this.m_reader);
                PropertiesManager.getInstance().initialize(this.m_propCallback, this.m_props);
                XTSTraceLoggerManager.getInstance().initialize();
                XTSPerfLoggerManager.getInstance().initialize();
                XTSAuditLoggerManager.getInstance().initialize();
                IXTSLogger traceLogger3 = null;
                if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
                    traceLogger3.log(null, 0, "Staring XTSProcessor", null, null);
                }
                try {
                    MessagesManager.getInstance().initialize();
                    XTSSAXReaderPool.getInstance().initialize();
                    XTSSAXParserPool.getInstance().initialize();
                    XTSDebugManager.getInstance().initialize();
                    this.m_debugEnable = XTSDebugManager.getInstance().getLogger().isEnabled();
                    XTSSecurityFactory.getInstance().initialize();
                    XTSCapabilityFactory.getInstance().initialize();
                    XTSValidatorFactory.getInstance().initialize();
                    XTSMessageTransformer.initialize();
                    if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                        traceLogger3.log(null, 0, "XTSMessageTransformer started", null, null);
                    }
                    XTSLogicsheetTransfomer.initialize();
                    if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                        traceLogger3.log(null, 0, "XTSLogicsheetTransfomer started", null, null);
                    }
                    XTSObjectFactory.initialize();
                    if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                        traceLogger3.log(null, 0, "XTSObjectFactory started", null, null);
                    }
                    XTSApplicationManager.getInstance().initialize();
                    if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                        traceLogger3.log(null, 0, "XTSApplicationManager started", null, null);
                    }
                    XTSNodeOpFactory.getInstance().initialize();
                    XTSTransformFactory.getInstance().initialize();
                    XTSFunctionFactory.getInstance().initialize();
                    XTSRequestFactory.getInstance().initialize();
                    XTSConfigInfoFactory.getInstance().initialize();
                    CMTemplateFactory.getInstance().initialize();
                }
                catch (XTSException e) {
                    IXTSLogger traceLogger1 = null;
                    if (XTSTraceLoggerManager.getInstance().isEnabled[0][0] && (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) != null) {
                        traceLogger1.log(null, 0, "XTSProcessor fail to start: " + e.getLocalizedMsgString(Locale.getDefault()), null, null);
                    }
                    XTSProcessor xTSProcessor = this;
                    synchronized (xTSProcessor) {
                        this.m_lInitializeCount = 0L;
                        throw e;
                    }
                }
                IXTSLogger traceLogger2 = null;
                if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (traceLogger2 = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
                    traceLogger2.log(null, 0, "XTSProcessor started", null, null);
                }
                if (XTSAuditLoggerManager.getInstance().isEnabled[0][0] && (logger = XTSAuditLoggerManager.getInstance().getLogger(0, 0)) != null) {
                    logger.log(null, 0, "success", "", null);
                }
                logger = this;
                synchronized (logger) {
                    this.m_lInitializeCount = 1L;
                }
                this.m_lExecWaitTime = 240000L;
                String sExecWaitTime = PropertiesManager.getInstance().getProperty(PROPERTY_EXECWAITTIME);
                if (sExecWaitTime != null) {
                    try {
                        this.m_lExecWaitTime = Long.parseLong(sExecWaitTime);
                    }
                    catch (NumberFormatException e) {
                        this.m_lExecWaitTime = 240000L;
                    }
                }
                this.m_lAdminPartialWaitTime = 60000L;
                String sAdminPartialWaitTime = PropertiesManager.getInstance().getProperty(PROPERTY_ADMINPARTIALWAITTIME);
                if (sAdminPartialWaitTime != null) {
                    try {
                        this.m_lAdminPartialWaitTime = Long.parseLong(sAdminPartialWaitTime);
                    }
                    catch (NumberFormatException e) {
                        this.m_lAdminPartialWaitTime = 60000L;
                    }
                }
                this.m_lAdminFullWaitTime = 15000L;
                String sAdminFullWaitTime = PropertiesManager.getInstance().getProperty(PROPERTY_ADMINFULLWAITTIME);
                if (sAdminFullWaitTime != null) {
                    try {
                        this.m_lAdminFullWaitTime = Long.parseLong(sAdminFullWaitTime);
                    }
                    catch (NumberFormatException e) {
                        this.m_lAdminFullWaitTime = 15000L;
                    }
                }
                this.m_bInitialized = true;
                return;
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            throw new XTSException("processor.initfailed", e);
        }
    }

    public void terminate(boolean blocking) throws XTSException {
        if (blocking) {
            this.doTerminate();
        } else {
            _terminateThread term = new _terminateThread(this);
            term.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doTerminate() throws XTSException {
        try {
            if (!this.tryReadLock(this.m_lExecWaitTime)) {
                throw new XTSException("processor.pendingWriteLock");
            }
            try {
                XTSProcessor xTSProcessor = this;
                synchronized (xTSProcessor) {
                    if (this.m_lInitializeCount > 1L) {
                        --this.m_lInitializeCount;
                        return;
                    }
                }
            }
            finally {
                this.m_oMutex.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            throw new XTSException("processor.termfailed", e);
        }
        try {
            if (!this.tryWriteLock(this.m_lAdminFullWaitTime)) {
                boolean gotLock = false;
                try {
                    gotLock = this.retryWriteLock(this.m_lAdminFullWaitTime, false);
                }
                catch (XTSException e) {
                    throw new XTSException("processor.termfailed", e);
                }
                if (!gotLock) {
                    throw new XTSException("processor.pendingWriteLock");
                }
            }
            try {
                IXTSLogger logger;
                XTSProcessor gotLock = this;
                synchronized (gotLock) {
                    if (this.m_lInitializeCount > 1L) {
                        --this.m_lInitializeCount;
                        return;
                    }
                }
                this.m_config = null;
                this.m_reader = null;
                this.m_propCallback = null;
                this.m_props = null;
                IXTSLogger traceLogger3 = null;
                if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
                    traceLogger3.log(null, 1, "Stopping XTSProcessor", null, null);
                }
                try {
                    MessagesManager.getInstance().terminate();
                    XTSSAXReaderPool.getInstance().terminate();
                    XTSSAXParserPool.getInstance().terminate();
                    XTSDebugManager.getInstance().terminate();
                    XTSSecurityFactory.getInstance().terminate();
                    XTSCapabilityFactory.getInstance().terminate();
                    XTSValidatorFactory.getInstance().terminate();
                    XTSMessageTransformer.terminate();
                    if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                        traceLogger3.log(null, 1, "XTSMessageTransformer stopped", null, null);
                    }
                    XTSLogicsheetTransfomer.terminate();
                    if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                        traceLogger3.log(null, 1, "XTSLogicsheetTransfomer stopped", null, null);
                    }
                    XTSObjectFactory.terminate();
                    if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                        traceLogger3.log(null, 1, "XTSObjectFactory stopped", null, null);
                    }
                    XTSApplicationManager.getInstance().terminate();
                    if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                        traceLogger3.log(null, 1, "XTSApplicationManager stopped", null, null);
                    }
                    XTSNodeOpFactory.getInstance().terminate();
                    XTSTransformFactory.getInstance().terminate();
                    XTSFunctionFactory.getInstance().terminate();
                    XTSRequestFactory.getInstance().terminate();
                    XTSConfigInfoFactory.getInstance().terminate();
                    CMTemplateFactory.getInstance().terminate();
                }
                catch (XTSException e) {
                    IXTSLogger traceLogger1 = null;
                    if (XTSTraceLoggerManager.getInstance().isEnabled[0][0] && (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) != null) {
                        traceLogger1.log(null, 1, "XTSProcessor fail to stop: " + e.getLocalizedMsgString(Locale.getDefault()), null, null);
                    }
                    XTSProcessor xTSProcessor = this;
                    synchronized (xTSProcessor) {
                        this.m_lInitializeCount = 0L;
                    }
                    this.m_bInitialized = false;
                    throw e;
                }
                IXTSLogger traceLogger2 = null;
                if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (traceLogger2 = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
                    traceLogger2.log(null, 1, "XTSProcessor stopped", null, null);
                }
                if (XTSAuditLoggerManager.getInstance().isEnabled[0][0] && (logger = XTSAuditLoggerManager.getInstance().getLogger(0, 0)) != null) {
                    logger.log(null, 1, "success", "", null);
                }
                XTSTraceLoggerManager.getInstance().terminate();
                XTSPerfLoggerManager.getInstance().terminate();
                XTSAuditLoggerManager.getInstance().terminate();
                PropertiesManager.getInstance().terminate();
                XTSResourceManager.getInstance().terminate();
                XTSConfigManager.getInstance().terminate();
                XTSProcessor xTSProcessor = this;
                synchronized (xTSProcessor) {
                    this.m_lInitializeCount = 0L;
                }
                this.m_lExecWaitTime = 240000L;
                this.m_lAdminPartialWaitTime = 60000L;
                this.m_lAdminFullWaitTime = 15000L;
                this.m_bInitialized = false;
                return;
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            throw new XTSException("processor.initfailed", e);
        }
    }

    public void reinitialize(IXTSConfiguration config, IXTSResourceReader reader, IXTSPropertiesCallback callback, Properties props, boolean full, boolean blocking) throws XTSException {
        if (blocking) {
            this.doReinitialize(config, reader, callback, props, full);
        } else {
            _reinitThread reinit = new _reinitThread(this, config, reader, callback, props, full);
            reinit.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReinitialize(IXTSConfiguration config, IXTSResourceReader reader, IXTSPropertiesCallback callback, Properties props, boolean full) throws XTSException {
        long waittime = this.m_lAdminPartialWaitTime;
        if (full) {
            waittime = this.m_lAdminFullWaitTime;
        }
        try {
            block43: {
                XTSProcessor xTSProcessor = this;
                synchronized (xTSProcessor) {
                    block41: {
                        if (full) break block43;
                        if (!this.m_reinitInProgress) break block41;
                        return;
                    }
                    this.m_reinitInProgress = true;
                }
            }
            if (!this.tryWriteLock(waittime)) {
                boolean gotLock = false;
                try {
                    gotLock = this.retryWriteLock(waittime, true);
                }
                catch (XTSException e) {
                    throw new XTSException("processor.reinitfailed", e);
                }
                if (!gotLock) {
                    throw new XTSException("processor.pendingWriteLock");
                }
            }
            try {
                IXTSLogger logger;
                String auditLogMsg;
                int auditLevel;
                if (!this.m_bInitialized) {
                    throw new XTSException("processor.reinitfailed");
                }
                this.m_config = config;
                this.m_reader = reader;
                this.m_propCallback = callback;
                this.m_props = props;
                XTSConfigManager.getInstance().reinitialize(this.m_config);
                XTSResourceManager.getInstance().reinitialize(this.m_reader);
                PropertiesManager.getInstance().reinitialize(this.m_propCallback, this.m_props);
                XTSTraceLoggerManager.getInstance().reinitialize();
                XTSPerfLoggerManager.getInstance().reinitialize();
                XTSAuditLoggerManager.getInstance().reinitialize();
                IXTSLogger traceLogger3 = null;
                if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
                    traceLogger3.log(null, 0, "Restaring XTSProcessor", null, null);
                }
                try {
                    if (full) {
                        MessagesManager.getInstance().reinitialize();
                        XTSSAXReaderPool.getInstance().reinitialize();
                        XTSSAXParserPool.getInstance().reinitialize();
                        XTSDebugManager.getInstance().reinitialize();
                        this.m_debugEnable = XTSDebugManager.getInstance().getLogger().isEnabled();
                        XTSNodeOpFactory.getInstance().reinitialize();
                        XTSTransformFactory.getInstance().reinitialize();
                        XTSFunctionFactory.getInstance().reinitialize();
                        XTSRequestFactory.getInstance().reinitialize();
                        XTSSecurityFactory.getInstance().reinitialize();
                        XTSCapabilityFactory.getInstance().reinitialize();
                        XTSValidatorFactory.getInstance().reinitialize();
                        XTSMessageTransformer.reinitialize();
                        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                            traceLogger3.log(null, 0, "XTSMessageTransformer restarted", null, null);
                        }
                        XTSLogicsheetTransfomer.reinitialize();
                        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                            traceLogger3.log(null, 0, "XTSLogicsheetTransfomer restarted", null, null);
                        }
                        XTSObjectFactory.reinitialize();
                        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                            traceLogger3.log(null, 0, "XTSObjectFactory restarted", null, null);
                        }
                        XTSApplicationManager.getInstance().reinitialize();
                        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && traceLogger3 != null) {
                            traceLogger3.log(null, 0, "XTSApplicationManager restarted", null, null);
                        }
                        CMTemplateFactory.getInstance().reinitialize();
                    }
                    XTSConfigInfoFactory.getInstance().reinitialize();
                }
                catch (XTSException e) {
                    IXTSLogger traceLogger1 = null;
                    if (XTSTraceLoggerManager.getInstance().isEnabled[0][0] && (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) != null) {
                        traceLogger1.log(null, 0, "XTSProcessor fail to start: " + e.getLocalizedMsgString(Locale.getDefault()), null, null);
                    }
                    throw e;
                }
                IXTSLogger traceLogger2 = null;
                if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (traceLogger2 = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
                    traceLogger2.log(null, 0, "XTSProcessor restarted", null, null);
                }
                Locale serverLocale = XTSConfigManager.getInstance().getServerLocale();
                if (full) {
                    auditLevel = 0;
                    auditLogMsg = MessagesManager.getInstance().getMessage(serverLocale, "processor.reinitFull");
                } else {
                    auditLevel = 3;
                    auditLogMsg = MessagesManager.getInstance().getMessage(serverLocale, "processor.reinitPartial");
                }
                if (XTSAuditLoggerManager.getInstance().isEnabled[auditLevel][0] && (logger = XTSAuditLoggerManager.getInstance().getLogger(auditLevel, 0)) != null) {
                    logger.log(null, 5, "success", auditLogMsg, null);
                }
                this.m_lExecWaitTime = 240000L;
                String sExecWaitTime = PropertiesManager.getInstance().getProperty(PROPERTY_EXECWAITTIME);
                if (sExecWaitTime != null) {
                    try {
                        this.m_lExecWaitTime = Long.parseLong(sExecWaitTime);
                    }
                    catch (NumberFormatException e) {
                        this.m_lExecWaitTime = 240000L;
                    }
                }
                this.m_lAdminPartialWaitTime = 60000L;
                String sAdminPartialWaitTime = PropertiesManager.getInstance().getProperty(PROPERTY_ADMINPARTIALWAITTIME);
                if (sAdminPartialWaitTime != null) {
                    try {
                        this.m_lAdminPartialWaitTime = Long.parseLong(sAdminPartialWaitTime);
                    }
                    catch (NumberFormatException e) {
                        this.m_lAdminPartialWaitTime = 60000L;
                    }
                }
                this.m_lAdminFullWaitTime = 15000L;
                String sAdminFullWaitTime = PropertiesManager.getInstance().getProperty(PROPERTY_ADMINFULLWAITTIME);
                if (sAdminFullWaitTime != null) {
                    try {
                        this.m_lAdminFullWaitTime = Long.parseLong(sAdminFullWaitTime);
                    }
                    catch (NumberFormatException e) {
                        this.m_lAdminFullWaitTime = 15000L;
                    }
                }
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            throw new XTSException("processor.initfailed", e);
        }
        finally {
            this.m_reinitInProgress = false;
        }
    }

    public void execute(String morphlet, Document rootDoc, XTSEnvironment env) throws XTSException {
        this.execute(morphlet, rootDoc, env, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String morphlet, Document rootDoc, XTSEnvironment env, boolean internal) throws XTSException {
        if ((env.getMode() & 4) > 0) {
            this.reinitialize(this.m_config, this.m_reader, this.m_propCallback, this.m_props, true, true);
        }
        env.setupUserCapabilities(null, rootDoc);
        if (morphlet == null || morphlet.length() == 0) {
            throw new XTSException("processor.missingpage");
        }
        try {
            if (internal ? !this.tryInternalReadLock(this.m_lExecWaitTime) : !this.tryReadLock(this.m_lExecWaitTime)) {
                throw new XTSException("processor.pendingWriteLock");
            }
            try {
                IXTSLogger traceLogger2;
                block56: {
                    if (!this.m_bInitialized) {
                        throw new XTSException("processor.notinitialize");
                    }
                    IXTSLogger pLogger1 = null;
                    if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger1 = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        pLogger1.log(env, 6, this.getClass().getName(), "execute", "Start prepare xts root document");
                        pLogger1.starttimer();
                    }
                    traceLogger2 = null;
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger2 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        traceLogger2.log(env, 4, "XTSProccessor - execute", null, null);
                    }
                    IXTSLogger traceLogger5 = null;
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        traceLogger5.log(env, 8, "morphlet: " + morphlet, null, null);
                        traceLogger5.log(env, 8, "rootDoc: " + rootDoc.asXML(), null, null);
                    }
                    if (!this.m_debugEnable) {
                        env.setMode(env.getMode() & 0xFFFFFFFD);
                    } else if (XTSDebugManager.getInstance().getLogger().isDebugAll()) {
                        env.setMode(env.getMode() | 2);
                    } else if (XTSDebugManager.getInstance().getLogger().isLightweight() && XTSDebugManager.getInstance().getLogger().logForMorphlet(morphlet)) {
                        env.setMode(env.getMode() | 2);
                    }
                    int mode = env.getMode();
                    if (mode > 7) {
                        throw new XTSException("processor.invalidmode");
                    }
                    this.addDebugElement(env, mode, morphlet, rootDoc);
                    StopWatchTimer timer = null;
                    if ((mode & 2) > 0) {
                        timer = new StopWatchTimer();
                        timer.start();
                    }
                    if (pLogger1 != null) {
                        pLogger1.stoptimer();
                        pLogger1.log(env, 1, this.getClass().getName(), "execute", "Completed prepare xts root document: " + (env.getMorphletName() == null ? "" : env.getMorphletName()));
                    }
                    try {
                        IXTSDebugLog debuglogger;
                        IXTSLogger pLogger2 = null;
                        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger2 = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                            pLogger2.log(env, 6, this.getClass().getName(), "execute", "Start loading XTSObject");
                            pLogger2.starttimer();
                        }
                        IXTSLogger traceLogger3 = null;
                        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                            traceLogger3.log(env, 2, "XTSObjectFactory - getXTSObject", null, null);
                        }
                        XTSObject obj = XTSObjectFactory.getXTSObject(env, morphlet);
                        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                            traceLogger3.log(env, 3, "XTSObjectFactory - getXTSObject", null, null);
                        }
                        if (pLogger2 != null) {
                            pLogger2.stoptimer();
                            pLogger2.log(env, 1, this.getClass().getName(), "execute", "Completed loading XTSObject: " + (env.getMorphletName() == null ? "" : env.getMorphletName()));
                        }
                        IXTSLogger pLogger3 = null;
                        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger3 = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                            pLogger3.log(env, 6, this.getClass().getName(), "execute", "Start adding configuration info onto root document");
                            pLogger3.starttimer();
                        }
                        IXTSCacheConfigInfo info = (IXTSCacheConfigInfo)((Object)XTSConfigInfoFactory.getInstance().getObject(env, null));
                        try {
                            Element configProps;
                            Element ele;
                            if (obj.isIncludeConfigInfo() && (ele = info.getConfigInfo(env, null)) != null) {
                                rootDoc.getRootElement().add(ele.createCopy());
                            }
                            if ((configProps = info.getConfigProperties(env, null)) != null) {
                                rootDoc.getRootElement().add(configProps.createCopy());
                            }
                        }
                        finally {
                            info.release();
                        }
                        if ((mode & 2) > 0) {
                            timer.pause();
                            debuglogger = XTSDebugManager.getInstance().getLogger();
                            if (debuglogger != null) {
                                debuglogger.log(env, env.getDebugRequestPath(), "input.xml", rootDoc);
                            }
                            timer.unpause();
                        }
                        if (pLogger3 != null) {
                            pLogger3.stoptimer();
                            pLogger3.log(env, 1, this.getClass().getName(), "execute", "Completed adding configuration info onto root document: " + (env.getMorphletName() == null ? "" : env.getMorphletName()));
                        }
                        if (obj != null) {
                            if ((mode & 2) > 0) {
                                timer.pause();
                                debuglogger = XTSDebugManager.getInstance().getLogger();
                                if (debuglogger != null) {
                                    debuglogger.log(env, env.getDebugRequestPath(), "source.xml", obj.toString());
                                }
                                timer.unpause();
                            }
                            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                                traceLogger3.log(env, 2, "XTSObject - execute", null, null);
                            }
                            obj.execute(env, rootDoc, timer);
                            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                                traceLogger3.log(env, 3, "XTSObject - execute", null, null);
                            }
                            if ((mode & 2) > 0) {
                                timer.pause();
                                debuglogger = XTSDebugManager.getInstance().getLogger();
                                if (debuglogger != null) {
                                    debuglogger.log(env, env.getDebugRequestPath(), "output.xml", rootDoc);
                                }
                                timer.unpause();
                            }
                            break block56;
                        }
                        Object[] args = new String[]{morphlet, env.getLocale().getDisplayName()};
                        throw new XTSException("processor.objectcreationfailed", args);
                    }
                    catch (XTSException e) {
                        if ((mode & 2) > 0) {
                            timer.pause();
                            Element errorXMLElem = UXTSExceptionUtils.generateFaultXML(e, env.getLocale(), true);
                            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                            if (debuglogger != null) {
                                debuglogger.log(env, env.getDebugRequestPath(), "error.xml", errorXMLElem);
                            }
                            timer.unpause();
                        }
                        throw new XTSException("processor.executefailed", e);
                    }
                    catch (Throwable e) {
                        if ((mode & 2) > 0) {
                            StringBuffer msg = new StringBuffer();
                            msg.append("Message: ");
                            msg.append(e.getMessage());
                            msg.append("\r\n");
                            ByteArrayIOStream bio = new ByteArrayIOStream(4096);
                            PrintWriter stackTrace = new PrintWriter(bio);
                            e.printStackTrace(stackTrace);
                            stackTrace.close();
                            stackTrace.flush();
                            try {
                                msg.append("StackTrace:");
                                msg.append(new String(bio.toByteArray(), "UTF-8"));
                            }
                            catch (UnsupportedEncodingException e2) {
                                msg.append("Exception occurred while getting stack trace: ");
                                msg.append(e2.getMessage());
                            }
                            timer.pause();
                            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                            if (debuglogger != null) {
                                debuglogger.log(env, env.getDebugRequestPath(), "error.txt", msg.toString());
                            }
                            timer.unpause();
                        }
                        throw new XTSException("processor.executefailed", e);
                    }
                    finally {
                        if ((mode & 2) > 0) {
                            timer.stop();
                            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                            if (debuglogger != null) {
                                debuglogger.log(env, env.getDebugRequestPath(), "timing.xml", timer.toXMLString());
                                debuglogger.generateManifest(env.getDebugRequestPath());
                            }
                        }
                    }
                }
                if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger2 != null) {
                    traceLogger2.log(null, 5, "XTSProccessor - execute", null, null);
                }
            }
            finally {
                this.m_oMutex.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            throw new XTSException("processor.executefailed", e);
        }
    }

    private void addDebugElement(XTSEnvironment env, int mode, String morphlet, Document rootDoc) throws XTSException {
        Element debugElement = DocumentHelper.createElement((String)"debug");
        rootDoc.getRootElement().add(debugElement);
        Element traceOutput = DocumentHelper.createElement((String)"traceOutput");
        if ((mode & 2) > 0) {
            traceOutput.addText("true");
        } else {
            traceOutput.addText("false");
        }
        debugElement.add(traceOutput);
        Element debugSwitch = DocumentHelper.createElement((String)"debugSwitch");
        if (!this.m_debugEnable) {
            debugSwitch.addText("disable");
        } else if (XTSDebugManager.getInstance().getLogger().isDebugAll()) {
            debugSwitch.addText("all");
        } else {
            debugSwitch.addText("request");
        }
        debugElement.add(debugSwitch);
        if ((mode & 2) > 0) {
            long time = System.currentTimeMillis();
            StringBuffer requestPathBuf = new StringBuffer(morphlet);
            requestPathBuf.append("/").append("execution-").append(time);
            String requestPath = PathUtils.normalizeToPath(requestPathBuf.toString());
            Element traceRequest = DocumentHelper.createElement((String)"traceRequestPath");
            traceRequest.addText(requestPath);
            debugElement.add(traceRequest);
            String debugBasedir = null;
            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debugBasedir = debuglogger.getBaseDirPath();
            }
            String debugRequestPath = null;
            try {
                debugRequestPath = PathUtils.buildPath(debugBasedir, requestPath);
            }
            catch (IOException e) {
                Object[] args = new String[]{debugBasedir, requestPath};
                throw new XTSException("processor.buildfullpathfailed", args, e);
            }
            env.setDebugRequestPath(debugRequestPath);
        }
    }

    class _reinitThread
    extends Thread {
        XTSProcessor m_processor;
        IXTSConfiguration m_config;
        IXTSResourceReader m_reader;
        IXTSPropertiesCallback m_callback;
        Properties m_props;
        boolean m_full;

        public _reinitThread(XTSProcessor processor, IXTSConfiguration config, IXTSResourceReader reader, IXTSPropertiesCallback callback, Properties props, boolean full) {
            this.m_processor = processor;
            this.m_config = config;
            this.m_reader = reader;
            this.m_callback = callback;
            this.m_props = props;
            this.m_full = full;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.m_processor.doReinitialize(this.m_config, this.m_reader, this.m_callback, this.m_props, this.m_full);
                }
                catch (XTSException e) {
                    IXTSLogger traceLogger1 = null;
                    if (!XTSTraceLoggerManager.getInstance().isEnabled[0][0] || (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) == null) break block2;
                    traceLogger1.log(null, 0, "XTSProcessor fail to start: " + e.getLocalizedMsgString(Locale.getDefault()), null, null);
                }
            }
        }
    }

    class _terminateThread
    extends Thread {
        XTSProcessor m_processor;

        public _terminateThread(XTSProcessor processor) {
            this.m_processor = processor;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.m_processor.doTerminate();
                }
                catch (XTSException e) {
                    IXTSLogger traceLogger1 = null;
                    if (!XTSTraceLoggerManager.getInstance().isEnabled[0][0] || (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) == null) break block2;
                    traceLogger1.log(null, 1, "XTSProcessor fail to stop: " + e.getLocalizedMsgString(Locale.getDefault()), null, null);
                }
            }
        }
    }

    class _initThread
    extends Thread {
        XTSProcessor m_processor;
        IXTSConfiguration m_config;
        IXTSResourceReader m_reader;
        IXTSPropertiesCallback m_callback;
        Properties m_props;

        public _initThread(XTSProcessor processor, IXTSConfiguration config, IXTSResourceReader reader, IXTSPropertiesCallback callback, Properties props) {
            this.m_processor = processor;
            this.m_config = config;
            this.m_reader = reader;
            this.m_callback = callback;
            this.m_props = props;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.m_processor.doInitialize(this.m_config, this.m_reader, this.m_callback, this.m_props);
                }
                catch (XTSException e) {
                    IXTSLogger traceLogger1 = null;
                    if (!XTSTraceLoggerManager.getInstance().isEnabled[0][0] || (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) == null) break block2;
                    traceLogger1.log(null, 0, "XTSProcessor fail to start: " + e.getLocalizedMsgString(Locale.getDefault()), null, null);
                }
            }
        }
    }
}

