/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts;

import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.SAXWriter;
import org.dom4j.tree.NamespaceStack;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XTSSAXWriter
extends SAXWriter {
    private HashMap m_nodemap = null;

    public XTSSAXWriter(HashMap nodemap) {
        this.m_nodemap = nodemap;
    }

    public void write(Document doc) throws SAXException {
        if (doc != null) {
            this.checkForNullHandlers();
            this.documentLocator(doc);
            this.startDocument();
            this.entityResolver(doc);
            this.dtdHandler(doc);
            this.writeDocContent((Branch)doc, new NamespaceStack());
            this.endDocument();
        }
    }

    public void write(String text) throws SAXException {
        if (text != null) {
            super.write(text);
        }
    }

    protected void writeDocContent(Branch branch, NamespaceStack namespaceStack) throws SAXException {
        Iterator it = branch.nodeIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof Element) {
                this.writeRootElement((Element)object, namespaceStack);
                continue;
            }
            if (object instanceof CharacterData) {
                if (object instanceof Text) {
                    Text text = (Text)object;
                    this.write(text.getText());
                    continue;
                }
                if (object instanceof CDATA) {
                    this.write((CDATA)object);
                    continue;
                }
                if (object instanceof Comment) {
                    this.write((Comment)object);
                    continue;
                }
                throw new SAXException("Invalid Node in DOM4J content: " + object);
            }
            if (object instanceof String) {
                this.write((String)object);
                continue;
            }
            if (object instanceof Entity) {
                this.write((Entity)object);
                continue;
            }
            if (object instanceof ProcessingInstruction) {
                this.write((ProcessingInstruction)object);
                continue;
            }
            if (object instanceof Namespace) continue;
            throw new SAXException("Invalid Node in DOM4J content: " + object);
        }
    }

    protected void writeRootElement(Element element, NamespaceStack namespaceStack) throws SAXException {
        int stackSize = namespaceStack.size();
        AttributesImpl namespaceAttributes = this.startPrefixMapping(element, namespaceStack);
        this.startElement(element, namespaceAttributes);
        this.writeRootElementContent((Branch)element, namespaceStack);
        this.endElement(element);
        this.endPrefixMapping(namespaceStack, stackSize);
    }

    protected void writeRootElementContent(Branch branch, NamespaceStack namespaceStack) throws SAXException {
        Iterator it = branch.nodeIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof Element) {
                if (this.m_nodemap == null) {
                    this.write((Element)object, namespaceStack);
                    continue;
                }
                String name = ((Element)object).getQualifiedName();
                if (!this.m_nodemap.containsKey(name)) continue;
                this.write((Element)object, namespaceStack);
                continue;
            }
            if (object instanceof CharacterData) {
                if (object instanceof Text) {
                    Text text = (Text)object;
                    this.write(text.getText());
                    continue;
                }
                if (object instanceof CDATA) {
                    this.write((CDATA)object);
                    continue;
                }
                if (object instanceof Comment) {
                    this.write((Comment)object);
                    continue;
                }
                throw new SAXException("Invalid Node in DOM4J content: " + object);
            }
            if (object instanceof String) {
                this.write((String)object);
                continue;
            }
            if (object instanceof Entity) {
                this.write((Entity)object);
                continue;
            }
            if (object instanceof ProcessingInstruction) {
                this.write((ProcessingInstruction)object);
                continue;
            }
            if (object instanceof Namespace) continue;
            throw new SAXException("Invalid Node in DOM4J content: " + object);
        }
    }
}

