/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.application;

import com.cognos.xts.XTSException;
import com.cognos.xts.configuration.IXTSConfiguration;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSAuditLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.messages.MessagesManager;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.util.BasicTransformer;
import com.cognos.xts.util.ByteArrayIOStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Comment;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ApplicationUtils {
    private static final String OPTION_FILE = "system.xml";
    private static final String XSLT_FILE = "system_upgrade.xslt";
    private static final String ATT_VERSION = "version";
    private static final int OUTPUT_BUFFER_SIZE = 8192;

    public static Element readFile(String file) throws XTSException {
        InputStream is = XTSResourceManager.getInstance().getResource(file);
        if (is == null) {
            return null;
        }
        try {
            return new SAXReader().read(is).getRootElement();
        }
        catch (DocumentException e) {
            throw new XTSException("application.invalidsystemxml", e);
        }
    }

    public static Element upgradeSystem(String file, Element sysElement, double curVersion) throws XTSException {
        Element returnElement;
        block11: {
            returnElement = sysElement;
            ByteArrayIOStream bioResult = null;
            try {
                block12: {
                    String fileVersion = sysElement.attributeValue(ATT_VERSION);
                    if (fileVersion != null && !(Double.parseDouble(fileVersion) < curVersion)) break block11;
                    int filenamePos = file.lastIndexOf(OPTION_FILE);
                    String xsltSrc = file.substring(0, filenamePos) + XSLT_FILE;
                    InputStream inXSLTStream = XTSResourceManager.getInstance().getResource(xsltSrc);
                    if (inXSLTStream == null) break block11;
                    StreamSource stylesheetSource = new StreamSource(inXSLTStream);
                    stylesheetSource.setSystemId(xsltSrc);
                    BasicTransformer transformer = new BasicTransformer(stylesheetSource);
                    StreamSource systemSource = new StreamSource(new StringReader(sysElement.asXML()));
                    ByteArrayIOStream bioIntermediateResult = new ByteArrayIOStream(8192);
                    transformer.transform(systemSource, new StreamResult(bioIntermediateResult));
                    StreamSource transformedResultSource = new StreamSource(new InputStreamReader(bioIntermediateResult.convert()));
                    String xslt = "<?xml version='1.0' encoding='UTF-8'?><xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'><xsl:output method='xml' version='1.0' encoding='UTF-8' indent='yes'/><xsl:template match='comment()'><xsl:comment><xsl:value-of select='.' /></xsl:comment></xsl:template><xsl:template match='system'><system version='" + curVersion + "'><xsl:copy-of select='./*|comment()'/></system></xsl:template></xsl:stylesheet>";
                    StringReader readerSourceXSLT = new StringReader(xslt);
                    stylesheetSource = new StreamSource(readerSourceXSLT);
                    transformer = new BasicTransformer(stylesheetSource);
                    bioResult = new ByteArrayIOStream(8192);
                    transformer.transform(transformedResultSource, new StreamResult(bioResult));
                    try {
                        IXTSLogger logger;
                        FileOutputStream fos;
                        String sBkpFile;
                        File bkpFile;
                        File outfile;
                        String templateRoot = PathUtils.normalizeToPath(PropertiesManager.getInstance().getProperty("template.root"));
                        String sFile = PathUtils.buildPath(templateRoot, file);
                        IXTSConfiguration config = XTSConfigManager.getInstance().getConfiguration();
                        if (config != null) {
                            sFile = config.getPhysicalPath(sFile);
                        }
                        if ((outfile = new File(sFile)).exists() && !outfile.renameTo(bkpFile = new File(sBkpFile = sFile + ".bkp." + System.currentTimeMillis()))) {
                            outfile.delete();
                        }
                        if ((fos = new FileOutputStream(outfile)) == null) {
                            throw new Exception("write failed");
                        }
                        fos.write(bioResult.toByteArray());
                        fos.flush();
                        fos.close();
                        Object[] args = new String[]{file};
                        StringBuffer msg = new StringBuffer();
                        msg.append(MessagesManager.getInstance().getMessage(Locale.getDefault(), "application.systemxmlwritesuccess", args));
                        if (XTSAuditLoggerManager.getInstance().isEnabled[0][0] && (logger = XTSAuditLoggerManager.getInstance().getLogger(0, 0)) != null) {
                            logger.log(null, 4, "success", msg.toString(), null);
                        }
                        IXTSLogger traceLogger1 = null;
                        if (XTSTraceLoggerManager.getInstance().isEnabled[0][0] && (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) != null) {
                            traceLogger1.log(null, 8, msg.toString(), null, null);
                        }
                    }
                    catch (Exception e) {
                        IXTSLogger logger;
                        Object[] args = new String[]{file};
                        StringBuffer msg = new StringBuffer();
                        msg.append(MessagesManager.getInstance().getMessage(Locale.getDefault(), "application.systemxmlwritefailed", args));
                        if (XTSAuditLoggerManager.getInstance().isEnabled[0][0] && (logger = XTSAuditLoggerManager.getInstance().getLogger(0, 0)) != null) {
                            logger.log(null, 0, "failure", msg.toString(), null);
                        }
                        IXTSLogger traceLogger1 = null;
                        if (!XTSTraceLoggerManager.getInstance().isEnabled[0][0] || (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) == null) break block12;
                        traceLogger1.log(null, 8, msg.toString(), null, null);
                    }
                }
                returnElement = new SAXReader().read((InputStream)bioResult.convert()).getRootElement();
            }
            catch (Exception e) {
                IXTSLogger logger;
                Object[] args = new String[]{file};
                if (XTSAuditLoggerManager.getInstance().isEnabled[0][0] && (logger = XTSAuditLoggerManager.getInstance().getLogger(0, 0)) != null) {
                    logger.log(null, 0, "failure", MessagesManager.getInstance().getMessage(Locale.getDefault(), "application.invalidsystemxmlupgrade", args), null);
                }
                throw new XTSException("application.invalidsystemxmlupgrade", args, e);
            }
        }
        return returnElement;
    }

    public static void updateSystemOptionsMap(HashMap oMap, Element systemEle) throws XTSException {
        if (!systemEle.getName().equals("system")) {
            throw new XTSException("application.invalidsystemxml");
        }
        systemEle = ApplicationUtils.trimComment(systemEle);
        for (Element parmEle : systemEle.elements()) {
            String name = parmEle.attributeValue("name");
            if (name == null || name.length() == 0) {
                throw new XTSException("application.invalidsystemxml");
            }
            oMap.put(name, parmEle);
        }
    }

    public static Element createSystemElement(HashMap oMap) {
        Element systemEle = DocumentHelper.createElement((String)"system");
        Iterator it = oMap.values().iterator();
        while (it.hasNext()) {
            systemEle.add(((Element)it.next()).createCopy());
        }
        return systemEle;
    }

    public static void updateProcessingOptionsMap(HashMap poMap, Element poEle) throws XTSException {
        if (!poEle.getName().equals("processing")) {
            throw new XTSException("application.invalidprocessingxml");
        }
        for (Element parmEle : poEle.elements()) {
            String name = parmEle.attributeValue("name");
            if (name == null || name.length() == 0) {
                throw new XTSException("application.invalidprocessingxml");
            }
            poMap.put(name, parmEle);
        }
    }

    public static Element createProcessingOptionsElement(HashMap poMap) {
        Element poEle = DocumentHelper.createElement((String)"processing");
        Iterator it = poMap.values().iterator();
        while (it.hasNext()) {
            Element ele = ((Element)it.next()).createCopy();
            poEle.add(ele);
        }
        return poEle;
    }

    public static Element trimComment(Element ele) {
        int size = ele.nodeCount();
        int i = 0;
        while (i < size) {
            Node node = ele.node(i);
            if (node instanceof Comment) {
                node.detach();
            } else if (node instanceof Element) {
                ApplicationUtils.trimComment((Element)node);
                ++i;
            } else {
                ++i;
            }
            size = ele.nodeCount();
        }
        return ele;
    }
}

